#
# eduroam-TH monitoring device flash tool -- DoIT ESP32 DevKitV1
#
# Version: 1.0 - 2019-10-30
# Copyright: Prakai Nadee <prakai@rmuti.ac.th>
#

cls
Write-Host "======================================================================="
Write-Host "=============== eduroam-TH monitoring device flash tool ==============="
Write-Host "======================================================================="
Write-Host

Write-Host "1) Connect DoIT ESP32 DevKitV1 to computer"
Write-Host
pause
Write-Host

$global:cs = $null

function Menu
{
	cls
	Write-Host "======================================================================="
	Write-Host "=============== eduroam-TH monitoring device flash tool ==============="
	Write-Host "======================================================================="
	Write-Host
	Write-Host "2) Select a COM port"
	Write-Host

	# Get list of COM port
	$global:cs = (Get-WmiObject -query "SELECT * FROM Win32_PnPEntity" | Where {$_.Name -Match "COM\d+"}).name

	$i = 0
	Foreach ($c in $global:cs) {
		$i++
		Write-Host $i":" $c
	}
	Write-Host "Q: Press 'Q' to quit."
	Write-Host 
}

do
{
	Menu
	$k = Read-Host "Please select COM port"
	if ($k -eq 'q') {
		return
	} else {
		$k = $k - 1
		if ($k -ge 0 -and $k -lt $global:cs.count) {
			cls
			Write-Host "======================================================================="
			Write-Host "=============== eduroam-TH monitoring device flash tool ==============="
			Write-Host "======================================================================="
			Write-Host
			Write-Host "3) Long press BOOT button if flashing does not start in 5 seconds" 
			Write-Host

			Write-Host "Flashing:" $global:cs[$k]
			$n = $global:cs[$k].split("(")[1]
			$n = $n.Substring(0, $n.Length-1)

			Write-Host "======================================================================="

			# Flashing command
			$c = ".\esptool.exe --chip esp32 --port $n --baud 921600 --before default_reset --after hard_reset write_flash -z --flash_mode dio --flash_freq 80m --flash_size detect 0xe000 boot_app0.bin 0x1000 bootloader_dio_80m.bin 0x10000 ESP32-eduroam-mon.ino.doitESP32devkitV1.bin 0x8000 ESP32-eduroam-mon.ino.partitions.bin"

						# Execute flashing command
			iex $c

			Write-Host
			Write-Host "======================================================================="
			Write-Host "4) Disconnect DoIT ESP32 DevKitV1 from computer to stop serial monitor"
			Write-Host "======================================================================="

			try {
				$port= new-Object System.IO.Ports.SerialPort $n,115200,None,8,one
				$port.Open()
				do {
					$line = $port.ReadLine()
					Write-Host $line
				}
				while ($port.IsOpen)
			} catch {}

			return
		}
	}
}
until ($k -eq 'q')