/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.PrimitiveOptionsDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;

public class PrimitiveOptionsAction
implements IViewActionDelegate,
IActionDelegate2 {
    private static String[][] fgPreferenceInfo = new String[][]{{IJDIPreferencesConstants.PREF_SHOW_HEX, "SHOW_HEX_VALUES"}, {IJDIPreferencesConstants.PREF_SHOW_CHAR, "SHOW_CHAR_VALUES"}, {IJDIPreferencesConstants.PREF_SHOW_UNSIGNED, "SHOW_UNSIGNED_VALUES"}};
    protected IViewPart fView;
    static /* synthetic */ Class class$0;

    public void init(IViewPart view) {
        this.fView = view;
        this.applyPreferences();
    }

    protected void applyPreferences() {
        IDebugModelPresentation presentation;
        IDebugView view;
        IViewPart iViewPart = this.getView();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((view = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null && (presentation = view.getPresentation(JDIDebugModel.getPluginIdentifier())) != null) {
            int i = 0;
            while (i < fgPreferenceInfo.length) {
                this.applyPreference(fgPreferenceInfo[i][0], fgPreferenceInfo[i][1], presentation);
                ++i;
            }
        }
    }

    protected void applyPreference(String preference, String attribute, IDebugModelPresentation presentation) {
        boolean on = PrimitiveOptionsAction.getBooleanPreferenceValue(this.getView().getSite().getId(), preference);
        presentation.setAttribute(attribute, (Object)(on ? Boolean.TRUE : Boolean.FALSE));
    }

    protected Dialog getDialog() {
        IViewSite viewSite = this.getView().getViewSite();
        return new PrimitiveOptionsDialog(viewSite.getShell(), viewSite.getId());
    }

    protected IViewPart getView() {
        return this.fView;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        int res = this.getDialog().open();
        if (res == 0) {
            final Viewer viewer = this.getViewer();
            BusyIndicator.showWhile((Display)viewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    PrimitiveOptionsAction.this.applyPreferences();
                    viewer.refresh();
                    JDIDebugUIPlugin.getDefault().savePluginPreferences();
                }
            });
        }
    }

    protected Viewer getViewer() {
        IDebugView view;
        IViewPart iViewPart = this.getView();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.ui.IDebugView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((view = (IDebugView)iViewPart.getAdapter((Class)clazz)) != null) {
            return view.getViewer();
        }
        return null;
    }

    public static boolean getBooleanPreferenceValue(String id, String preference) {
        String compositeKey = String.valueOf(id) + "." + preference;
        IPreferenceStore store = JDIDebugUIPlugin.getDefault().getPreferenceStore();
        boolean value = false;
        value = store.contains(compositeKey) ? store.getBoolean(compositeKey) : store.getBoolean(preference);
        return value;
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

