/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.refactoring;

import java.text.MessageFormat;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaMethodBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.core.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.actions.ToggleBreakpointAdapter;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class JavaMethodBreakpointMethodNameChange
extends Change {
    private IJavaMethodBreakpoint fMethodBreakpoint;
    private String fNewMethodName;
    private String fOldMethodName;
    private IType fDeclaringType;

    public static Change createChange(IMethod method, String newName) throws CoreException {
        IType declaringType = method.getDeclaringType();
        String typeName = declaringType.getFullyQualifiedName();
        String methodName = method.getElementName();
        String methodSignature = ToggleBreakpointAdapter.resolveMethodSignature(declaringType, method.getSignature());
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        IBreakpoint[] breakpoints = breakpointManager.getBreakpoints(JDIDebugModel.getPluginIdentifier());
        int i = 0;
        while (i < breakpoints.length) {
            IJavaMethodBreakpoint methodBreakpoint;
            IBreakpoint breakpoint = breakpoints[i];
            if (breakpoint instanceof IJavaMethodBreakpoint && typeName.equals((methodBreakpoint = (IJavaMethodBreakpoint)breakpoint).getTypeName()) && methodName.equals(methodBreakpoint.getMethodName()) && methodSignature.equals(methodBreakpoint.getMethodSignature())) {
                return new JavaMethodBreakpointMethodNameChange(methodBreakpoint, newName);
            }
            ++i;
        }
        return null;
    }

    protected JavaMethodBreakpointMethodNameChange(IJavaMethodBreakpoint methodBreakpoint, String newName) throws CoreException {
        this.fMethodBreakpoint = methodBreakpoint;
        this.fNewMethodName = newName;
        this.fOldMethodName = this.fMethodBreakpoint.getMethodName();
        this.fDeclaringType = BreakpointUtils.getType((IJavaBreakpoint)methodBreakpoint);
    }

    public String getName() {
        return MessageFormat.format(RefactoringMessages.JavaMethodBreakpointMethodNameChange_0, this.fDeclaringType.getElementName(), this.fOldMethodName);
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus status = new RefactoringStatus();
        if (!this.fMethodBreakpoint.isRegistered()) {
            status.addFatalError(MessageFormat.format(RefactoringMessages.JavaMethodBreakpointMethodNameChange_1, this.fDeclaringType.getElementName(), this.fOldMethodName));
        }
        return status;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        String methodSignature = this.fMethodBreakpoint.getMethodSignature();
        String[] parameterTypes = Signature.getParameterTypes((String)methodSignature);
        int i = 0;
        while (i < parameterTypes.length) {
            parameterTypes[i] = parameterTypes[i].replace('/', '.');
            ++i;
        }
        IMethod method = this.fDeclaringType.getMethod(this.fNewMethodName, parameterTypes);
        Map attributes = this.fMethodBreakpoint.getMarker().getAttributes();
        BreakpointUtils.addJavaBreakpointAttributes(attributes, (IJavaElement)method);
        boolean isEnable = this.fMethodBreakpoint.isEnabled();
        IJavaMethodBreakpoint newMethodBreakpoint = JDIDebugModel.createMethodBreakpoint((IResource)this.fMethodBreakpoint.getMarker().getResource(), (String)this.fMethodBreakpoint.getTypeName(), (String)this.fNewMethodName, (String)methodSignature, (boolean)this.fMethodBreakpoint.isEntry(), (boolean)this.fMethodBreakpoint.isExit(), (boolean)this.fMethodBreakpoint.isNativeOnly(), (int)this.fMethodBreakpoint.getLineNumber(), (int)this.fMethodBreakpoint.getCharStart(), (int)this.fMethodBreakpoint.getCharEnd(), (int)this.fMethodBreakpoint.getHitCount(), (boolean)true, (Map)attributes);
        newMethodBreakpoint.setEnabled(isEnable);
        this.fMethodBreakpoint.delete();
        return new JavaMethodBreakpointMethodNameChange(newMethodBreakpoint, this.fOldMethodName);
    }

    public Object getModifiedElement() {
        return this.fMethodBreakpoint;
    }
}

