/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.debug.ui;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.ui.IJavaDebugUIConstants;
import org.eclipse.jdt.debug.ui.JavaSourceLookupDialog;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.internal.debug.ui.launcher.SourceElementLabelProvider;
import org.eclipse.jdt.internal.debug.ui.launcher.SourceElementQualifierProvider;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.sourcelookup.IJavaSourceLocation;
import org.eclipse.jdt.launching.sourcelookup.JavaSourceLocator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;

public class JavaUISourceLocator
implements IPersistableSourceLocator {
    public static final String ID_PROMPTING_JAVA_SOURCE_LOCATOR = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".javaSourceLocator";
    public static final String ATTR_FIND_ALL_SOURCE_ELEMENTS = String.valueOf(IJavaDebugUIConstants.PLUGIN_ID) + ".ATTR_FIND_ALL_SOURCE_ELEMENTS";
    private IJavaProject fJavaProject;
    private JavaSourceLocator fSourceLocator;
    private boolean fAllowedToAsk;
    private boolean fIsFindAllSourceElements = false;
    private HashMap fTypesToSource = null;
    static /* synthetic */ Class class$0;

    public JavaUISourceLocator() {
        this.fSourceLocator = new JavaSourceLocator();
        this.fAllowedToAsk = true;
    }

    public JavaUISourceLocator(IJavaProject[] projects, boolean includeRequired) throws JavaModelException {
        this.fSourceLocator = new JavaSourceLocator(projects, includeRequired);
        this.fAllowedToAsk = true;
    }

    public JavaUISourceLocator(IJavaProject project) throws CoreException {
        this.fJavaProject = project;
        IJavaSourceLocation[] sls = JavaSourceLocator.getDefaultSourceLocations((IJavaProject)project);
        this.fSourceLocator = new JavaSourceLocator(project);
        if (sls != null) {
            this.fSourceLocator.setSourceLocations(sls);
        }
        this.fAllowedToAsk = true;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        Object res = this.findSourceElement(stackFrame);
        if (res == null && this.fAllowedToAsk) {
            IJavaStackFrame frame;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.debug.core.IJavaStackFrame");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((frame = (IJavaStackFrame)stackFrame.getAdapter((Class)clazz)) != null) {
                try {
                    if (!frame.isObsolete()) {
                        this.showDebugSourcePage(frame);
                        res = this.fSourceLocator.getSourceElement(stackFrame);
                    }
                }
                catch (DebugException debugException) {}
            }
        }
        return res;
    }

    private Object findSourceElement(IStackFrame stackFrame) {
        if (this.isFindAllSourceElements()) {
            Object[] sourceElements = this.fSourceLocator.getSourceElements(stackFrame);
            if (sourceElements == null || sourceElements.length == 0) {
                return null;
            }
            if (sourceElements.length == 1) {
                return sourceElements[0];
            }
            try {
                IJavaStackFrame frame = (IJavaStackFrame)stackFrame;
                IJavaReferenceType type = frame.getReferenceType();
                Object cachedSource = this.getSourceElement(type);
                if (cachedSource != null) {
                    return cachedSource;
                }
                TwoPaneElementSelector dialog = new TwoPaneElementSelector(JDIDebugUIPlugin.getActiveWorkbenchShell(), (ILabelProvider)new SourceElementLabelProvider(), (ILabelProvider)new SourceElementQualifierProvider());
                dialog.setTitle(DebugUIMessages.JavaUISourceLocator_Select_Source_1);
                dialog.setMessage(MessageFormat.format(DebugUIMessages.JavaUISourceLocator__Select_the_source_that_corresponds_to__0__2, type.getName()));
                dialog.setElements(sourceElements);
                dialog.setMultipleSelection(false);
                dialog.setUpperListLabel(DebugUIMessages.JavaUISourceLocator__Matching_files__3);
                dialog.setLowerListLabel(DebugUIMessages.JavaUISourceLocator__Location__4);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null) {
                    return null;
                }
                Object sourceElement = result[0];
                this.cacheSourceElement(sourceElement, type);
                return sourceElement;
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
                return sourceElements[0];
            }
        }
        return this.fSourceLocator.getSourceElement(stackFrame);
    }

    private Object getSourceElement(IJavaReferenceType type) {
        if (this.fTypesToSource == null) {
            return null;
        }
        return this.fTypesToSource.get(type);
    }

    private void cacheSourceElement(Object sourceElement, IJavaReferenceType type) {
        if (this.fTypesToSource == null) {
            this.fTypesToSource = new HashMap();
        }
        this.fTypesToSource.put(type, sourceElement);
    }

    private void showDebugSourcePage(final IJavaStackFrame frame) {
        Runnable prompter = new Runnable(){

            public void run() {
                block3: {
                    try {
                        String message = MessageFormat.format(LauncherMessages.JavaUISourceLocator_selectprojects_message, frame.getDeclaringTypeName());
                        ILaunchConfiguration configuration = frame.getLaunch().getLaunchConfiguration();
                        JavaSourceLookupDialog dialog = new JavaSourceLookupDialog(JDIDebugUIPlugin.getActiveWorkbenchShell(), message, configuration);
                        int result = dialog.open();
                        if (result == 0) {
                            JavaUISourceLocator.this.fAllowedToAsk = !dialog.isNotAskAgain();
                            JavaUISourceLocator.this.initializeDefaults(configuration);
                        }
                    }
                    catch (CoreException e) {
                        if (e.getStatus().getCode() == 100) break block3;
                        JDIDebugUIPlugin.log(e);
                    }
                }
            }
        };
        JDIDebugUIPlugin.getStandardDisplay().syncExec(prompter);
    }

    public String getMemento() throws CoreException {
        String memento = this.fSourceLocator.getMemento();
        String handle = this.fJavaProject.getHandleIdentifier();
        String findAll = new Boolean(this.isFindAllSourceElements()).toString();
        StringBuffer buffer = new StringBuffer();
        buffer.append("<project>");
        buffer.append(handle);
        buffer.append("</project>");
        buffer.append("<findAll>");
        buffer.append(findAll);
        buffer.append("</findAll>");
        buffer.append(memento);
        return buffer.toString();
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        this.fSourceLocator.initializeDefaults(configuration);
        this.fJavaProject = JavaRuntime.getJavaProject((ILaunchConfiguration)configuration);
        this.fIsFindAllSourceElements = configuration.getAttribute(ATTR_FIND_ALL_SOURCE_ELEMENTS, false);
    }

    public void initializeFromMemento(String memento) throws CoreException {
        if (memento.startsWith("<project>")) {
            int index = memento.indexOf("</project>");
            if (index > 0) {
                String handle = memento.substring(9, index);
                int start = index + 19;
                if ((index = memento.indexOf("</findAll>", start)) > 0) {
                    String findAll = memento.substring(start, index);
                    Boolean all = new Boolean(findAll);
                    String rest = memento.substring(index + 10);
                    this.fJavaProject = (IJavaProject)JavaCore.create((String)handle);
                    this.fIsFindAllSourceElements = all;
                    this.fSourceLocator.initializeFromMemento(rest);
                }
            }
        } else {
            int index = memento.indexOf(10);
            String handle = memento.substring(0, index);
            String rest = memento.substring(index + 1);
            this.fJavaProject = (IJavaProject)JavaCore.create((String)handle);
            this.fIsFindAllSourceElements = false;
            this.fSourceLocator.initializeFromMemento(rest);
        }
    }

    public IJavaSourceLocation[] getSourceLocations() {
        return this.fSourceLocator.getSourceLocations();
    }

    public void setSourceLocations(IJavaSourceLocation[] locations) {
        this.fSourceLocator.setSourceLocations(locations);
    }

    public boolean isFindAllSourceElements() {
        return this.fIsFindAllSourceElements;
    }

    public void setFindAllSourceElement(boolean findAll) {
        this.fIsFindAllSourceElements = findAll;
    }
}

