/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.NLSUtility;

class DocumentInputStream
extends InputStream {
    private volatile CharSequence fCharSequence;
    private int fLength;
    private int fOffset = 0;
    private IDocument fDocument;
    private IDocumentListener fDocumentListener = new InternalDocumentListener();

    public DocumentInputStream(IDocument document) {
        Assert.isNotNull((Object)document);
        this.fDocument = document;
        this.fCharSequence = new DocumentCharSequence(this.fDocument);
        this.fDocument.addDocumentListener(this.fDocumentListener);
        this.fLength = this.fCharSequence.length();
    }

    public int read() throws IOException {
        try {
            return this.fOffset < this.fLength ? (int)this.fCharSequence.charAt(this.fOffset++) : -1;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException(TextEditorMessages.DocumentInputStream_error_streamClosed);
        }
        catch (IndexOutOfBoundsException x) {
            throw new IOException(NLSUtility.format(TextEditorMessages.DocumentInputStream_error_read, x.getLocalizedMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        DocumentInputStream documentInputStream = this;
        synchronized (documentInputStream) {
            this.fCharSequence = null;
        }
        this.releaseDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleDocumentAboutToBeChanged() {
        IDocument document = this.fDocument;
        if (this.fCharSequence == null || document == null) {
            return;
        }
        String content = document.get();
        DocumentInputStream documentInputStream = this;
        synchronized (documentInputStream) {
            if (this.fCharSequence == null) {
                return;
            }
            this.fCharSequence = content;
        }
        this.releaseDocument();
    }

    private synchronized void releaseDocument() {
        if (this.fDocument != null) {
            this.fDocument.removeDocumentListener(this.fDocumentListener);
        }
        this.fDocument = null;
        this.fDocumentListener = null;
    }

    private static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;

        public DocumentCharSequence(IDocument document) {
            this.fDocument = document;
        }

        public int length() {
            return this.fDocument.getLength();
        }

        public char charAt(int index) {
            try {
                return this.fDocument.getChar(index);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }

        public CharSequence subSequence(int start, int end) {
            try {
                return this.fDocument.get(start, end - start);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }
    }

    private class InternalDocumentListener
    implements IDocumentListener {
        InternalDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent event) {
            DocumentInputStream.this.handleDocumentAboutToBeChanged();
        }

        public void documentChanged(DocumentEvent event) {
        }
    }
}

