/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TableRenderingPreferencePage
extends PreferencePage
implements IPropertyChangeListener {
    Combo fColumnSize;
    private int[] fColumnSizes = new int[]{1, 2, 4, 8, 16};
    private BooleanFieldEditor fAutoLoadPref;
    private IntegerFieldEditor fPageSizePref;
    private Composite fBufferComposite;

    public TableRenderingPreferencePage(String title) {
        super(title);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(IDebugUIConstants.PLUGIN_ID) + ".table_renderings_preference_page_context");
        Composite composite = new Composite(parent, 0);
        Composite columnSizeComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        columnSizeComposite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        columnSizeComposite.setLayoutData((Object)data);
        Label textLabel = new Label(columnSizeComposite, 0);
        textLabel.setText(DebugUIMessages.TableRenderingPreferencePage_0);
        this.fColumnSize = new Combo(columnSizeComposite, 2056);
        GridData columnLayout = new GridData();
        this.fColumnSize.setLayoutData((Object)columnLayout);
        int i = 0;
        while (i < this.fColumnSizes.length) {
            this.fColumnSize.add(String.valueOf(this.fColumnSizes[i]));
            ++i;
        }
        int colSize = this.getPreferenceStore().getInt("org.eclipse.debug.ui.memory.columnSize");
        int idx = 0;
        int i2 = 0;
        while (i2 < this.fColumnSizes.length) {
            if (this.fColumnSizes[i2] == colSize) {
                idx = i2;
                break;
            }
            ++i2;
        }
        this.fColumnSize.select(idx);
        this.createSpacer(composite);
        this.fAutoLoadPref = new BooleanFieldEditor("org.eclpise.debug.ui.memory.dynamicLoad", DebugUIMessages.TableRenderingPreferencePage_1, composite);
        this.fAutoLoadPref.setPreferenceStore(this.getPreferenceStore());
        this.fAutoLoadPref.load();
        this.fBufferComposite = new Composite(composite, 0);
        data = new GridData();
        data.horizontalAlignment = 4;
        this.fBufferComposite.setLayoutData((Object)data);
        this.fPageSizePref = new IntegerFieldEditor("org.eclispe.debug.ui.memory.pageSize", DebugUIMessages.TableRenderingPreferencePage_2, this.fBufferComposite);
        this.fPageSizePref.setPreferenceStore(this.getPreferenceStore());
        this.fPageSizePref.load();
        boolean autoLoad = this.getPreferenceStore().getBoolean("org.eclpise.debug.ui.memory.dynamicLoad");
        if (autoLoad) {
            this.fPageSizePref.setEnabled(false, this.fBufferComposite);
        } else {
            this.fPageSizePref.setEnabled(true, this.fBufferComposite);
        }
        this.fAutoLoadPref.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPageSizePref.setPropertyChangeListener((IPropertyChangeListener)this);
        this.fPageSizePref.setValidRange(1, Integer.MAX_VALUE);
        return composite;
    }

    public boolean performOk() {
        int idx = this.fColumnSize.getSelectionIndex();
        int colSize = this.fColumnSizes[idx];
        this.getPreferenceStore().setValue("org.eclipse.debug.ui.memory.columnSize", colSize);
        this.fAutoLoadPref.store();
        this.fPageSizePref.store();
        return super.performOk();
    }

    protected void performDefaults() {
        int colSize = 4;
        this.getPreferenceStore().setValue("org.eclipse.debug.ui.memory.columnSize", colSize);
        int idx = -1;
        int i = 0;
        while (i < this.fColumnSizes.length) {
            if (colSize == this.fColumnSizes[i]) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx > 0) {
            this.fColumnSize.select(idx);
        }
        this.fAutoLoadPref.loadDefault();
        this.fPageSizePref.loadDefault();
        super.performDefaults();
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return DebugUIPlugin.getDefault().getPreferenceStore();
    }

    private void createSpacer(Composite composite) {
        Label spacer = new Label(composite, 0);
        GridData spacerData = new GridData();
        spacerData.horizontalSpan = 1;
        spacer.setLayoutData((Object)spacerData);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.fAutoLoadPref)) {
            boolean autoLoad = this.fAutoLoadPref.getBooleanValue();
            if (autoLoad) {
                this.fPageSizePref.setEnabled(false, this.fBufferComposite);
            } else {
                this.fPageSizePref.setEnabled(true, this.fBufferComposite);
            }
            this.validatePageSize();
        }
        if (event.getProperty().equals("field_editor_value") && event.getSource().equals(this.fPageSizePref)) {
            this.validatePageSize();
        }
    }

    private void validatePageSize() {
        block4: {
            boolean autoLoad = this.fAutoLoadPref.getBooleanValue();
            try {
                int bufferSize = this.fPageSizePref.getIntValue();
                if (!autoLoad && bufferSize < 1) {
                    this.setValid(false);
                    this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_3);
                } else {
                    this.setValid(true);
                    this.setErrorMessage(null);
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (autoLoad) break block4;
                this.setValid(false);
                this.setErrorMessage(DebugUIMessages.TableRenderingPreferencePage_4);
            }
        }
    }

    public void dispose() {
        this.fAutoLoadPref.setPropertyChangeListener(null);
        this.fPageSizePref.setPropertyChangeListener(null);
        super.dispose();
    }
}

