/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.RemoteTreeViewer;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.progress.PendingUpdateAdapter;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.progress.WorkbenchJob;
import org.osgi.framework.Bundle;

public class RemoteTreeContentManager
extends DeferredTreeContentManager {
    private RemoteTreeViewer fViewer;
    private IWorkbenchSiteProgressService progressService;
    private Job fFetchJob = new FetchJob();
    private List fElementQueue = new ArrayList();
    private List fCollectors = new ArrayList();
    private List fAdapaters = new ArrayList();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public RemoteTreeContentManager(ITreeContentProvider provider, RemoteTreeViewer viewer, IWorkbenchPartSite site) {
        super(provider, (AbstractTreeViewer)viewer, site);
        Object siteService;
        this.fViewer = viewer;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.progress.IWorkbenchSiteProgressService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((siteService = site.getAdapter((Class)clazz)) != null) {
            this.progressService = (IWorkbenchSiteProgressService)siteService;
        }
    }

    protected IElementCollector createElementCollector(Object parent, PendingUpdateAdapter placeholder) {
        return new Collector(parent);
    }

    public Object[] getChildren(Object parent) {
        IDeferredWorkbenchAdapter element = this.getAdapter(parent);
        if (element == null) {
            return null;
        }
        Object[] currentChildren = this.fViewer.getCurrentChildren(parent);
        PendingUpdateAdapter placeholder = null;
        if (currentChildren == null || currentChildren.length == 0) {
            placeholder = new PendingUpdateAdapter();
        }
        this.startFetchingDeferredChildren(parent, element, placeholder);
        if (placeholder == null) {
            return currentChildren;
        }
        return new Object[]{placeholder};
    }

    protected void replaceChildren(final Object parent, final Object[] children, final int offset, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        WorkbenchJob updateJob = new WorkbenchJob(DebugUIViewsMessages.IncrementalDeferredTreeContentManager_0){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.replace(parent, children, offset);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void prune(final Object parent, final int offset) {
        WorkbenchJob updateJob = new WorkbenchJob(DebugUIViewsMessages.IncrementalDeferredTreeContentManager_1){

            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                if (RemoteTreeContentManager.this.fViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                RemoteTreeContentManager.this.fViewer.prune(parent, offset);
                return Status.OK_STATUS;
            }
        };
        updateJob.setSystem(true);
        updateJob.setPriority(10);
        updateJob.schedule();
    }

    protected void runClearPlaceholderJob(PendingUpdateAdapter placeholder) {
        if (placeholder != null) {
            super.runClearPlaceholderJob(placeholder);
        }
    }

    protected String getFetchJobName(Object parent, IDeferredWorkbenchAdapter adapter) {
        return DebugUIViewsMessages.RemoteTreeContentManager_0;
    }

    protected IDeferredWorkbenchAdapter getAdapter(Object element) {
        IWorkbenchAdapter nonDeferred;
        IDeferredWorkbenchAdapter deferred;
        if (element instanceof IDeferredWorkbenchAdapter) {
            return (IDeferredWorkbenchAdapter)element;
        }
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        IAdaptable adaptable = (IAdaptable)element;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.progress.IDeferredWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((deferred = (IDeferredWorkbenchAdapter)adaptable.getAdapter((Class)clazz)) == null) {
            return null;
        }
        DebugUIPlugin plugin = DebugUIPlugin.getDefault();
        Bundle bundle = plugin.getBundle(deferred.getClass());
        Bundle debugBundle = plugin.getBundle();
        if (!debugBundle.equals(bundle)) {
            return deferred;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((nonDeferred = (IWorkbenchAdapter)adaptable.getAdapter((Class)clazz2)) != null && !debugBundle.equals(bundle = plugin.getBundle(nonDeferred.getClass()))) {
            return null;
        }
        return deferred;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startFetchingDeferredChildren(Object parent, IDeferredWorkbenchAdapter adapter, PendingUpdateAdapter placeholder) {
        IElementCollector collector = this.createElementCollector(parent, placeholder);
        List list = this.fElementQueue;
        synchronized (list) {
            if (!this.fElementQueue.contains(parent)) {
                this.fElementQueue.add(parent);
                this.fCollectors.add(collector);
                this.fAdapaters.add(adapter);
            }
        }
        if (this.progressService == null) {
            this.fFetchJob.schedule();
        } else {
            this.progressService.schedule(this.fFetchJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        List list = this.fElementQueue;
        synchronized (list) {
            this.fFetchJob.cancel();
            this.fElementQueue.clear();
            this.fAdapaters.clear();
            this.fCollectors.clear();
        }
    }

    class FetchJob
    extends Job {
        public FetchJob() {
            super(DebugUIViewsMessages.RemoteTreeContentManager_0);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!RemoteTreeContentManager.this.fElementQueue.isEmpty() && !monitor.isCanceled()) {
                Object element = null;
                IElementCollector collector = null;
                IDeferredWorkbenchAdapter adapter = null;
                List list = RemoteTreeContentManager.this.fElementQueue;
                synchronized (list) {
                    if (RemoteTreeContentManager.this.fElementQueue.isEmpty()) {
                        return Status.CANCEL_STATUS;
                    }
                    element = RemoteTreeContentManager.this.fElementQueue.remove(0);
                    collector = (IElementCollector)RemoteTreeContentManager.this.fCollectors.remove(0);
                    adapter = (IDeferredWorkbenchAdapter)RemoteTreeContentManager.this.fAdapaters.remove(0);
                }
                adapter.fetchDeferredChildren(element, collector, monitor);
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }

    public class Collector
    implements IElementCollector {
        int offset = 0;
        Object fParent;

        public Collector(Object parent) {
            this.fParent = parent;
        }

        public void add(Object element, IProgressMonitor monitor) {
            this.add(new Object[]{element}, monitor);
        }

        public void add(Object[] elements, IProgressMonitor monitor) {
            Object[] filtered = RemoteTreeContentManager.this.fViewer.filter(elements);
            if (filtered.length > 0) {
                RemoteTreeContentManager.this.replaceChildren(this.fParent, filtered, this.offset, monitor);
                this.offset += filtered.length;
            }
        }

        public void done() {
            RemoteTreeContentManager.this.prune(this.fParent, this.offset);
        }
    }
}

