/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextEditChangeGroup;
import org.eclipse.ltk.internal.core.refactoring.Assert;
import org.eclipse.ltk.internal.core.refactoring.Changes;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditCopier;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.text.edits.TextEditProcessor;
import org.eclipse.text.edits.UndoEdit;

public abstract class TextChange
extends Change {
    private String fName;
    private List fTextEditChangeGroups;
    private TextEditCopier fCopier;
    private TextEdit fEdit;
    private boolean fTrackEdits;
    private String fTextType;
    private static final TextEditChangeGroup[] ALL_EDITS = new TextEditChangeGroup[0];

    protected TextChange(String name) {
        Assert.isNotNull(name);
        this.fName = name;
        this.fTextEditChangeGroups = new ArrayList(5);
        this.fTextType = "txt";
    }

    public String getName() {
        return this.fName;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        Iterator iter = this.fTextEditChangeGroups.iterator();
        while (iter.hasNext()) {
            TextEditChangeGroup element = (TextEditChangeGroup)iter.next();
            element.setEnabled(enabled);
        }
    }

    public void setTextType(String type) {
        if (type == null) {
            type = "txt";
        }
        this.fTextType = type;
    }

    public String getTextType() {
        return this.fTextType;
    }

    public void setEdit(TextEdit edit) {
        Assert.isTrue(this.fEdit == null, "Root edit can only be set once");
        Assert.isTrue(edit != null);
        this.fEdit = edit;
    }

    public TextEdit getEdit() {
        return this.fEdit;
    }

    public void addTextEditGroup(TextEditGroup group) {
        this.addTextEditChangeGroup(new TextEditChangeGroup(this, group));
    }

    public void addTextEditChangeGroup(TextEditChangeGroup group) {
        Assert.isTrue(this.fEdit != null, "Can only add a description if a root edit exists");
        Assert.isTrue(group != null);
        this.fTextEditChangeGroups.add(group);
    }

    public TextEditChangeGroup[] getTextEditChangeGroups() {
        return this.fTextEditChangeGroups.toArray(new TextEditChangeGroup[this.fTextEditChangeGroups.size()]);
    }

    public void addEdit(TextEdit edit) throws MalformedTreeException {
        Assert.isTrue(this.fEdit != null, "root must exist to add an edit");
        this.fEdit.addChild(edit);
    }

    protected abstract IDocument acquireDocument(IProgressMonitor var1) throws CoreException;

    protected abstract void commit(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract void releaseDocument(IDocument var1, IProgressMonitor var2) throws CoreException;

    protected abstract Change createUndoChange(UndoEdit var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        IDocument document = null;
        DocumentRewriteSession session = null;
        try {
            try {
                document = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
                if (document instanceof IDocumentExtension4) {
                    session = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.UNRESTRICTED);
                }
                TextEditProcessor processor = this.createTextEditProcessor(document, 1, false);
                UndoEdit undo = processor.performEdits();
                this.commit(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                Change change = this.createUndoChange(undo);
                Object var6_8 = null;
                if (document != null) {
                    try {
                        if (session != null) {
                            ((IDocumentExtension4)document).stopRewriteSession(session);
                        }
                        Object var9_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                        throw throwable;
                    }
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                pm.done();
                return change;
            }
            catch (BadLocationException e) {
                throw Changes.asCoreException(e);
            }
        }
        catch (Throwable throwable) {
            block13: {
                Object var6_9 = null;
                if (document == null) break block13;
                try {}
                catch (Throwable throwable2) {
                    Object var9_14 = null;
                    this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    throw throwable2;
                }
                if (session != null) {
                    ((IDocumentExtension4)document).stopRewriteSession(session);
                }
                Object var9_15 = null;
                this.releaseDocument(document, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            pm.done();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IDocument getCurrentDocument(IProgressMonitor pm) throws CoreException {
        IDocument result;
        block5: {
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            result = null;
            pm.beginTask("", 2);
            try {
                result = this.acquireDocument((IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (result != null) {
                    this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                throw throwable;
            }
            {
                Object var3_5 = null;
                if (result == null) break block5;
            }
            this.releaseDocument(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        }
        pm.done();
        return result;
    }

    public String getCurrentContent(IProgressMonitor pm) throws CoreException {
        return this.getCurrentDocument(pm).get();
    }

    public String getCurrentContent(IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        Assert.isNotNull(region);
        Assert.isTrue(surroundingLines >= 0);
        IDocument document = this.getCurrentDocument(pm);
        Assert.isTrue(document.getLength() >= region.getOffset() + region.getLength());
        return this.getContent(document, region, expandRegionToFullLine, surroundingLines);
    }

    public void setKeepPreviewEdits(boolean keep) {
        this.fTrackEdits = keep;
        if (!this.fTrackEdits) {
            this.fCopier = null;
        }
    }

    public boolean getKeepPreviewEdits() {
        return this.fTrackEdits;
    }

    public TextEdit getPreviewEdit(TextEdit original) {
        Assert.isTrue(this.fTrackEdits && this.fCopier != null && original != null);
        return this.fCopier.getCopy(original);
    }

    public TextEdit[] getPreviewEdits(TextEdit[] originals) {
        Assert.isTrue(this.fTrackEdits && this.fCopier != null && originals != null);
        if (originals.length == 0) {
            return new TextEdit[0];
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>(originals.length);
        int i = 0;
        while (i < originals.length) {
            TextEdit copy = this.fCopier.getCopy(originals[i]);
            if (copy != null) {
                result.add(copy);
            }
            ++i;
        }
        return result.toArray(new TextEdit[result.size()]);
    }

    public IDocument getPreviewDocument(IProgressMonitor pm) throws CoreException {
        PreviewAndRegion result = this.getPreviewDocument(ALL_EDITS, pm);
        return result.document;
    }

    public String getPreviewContent(IProgressMonitor pm) throws CoreException {
        return this.getPreviewDocument(pm).get();
    }

    public String getPreviewContent(TextEditChangeGroup[] changeGroups, IRegion region, boolean expandRegionToFullLine, int surroundingLines, IProgressMonitor pm) throws CoreException {
        IRegion currentRegion = this.getRegion(changeGroups);
        Assert.isTrue(region.getOffset() <= currentRegion.getOffset() && currentRegion.getOffset() + currentRegion.getLength() <= region.getOffset() + region.getLength());
        TextEdit root = this.getEdit();
        Assert.isNotNull(root, "No root edit");
        int c = 0;
        while (c < changeGroups.length) {
            TextEditChangeGroup group = changeGroups[c];
            TextEdit[] edits = group.getTextEdits();
            int e = 0;
            while (e < edits.length) {
                Assert.isTrue(root == edits[e].getRoot(), "Wrong root edit");
                ++e;
            }
            ++c;
        }
        PreviewAndRegion result = this.getPreviewDocument(changeGroups, pm);
        int delta = result.region == null ? -currentRegion.getLength() : result.region.getLength() - currentRegion.getLength();
        return this.getContent(result.document, (IRegion)new Region(region.getOffset(), region.getLength() + delta), expandRegionToFullLine, surroundingLines);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PreviewAndRegion getPreviewDocument(TextEditChangeGroup[] changes, IProgressMonitor pm) throws CoreException {
        Document document = new Document(this.getCurrentDocument(pm).get());
        boolean trackChanges = this.fTrackEdits;
        this.setKeepPreviewEdits(true);
        TextEditProcessor processor = changes == ALL_EDITS ? this.createTextEditProcessor((IDocument)document, 0, true) : this.createTextEditProcessor((IDocument)document, 0, changes);
        try {
            try {
                processor.performEdits();
                PreviewAndRegion previewAndRegion = new PreviewAndRegion((IDocument)document, this.getNewRegion(changes));
                Object var7_7 = null;
                this.setKeepPreviewEdits(trackChanges);
                return previewAndRegion;
            }
            catch (BadLocationException e) {
                throw Changes.asCoreException(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.setKeepPreviewEdits(trackChanges);
            throw throwable;
        }
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, boolean preview) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> excludes = new ArrayList<TextEdit>(0);
        Iterator iter = this.fTextEditChangeGroups.iterator();
        while (iter.hasNext()) {
            TextEditChangeGroup edit = (TextEditChangeGroup)iter.next();
            if (edit.isEnabled()) continue;
            excludes.addAll(Arrays.asList(edit.getTextEditGroup().getTextEdits()));
        }
        if (preview) {
            this.fCopier = new TextEditCopier(this.fEdit);
            TextEdit copiedEdit = this.fCopier.perform();
            if (this.fTrackEdits) {
                flags |= 2;
            }
            LocalTextEditProcessor result = new LocalTextEditProcessor(document, copiedEdit, flags);
            result.setExcludes(this.mapEdits(excludes.toArray(new TextEdit[excludes.size()]), this.fCopier));
            if (!this.fTrackEdits) {
                this.fCopier = null;
            }
            return result;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, this.fEdit, flags | 2);
        result.setExcludes(excludes.toArray(new TextEdit[excludes.size()]));
        return result;
    }

    private TextEditProcessor createTextEditProcessor(IDocument document, int flags, TextEditChangeGroup[] changes) {
        if (this.fEdit == null) {
            return new TextEditProcessor(document, (TextEdit)new MultiTextEdit(0, 0), flags);
        }
        ArrayList<TextEdit> includes = new ArrayList<TextEdit>(0);
        int c = 0;
        while (c < changes.length) {
            TextEditChangeGroup change = changes[c];
            Assert.isTrue(change.getTextChange() == this);
            if (change.isEnabled()) {
                includes.addAll(Arrays.asList(change.getTextEditGroup().getTextEdits()));
            }
            ++c;
        }
        this.fCopier = new TextEditCopier(this.fEdit);
        TextEdit copiedEdit = this.fCopier.perform();
        if (this.fTrackEdits) {
            flags |= 2;
        }
        LocalTextEditProcessor result = new LocalTextEditProcessor(document, copiedEdit, flags);
        result.setIncludes(this.mapEdits(includes.toArray(new TextEdit[includes.size()]), this.fCopier));
        if (!this.fTrackEdits) {
            this.fCopier = null;
        }
        return result;
    }

    private TextEdit[] mapEdits(TextEdit[] edits, TextEditCopier copier) {
        if (edits == null) {
            return null;
        }
        int i = 0;
        while (i < edits.length) {
            edits[i] = copier.getCopy(edits[i]);
            ++i;
        }
        return edits;
    }

    private String getContent(IDocument document, IRegion region, boolean expandRegionToFullLine, int surroundingLines) throws CoreException {
        try {
            if (expandRegionToFullLine) {
                int startLine = Math.max(document.getLineOfOffset(region.getOffset()) - surroundingLines, 0);
                int endLine = region.getLength() == 0 ? Math.min(document.getLineOfOffset(region.getOffset()) + surroundingLines, document.getNumberOfLines() - 1) : Math.min(document.getLineOfOffset(region.getOffset() + region.getLength() - 1) + surroundingLines, document.getNumberOfLines() - 1);
                int offset = document.getLineInformation(startLine).getOffset();
                IRegion endLineRegion = document.getLineInformation(endLine);
                int length = endLineRegion.getOffset() + endLineRegion.getLength() - offset;
                return document.get(offset, length);
            }
            return document.get(region.getOffset(), region.getLength());
        }
        catch (BadLocationException e) {
            throw Changes.asCoreException(e);
        }
    }

    private IRegion getRegion(TextEditChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fEdit.getRegion();
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        int i = 0;
        while (i < changes.length) {
            edits.addAll(Arrays.asList(changes[i].getTextEditGroup().getTextEdits()));
            ++i;
        }
        if (edits.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])edits.toArray(new TextEdit[edits.size()]));
    }

    private IRegion getNewRegion(TextEditChangeGroup[] changes) {
        if (changes == ALL_EDITS) {
            if (this.fEdit == null) {
                return null;
            }
            return this.fCopier.getCopy(this.fEdit).getRegion();
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        int c = 0;
        while (c < changes.length) {
            TextEdit[] edits = changes[c].getTextEditGroup().getTextEdits();
            int e = 0;
            while (e < edits.length) {
                TextEdit copy = this.fCopier.getCopy(edits[e]);
                if (copy != null) {
                    result.add(copy);
                }
                ++e;
            }
            ++c;
        }
        if (result.size() == 0) {
            return null;
        }
        return TextEdit.getCoverage((TextEdit[])result.toArray(new TextEdit[result.size()]));
    }

    private static class LocalTextEditProcessor
    extends TextEditProcessor {
        public static final int EXCLUDE = 1;
        public static final int INCLUDE = 2;
        private TextEdit[] fExcludes;
        private TextEdit[] fIncludes;

        public LocalTextEditProcessor(IDocument document, TextEdit root, int flags) {
            super(document, root, flags);
        }

        public void setIncludes(TextEdit[] includes) {
            Assert.isNotNull(includes);
            Assert.isTrue(this.fExcludes == null);
            this.fIncludes = this.flatten(includes);
        }

        public void setExcludes(TextEdit[] excludes) {
            Assert.isNotNull(excludes);
            Assert.isTrue(this.fIncludes == null);
            this.fExcludes = this.flatten(excludes);
        }

        protected boolean considerEdit(TextEdit edit) {
            if (this.fExcludes != null) {
                int i = 0;
                while (i < this.fExcludes.length) {
                    if (edit.equals((Object)this.fExcludes[i])) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }
            if (this.fIncludes != null) {
                int i = 0;
                while (i < this.fIncludes.length) {
                    if (edit.equals((Object)this.fIncludes[i])) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
            return true;
        }

        private TextEdit[] flatten(TextEdit[] edits) {
            ArrayList result = new ArrayList(5);
            int i = 0;
            while (i < edits.length) {
                this.flatten(result, edits[i]);
                ++i;
            }
            return result.toArray(new TextEdit[result.size()]);
        }

        private void flatten(List result, TextEdit edit) {
            result.add(edit);
            TextEdit[] children = edit.getChildren();
            int i = 0;
            while (i < children.length) {
                this.flatten(result, children[i]);
                ++i;
            }
        }
    }

    private static class PreviewAndRegion {
        public IDocument document;
        public IRegion region;

        public PreviewAndRegion(IDocument d, IRegion r) {
            this.document = d;
            this.region = r;
        }
    }
}

