/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.wizards.ConfigurationWizardElement;
import org.eclipse.team.internal.ui.wizards.ConfigureProjectWizardMainPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.IActivityManager;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.model.AdaptableList;

public class ConfigureProjectWizard
extends Wizard
implements IConfigurationWizard {
    protected IWorkbench workbench;
    protected IProject project;
    protected IConfigurationWizard wizard;
    protected ConfigureProjectWizardMainPage mainPage;
    private String pluginId = "org.eclipse.team.ui";
    protected static final String PT_CONFIGURATION = "configurationWizards";
    protected static final String TAG_WIZARD = "wizard";
    protected static final String TAG_DESCRIPTION = "description";
    protected static final String ATT_NAME = "name";
    protected static final String ATT_CLASS = "class";
    protected static final String ATT_ICON = "icon";
    protected static final String ATT_ID = "id";

    public ConfigureProjectWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(this.getWizardWindowTitle());
    }

    protected String getExtensionPoint() {
        return PT_CONFIGURATION;
    }

    protected String getWizardWindowTitle() {
        return TeamUIMessages.ConfigureProjectWizard_title;
    }

    protected String getWizardLabel() {
        return TeamUIMessages.ConfigureProjectWizard_configureProject;
    }

    protected String getWizardDescription() {
        return TeamUIMessages.ConfigureProjectWizard_description;
    }

    public void addPages() {
        AdaptableList disabledWizards = new AdaptableList();
        AdaptableList wizards = this.getAvailableWizards(disabledWizards);
        if (wizards.size() == 1 && disabledWizards.size() == 0) {
            ConfigurationWizardElement element = (ConfigurationWizardElement)((Object)wizards.getChildren()[0]);
            try {
                this.wizard = (IConfigurationWizard)element.createExecutableExtension();
                this.wizard.init(this.workbench, this.project);
                this.wizard.addPages();
                if (this.wizard.getPageCount() > 0) {
                    this.wizard.setContainer(this.getContainer());
                    IWizardPage[] pages = this.wizard.getPages();
                    int i = 0;
                    while (i < pages.length) {
                        this.addPage(pages[i]);
                        ++i;
                    }
                    return;
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
                return;
            }
        }
        this.mainPage = new ConfigureProjectWizardMainPage("configurePage1", this.getWizardLabel(), TeamUIPlugin.getImageDescriptor("wizban/share_wizban.gif"), wizards, disabledWizards);
        this.mainPage.setDescription(this.getWizardDescription());
        this.mainPage.setProject(this.project);
        this.mainPage.setWorkbench(this.workbench);
        this.addPage((IWizardPage)this.mainPage);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (this.wizard != null) {
            return this.wizard.getNextPage(page);
        }
        return super.getNextPage(page);
    }

    public boolean canFinish() {
        if (this.getContainer().getCurrentPage() == this.mainPage) {
            return this.mainPage.getSelectedWizard() != null && this.mainPage.getNextPage() == null;
        }
        if (this.wizard != null) {
            return this.wizard.canFinish();
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        IConfigurationWizard noPageWizard;
        if (this.wizard != null) {
            return this.wizard.performFinish();
        }
        if (this.getContainer().getCurrentPage() == this.mainPage && (noPageWizard = this.mainPage.getSelectedWizard()) != null && noPageWizard.canFinish()) {
            return noPageWizard.performFinish();
        }
        return true;
    }

    public boolean performCancel() {
        if (this.wizard != null) {
            return this.wizard.performCancel();
        }
        return super.performCancel();
    }

    protected AdaptableList getAvailableWizards(AdaptableList disabledWizards) {
        AdaptableList result = new AdaptableList();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(this.pluginId, this.getExtensionPoint());
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] elements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(TAG_WIZARD)) {
                        ConfigurationWizardElement wizard = this.createWizardElement(element);
                        if (wizard != null && this.filterItem(element)) {
                            disabledWizards.add((IAdaptable)wizard);
                        } else if (wizard != null) {
                            result.add((IAdaptable)wizard);
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private boolean filterItem(IConfigurationElement element) {
        String extensionId = element.getAttribute(ATT_ID);
        String extensionPluginId = element.getNamespace();
        IActivityManager activityMgr = PlatformUI.getWorkbench().getActivitySupport().getActivityManager();
        IIdentifier id = activityMgr.getIdentifier(String.valueOf(extensionPluginId) + "/" + extensionId);
        return !id.isEnabled();
    }

    protected ConfigurationWizardElement createWizardElement(IConfigurationElement element) {
        String nameString = element.getAttribute(ATT_NAME);
        if (nameString == null) {
            return null;
        }
        ConfigurationWizardElement result = new ConfigurationWizardElement(nameString);
        if (this.initializeWizard(result, element)) {
            return result;
        }
        return null;
    }

    protected boolean initializeWizard(ConfigurationWizardElement element, IConfigurationElement config) {
        element.setID(config.getAttribute(ATT_ID));
        String description = "";
        IConfigurationElement[] children = config.getChildren(TAG_DESCRIPTION);
        if (children.length >= 1) {
            description = children[0].getValue();
        }
        element.setDescription(description);
        element.setConfigurationElement(config);
        String iconName = config.getAttribute(ATT_ICON);
        if (iconName != null) {
            IExtension extension = config.getDeclaringExtension();
            element.setImageDescriptor(TeamUIPlugin.getImageDescriptorFromExtension(extension, iconName));
        }
        if (element.getConfigurationElement() == null) {
            return false;
        }
        this.setForcePreviousAndNextButtons(true);
        return true;
    }

    public void init(IWorkbench workbench, IProject project) {
        this.workbench = workbench;
        this.project = project;
    }
}

