/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize.actions;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.part.ResourceTransfer;

class CopyToClipboardAction
extends SelectionListenerAction {
    private static final String EOL = System.getProperty("line.separator", "\n");
    private static final String ID = "org.eclipse.team.ui.synchronize.action.copy";
    private final Shell fShell;
    private final Clipboard fClipboard;

    protected CopyToClipboardAction(Shell shell) {
        super(TeamUIMessages.CopyToClipboardAction_1);
        Assert.isNotNull((Object)shell);
        this.fShell = shell;
        this.fClipboard = new Clipboard(shell.getDisplay());
        this.setToolTipText(TeamUIMessages.CopyToClipboardAction_2);
        this.setId(ID);
    }

    public void run() {
        this.copyResources(this.getSelectedResources(), this.getTextualClipboardContents());
    }

    private String getTextualClipboardContents() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        Iterator it = this.getStructuredSelection().iterator();
        while (it.hasNext()) {
            Object element = it.next();
            if (!(element instanceof ITypedElement)) continue;
            if (i > 0) {
                buf.append(EOL);
            }
            buf.append(((ITypedElement)element).getName());
            ++i;
        }
        return buf.toString();
    }

    private void copyResources(List selectedResources, String text) {
        IResource[] resources = selectedResources.toArray(new IResource[selectedResources.size()]);
        int length = resources.length;
        int actualLength = 0;
        String[] fileNames = new String[length];
        int i = 0;
        while (i < length) {
            IPath location = resources[i].getLocation();
            if (location != null) {
                fileNames[actualLength++] = location.toOSString();
            }
            ++i;
        }
        if (actualLength < length) {
            String[] tempFileNames = fileNames;
            fileNames = new String[actualLength];
            int i2 = 0;
            while (i2 < actualLength) {
                fileNames[i2] = tempFileNames[i2];
                ++i2;
            }
        }
        this.setClipboard(resources, fileNames, text);
    }

    private void setClipboard(IResource[] resources, String[] fileNames, String names) {
        block8: {
            try {
                if (resources.length > 0 && fileNames.length > 0) {
                    this.fClipboard.setContents(new Object[]{resources, fileNames, names}, new Transfer[]{ResourceTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()});
                } else if (resources.length > 0) {
                    this.fClipboard.setContents(new Object[]{resources, names}, new Transfer[]{ResourceTransfer.getInstance(), TextTransfer.getInstance()});
                } else if (resources.length == 0) {
                    this.fClipboard.setContents(new Object[]{names}, new Transfer[]{TextTransfer.getInstance()});
                }
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fShell, (String)TeamUIMessages.CopyToClipboardAction_3, (String)TeamUIMessages.CopyToClipboardAction_4)) break block8;
                this.setClipboard(resources, fileNames, names);
            }
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        if (!super.updateSelection(selection)) {
            return false;
        }
        List selectedResources = this.getSelectedResources();
        List selectedNonResources = this.getSelectedNonResources();
        if (selectedResources.size() > 0 && selectedNonResources.size() == 0) {
            boolean projSelected = this.selectionIsOfType(4);
            boolean fileFoldersSelected = this.selectionIsOfType(3);
            if (!projSelected && !fileFoldersSelected) {
                return false;
            }
            if (projSelected && fileFoldersSelected) {
                return false;
            }
            IContainer firstParent = ((IResource)selectedResources.get(0)).getParent();
            if (firstParent == null) {
                return false;
            }
            Iterator resourcesEnum = selectedResources.iterator();
            while (resourcesEnum.hasNext()) {
                IResource currentResource = (IResource)resourcesEnum.next();
                if (!currentResource.getParent().equals((Object)firstParent)) {
                    return false;
                }
                if (currentResource.getLocation() != null) continue;
                return false;
            }
            return true;
        }
        return selectedNonResources.size() > 0 && selectedResources.size() == 0;
    }

    protected List getSelectedNonResources() {
        return Arrays.asList(Utils.getNonResources(this.getStructuredSelection().toArray()));
    }

    protected List getSelectedResources() {
        return Arrays.asList(Utils.getResources(this.getStructuredSelection().toArray()));
    }

    public void dispose() {
        this.fClipboard.dispose();
    }
}

