/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.model;

import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaInterfaceType;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugModelMessages;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIReferenceType;
import org.eclipse.jdt.internal.debug.core.model.JDIType;

public class JDIInterfaceType
extends JDIReferenceType
implements IJavaInterfaceType {
    public JDIInterfaceType(JDIDebugTarget target, InterfaceType type) {
        super(target, type);
    }

    public IJavaClassType[] getImplementors() throws DebugException {
        try {
            List<ClassType> implementorList = ((InterfaceType)this.getUnderlyingType()).implementors();
            ArrayList<JDIType> javaClassTypeList = new ArrayList<JDIType>(implementorList.size());
            Iterator<ClassType> iterator = implementorList.iterator();
            while (iterator.hasNext()) {
                ClassType classType = iterator.next();
                if (classType == null) continue;
                javaClassTypeList.add(JDIType.createType(this.getDebugTarget(), classType));
            }
            IJavaClassType[] javaClassTypeArray = new IJavaClassType[javaClassTypeList.size()];
            javaClassTypeArray = javaClassTypeList.toArray(javaClassTypeArray);
            return javaClassTypeArray;
        }
        catch (RuntimeException re) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaClassType[0];
        }
    }

    public IJavaInterfaceType[] getSubInterfaces() throws DebugException {
        try {
            List<InterfaceType> subList = ((InterfaceType)this.getUnderlyingType()).subinterfaces();
            ArrayList<JDIType> javaInterfaceTypeList = new ArrayList<JDIType>(subList.size());
            Iterator<InterfaceType> iterator = subList.iterator();
            while (iterator.hasNext()) {
                InterfaceType interfaceType = iterator.next();
                if (interfaceType == null) continue;
                javaInterfaceTypeList.add(JDIType.createType(this.getDebugTarget(), interfaceType));
            }
            IJavaInterfaceType[] javaInterfaceTypeArray = new IJavaInterfaceType[javaInterfaceTypeList.size()];
            javaInterfaceTypeArray = javaInterfaceTypeList.toArray(javaInterfaceTypeArray);
            return javaInterfaceTypeArray;
        }
        catch (RuntimeException re) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaInterfaceType[0];
        }
    }

    public IJavaInterfaceType[] getSuperInterfaces() throws DebugException {
        try {
            List<InterfaceType> superList = ((InterfaceType)this.getUnderlyingType()).superinterfaces();
            ArrayList<JDIType> javaInterfaceTypeList = new ArrayList<JDIType>(superList.size());
            Iterator<InterfaceType> iterator = superList.iterator();
            while (iterator.hasNext()) {
                InterfaceType interfaceType = iterator.next();
                if (interfaceType == null) continue;
                javaInterfaceTypeList.add(JDIType.createType(this.getDebugTarget(), interfaceType));
            }
            IJavaInterfaceType[] javaInterfaceTypeArray = new IJavaInterfaceType[javaInterfaceTypeList.size()];
            javaInterfaceTypeArray = javaInterfaceTypeList.toArray(javaInterfaceTypeArray);
            return javaInterfaceTypeArray;
        }
        catch (RuntimeException re) {
            this.getDebugTarget().targetRequestFailed(MessageFormat.format(JDIDebugModelMessages.JDIClassType_exception_while_retrieving_superclass, re.toString()), re);
            return new IJavaInterfaceType[0];
        }
    }
}

