/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.ServletResources;
import org.eclipse.help.internal.webapp.data.TocData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.data.View;

public class LayoutData
extends RequestData {
    private String query = "";
    private View[] views;

    public LayoutData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String qs = request.getQueryString();
        if (qs != null && qs.length() > 0) {
            this.query = "?" + qs;
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getBannerURL() {
        String banner = this.preferences.getBanner();
        if (banner == null || banner.trim().length() == 0) {
            banner = "about:blank";
        } else if (!banner.startsWith("http:/") && !banner.startsWith("https:/")) {
            banner = banner.startsWith("file:/") || banner.startsWith("jar:file:/") ? "topic/" + banner : "topic" + banner;
        }
        return banner;
    }

    public String getBannerHeight() {
        String height = this.preferences.getBannerHeight();
        if (height == null || height.length() == 0) {
            height = "0";
        }
        return height;
    }

    public String getContentURL() {
        TocData tocData = new TocData(this.context, this.request, this.response);
        String topic = tocData.getSelectedTopic();
        String help_home = this.preferences.getHelpHome();
        help_home = topic != null ? topic : UrlUtil.getHelpURL(help_home);
        return help_home;
    }

    public View[] getViews() {
        if (this.views != null) {
            return this.views;
        }
        View tocview = new View("toc", "", String.valueOf(this.preferences.getImagesDirectory()) + "/contents_view.gif", 'C');
        View searchview = new View("search", "", String.valueOf(this.preferences.getImagesDirectory()) + "/search_results_view.gif", 'R');
        View linksview = null;
        View bookmarksview = null;
        if (this.preferences.isLinksView()) {
            linksview = new View("links", "", String.valueOf(this.preferences.getImagesDirectory()) + "/links_view.gif", '\u0000');
        }
        if (this.preferences.isBookmarksView()) {
            bookmarksview = new View("bookmarks", "", String.valueOf(this.preferences.getImagesDirectory()) + "/bookmarks_view.gif", '\u0000');
        }
        this.views = linksview != null && bookmarksview != null ? new View[]{tocview, searchview, linksview, bookmarksview} : (linksview != null ? new View[]{tocview, searchview, linksview} : (bookmarksview != null ? new View[]{tocview, searchview, bookmarksview} : new View[]{tocview, searchview}));
        return this.views;
    }

    public String getVisibleView() {
        String requestedView = this.request.getParameter("tab");
        View[] allViews = this.getViews();
        int i = 0;
        while (i < allViews.length) {
            if (allViews[i].getName().equals(requestedView)) {
                return requestedView;
            }
            ++i;
        }
        return "toc";
    }

    public View getCurrentView() {
        String name = this.request.getParameter("view");
        this.views = this.getViews();
        int i = 0;
        while (i < this.views.length) {
            if (this.views[i].getName().equals(name)) {
                return this.views[i];
            }
            ++i;
        }
        return null;
    }

    public String getWindowTitle() {
        if (this.preferences.isWindowTitlePrefix()) {
            return ServletResources.getString("browserTitle", BaseHelpSystem.getProductName(), this.request);
        }
        return BaseHelpSystem.getProductName();
    }
}

