/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.jdt.internal.corext.buildpath.ClasspathModifierOperation;
import org.eclipse.jdt.internal.corext.buildpath.EditOutputFolderOperation;
import org.eclipse.jdt.internal.corext.buildpath.IClasspathInformationProvider;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.BuildActionSelectionContext;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ClasspathModifierQueries;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.IUpdate;

public class BuildPathAction
extends Action
implements IClasspathInformationProvider,
IUpdate {
    private ClasspathModifierOperation fOperation;
    private IJavaProject fJavaProject;
    private final BuildActionSelectionContext fContext;
    private final IWorkbenchSite fSite;
    private IStructuredSelection fCurrentSelection;
    static /* synthetic */ Class class$0;

    public BuildPathAction(IWorkbenchSite site, BuildActionSelectionContext context) {
        this.fSite = site;
        this.fContext = context;
        this.fCurrentSelection = StructuredSelection.EMPTY;
    }

    private Shell getShell() {
        return this.fSite.getShell();
    }

    public void initialize(ClasspathModifierOperation operation, ImageDescriptor imageDescriptor, ImageDescriptor disabledImageDescriptor, String text, String tooltip) {
        this.fOperation = operation;
        this.setImageDescriptor(imageDescriptor);
        this.setDisabledImageDescriptor(disabledImageDescriptor);
        this.setText(text);
        this.setToolTipText(tooltip);
    }

    public void run() {
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    BuildPathAction.this.fOperation.run(monitor);
                }
            };
            PlatformUI.getWorkbench().getProgressService().run(true, false, runnable);
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title, this.fOperation.getName()), e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    public void update() {
        ISelection selection = this.fSite.getSelectionProvider().getSelection();
        Object structSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
        this.fCurrentSelection = structSelection;
        try {
            this.fContext.init((IStructuredSelection)structSelection);
            this.fJavaProject = this.fContext.getJavaProject();
            this.setEnabled(this.fJavaProject != null && this.fOperation.isValid(this.fContext.getElements(), this.fContext.getTypes()));
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            this.setEnabled(false);
        }
    }

    public IStructuredSelection getSelection() {
        return this.fCurrentSelection;
    }

    public IJavaProject getJavaProject() {
        return this.fJavaProject;
    }

    public ClasspathModifierQueries.OutputFolderQuery getOutputFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultFolderQuery(this.getShell(), this.fJavaProject.getOutputLocation().makeRelative());
    }

    public ClasspathModifierQueries.IInclusionExclusionQuery getInclusionExclusionQuery() {
        return ClasspathModifierQueries.getDefaultInclusionExclusionQuery(this.getShell());
    }

    public ClasspathModifierQueries.IOutputLocationQuery getOutputLocationQuery() throws JavaModelException {
        List classpathEntries = ClasspathModifier.getExistingEntries(this.fJavaProject);
        return ClasspathModifierQueries.getDefaultOutputLocationQuery(this.getShell(), this.fJavaProject.getOutputLocation().makeRelative(), classpathEntries);
    }

    public ClasspathModifierQueries.IFolderCreationQuery getFolderCreationQuery() {
        IStructuredSelection selection = this.getSelection();
        return ClasspathModifierQueries.getDefaultFolderCreationQuery(this.getShell(), selection.getFirstElement());
    }

    public ClasspathModifierQueries.ILinkToQuery getLinkFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultLinkQuery(this.getShell(), this.fJavaProject, this.fJavaProject.getOutputLocation().makeRelative());
    }

    public ClasspathModifierQueries.IRemoveLinkedFolderQuery getRemoveLinkedFolderQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultRemoveLinkedFolderQuery(this.getShell());
    }

    public ClasspathModifierQueries.IAddArchivesQuery getExternalArchivesQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultArchivesQuery(this.getShell());
    }

    public ClasspathModifierQueries.IAddLibrariesQuery getLibrariesQuery() throws JavaModelException {
        return ClasspathModifierQueries.getDefaultLibrariesQuery(this.getShell());
    }

    public void deleteCreatedResources() {
    }

    public void handleResult(List resultElements, CoreException exception, int operationType) {
        if (exception != null) {
            ExceptionHandler.handle(exception, this.getShell(), Messages.format(NewWizardMessages.HintTextGroup_Exception_Title, this.fOperation.getName()), exception.getMessage());
            return;
        }
        if (resultElements.size() == 0) {
            return;
        }
        StructuredSelection selection = this.fOperation instanceof EditOutputFolderOperation ? (StructuredSelection)this.getSelection() : new StructuredSelection(resultElements);
        this.selectAndReveal((ISelection)selection);
    }

    private void selectAndReveal(final ISelection selection) {
        IWorkbenchPart part;
        IWorkbenchPage page = this.fSite.getPage();
        if (page == null) {
            return;
        }
        ArrayList<IWorkbenchPart> parts = new ArrayList<IWorkbenchPart>();
        IViewReference[] refs = page.getViewReferences();
        int i = 0;
        while (i < refs.length) {
            part = refs[i].getPart(false);
            if (part != null) {
                parts.add(part);
            }
            ++i;
        }
        refs = page.getEditorReferences();
        i = 0;
        while (i < refs.length) {
            if (refs[i].getPart(false) != null) {
                parts.add(refs[i].getPart(false));
            }
            ++i;
        }
        Iterator itr = parts.iterator();
        while (itr.hasNext()) {
            part = (IWorkbenchPart)itr.next();
            ISetSelectionTarget target = null;
            if (part instanceof ISetSelectionTarget) {
                target = (ISetSelectionTarget)part;
            } else {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ui.part.ISetSelectionTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                target = (ISetSelectionTarget)part.getAdapter((Class)clazz);
            }
            if (target == null) continue;
            final ISetSelectionTarget finalTarget = target;
            page.getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    finalTarget.selectReveal(selection);
                }
            });
        }
    }
}

