/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.io.IOException;
import java.io.Reader;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;
import org.eclipse.jdt.ui.JavadocContentAccess;

public class ProposalInfo {
    private IJavaProject fJavaProject;
    private String fFullTypeName;
    private IMember fMember;

    public ProposalInfo(IJavaProject jproject, String fullyQualifiedTypeName) {
        this.fJavaProject = jproject;
        this.fFullTypeName = fullyQualifiedTypeName;
    }

    public ProposalInfo(IMember member) {
        this.fMember = member;
    }

    private IMember getMember() throws JavaModelException {
        IType type;
        if (this.fMember == null && (type = this.fJavaProject.findType(this.fFullTypeName)) != null) {
            this.fMember = type;
        }
        return this.fMember;
    }

    public String getInfo() {
        try {
            Reader reader;
            IMember member = this.getMember();
            if (member != null && (reader = JavadocContentAccess.getContentReader(member, true)) != null) {
                return new JavaDoc2HTMLTextReader(reader).getString();
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        catch (IOException e) {
            JavaPlugin.log(e);
        }
        return null;
    }
}

