/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public final class ExperimentalProposal
extends JavaMethodCompletionProposal {
    private char[][] fParameterNames;
    private String fName;
    private IRegion fSelectedRegion;

    public ExperimentalProposal(CompletionProposal proposal, ICompilationUnit cu) {
        super(proposal, cu);
    }

    public void apply(IDocument document, char trigger, int offset) {
        String replacementString;
        int[] positionLengths;
        int[] positionOffsets;
        int parameterCount;
        int baseOffset = this.getReplacementOffset();
        if (this.appendArguments(document, offset)) {
            this.fParameterNames = this.fProposal.findParameterNames(null);
            this.fName = String.valueOf(this.fProposal.getName());
            parameterCount = this.fParameterNames.length;
            positionOffsets = new int[parameterCount];
            positionLengths = new int[parameterCount];
            replacementString = this.computeReplacementString(baseOffset, positionOffsets, positionLengths, document);
        } else {
            parameterCount = 0;
            positionOffsets = new int[]{};
            positionLengths = new int[]{};
            replacementString = this.getReplacementString();
        }
        this.setReplacementString(replacementString);
        super.apply(document, trigger, offset);
        if (positionOffsets.length > 0 && this.getTextViewer() != null) {
            try {
                LinkedModeModel model = new LinkedModeModel();
                int i = 0;
                while (i != positionOffsets.length) {
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, baseOffset + positionOffsets[i], positionLengths[i], -1));
                    model.addGroup(group);
                    ++i;
                }
                model.forceInstall();
                JavaEditor editor = this.getJavaEditor();
                if (editor != null) {
                    model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
                }
                EditorLinkedModeUI ui = new EditorLinkedModeUI(model, this.getTextViewer());
                ui.setExitPosition(this.getTextViewer(), baseOffset + replacementString.length(), 0, Integer.MAX_VALUE);
                ui.setExitPolicy((LinkedModeUI.IExitPolicy)new JavaMethodCompletionProposal.ExitPolicy(')', document));
                ui.setDoContextInfo(true);
                ui.enter();
                this.fSelectedRegion = ui.getSelectedRegion();
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
                this.openErrorDialog(e);
            }
        } else {
            this.fSelectedRegion = new Region(baseOffset + replacementString.length(), 0);
        }
    }

    private String computeReplacementString(int baseOffset, int[] offsets, int[] lengths, IDocument document) {
        StringBuffer buffer = new StringBuffer(this.fName);
        int count = this.fParameterNames.length;
        buffer.append('(');
        int i = 0;
        while (i != count) {
            if (i != 0) {
                buffer.append(", ");
            }
            offsets[i] = buffer.length();
            buffer.append(this.fParameterNames[i]);
            lengths[i] = buffer.length() - offsets[i];
            ++i;
        }
        buffer.append(')');
        return buffer.toString();
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return new Point(this.getReplacementOffset(), 0);
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    private void openErrorDialog(BadLocationException e) {
        Shell shell = this.getTextViewer().getTextWidget().getShell();
        MessageDialog.openError((Shell)shell, (String)JavaTextMessages.ExperimentalProposal_error_msg, (String)e.getMessage());
    }

    private boolean appendArguments(IDocument document, int offset) {
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        if (preferenceStore.getBoolean("content_assist_insert_completion") ^ this.isToggleEating()) {
            return true;
        }
        try {
            IRegion region = document.getLineInformationOfOffset(offset);
            String line = document.get(region.getOffset(), region.getLength());
            int index = offset - region.getOffset();
            while (index != line.length() && Character.isUnicodeIdentifierPart(line.charAt(index))) {
                ++index;
            }
            if (index == line.length()) {
                return true;
            }
            return line.charAt(index) != '(';
        }
        catch (BadLocationException badLocationException) {
            return true;
        }
    }
}

