/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeTypeRefactoring;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.refactoring.ChangeTypeContentProvider;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TreeItem;

public class ChangeTypeWizard
extends RefactoringWizard {
    private ChangeTypeRefactoring fCT;

    public ChangeTypeWizard(ChangeTypeRefactoring ref) {
        super((Refactoring)ref, 4);
        this.setDefaultPageTitle(RefactoringMessages.ChangeTypeWizard_title);
        this.fCT = ref;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ChangeTypeInputPage());
    }

    static String print(Collection types) {
        if (types.isEmpty()) {
            return "{ }";
        }
        String result = "{ ";
        Iterator it = types.iterator();
        while (it.hasNext()) {
            ITypeBinding type = (ITypeBinding)it.next();
            result = String.valueOf(result) + type.getQualifiedName();
            result = it.hasNext() ? String.valueOf(result) + ", " : String.valueOf(result) + " }";
        }
        return result;
    }

    static /* synthetic */ ChangeTypeRefactoring access$0(ChangeTypeWizard changeTypeWizard) {
        return changeTypeWizard.fCT;
    }

    private class ChangeTypeLabelProvider
    extends BindingLabelProvider
    implements IColorProvider {
        private Color fGrayColor = Display.getCurrent().getSystemColor(18);
        private HashMap fGrayImages = new HashMap();
        private Collection fInvalidTypes;

        public void grayOut(Collection invalidTypes) {
            this.fInvalidTypes = invalidTypes;
            this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }

        public Color getForeground(Object element) {
            if (this.isInvalid(element)) {
                return this.fGrayColor;
            }
            return null;
        }

        private boolean isInvalid(Object element) {
            if (this.fInvalidTypes == null) {
                return false;
            }
            return this.fInvalidTypes.contains(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Image getImage(Object element) {
            Image image = super.getImage(element);
            if (this.isInvalid(element) && image != null) {
                Image grayImage = (Image)this.fGrayImages.get(image);
                if (grayImage == null) {
                    grayImage = new Image((Device)Display.getCurrent(), image, 2);
                    this.fGrayImages.put(image, grayImage);
                }
                return grayImage;
            }
            return image;
        }

        public void dispose() {
            Iterator iter = this.fGrayImages.values().iterator();
            while (iter.hasNext()) {
                Image image = (Image)iter.next();
                image.dispose();
            }
            this.fGrayImages.clear();
            super.dispose();
        }
    }

    private class ChangeTypeInputPage
    extends UserInputWizardPage {
        public static final String PAGE_NAME = "ChangeTypeInputPage";
        private final String MESSAGE = RefactoringMessages.ChangeTypeInputPage_Select_Type;
        private ChangeTypeLabelProvider fLabelProvider;
        private TreeViewer fTreeViewer;
        private boolean fTreeUpdated = false;

        public ChangeTypeInputPage() {
            super(PAGE_NAME);
            this.setMessage(this.MESSAGE);
        }

        private TreeItem getInitialSelection(Collection types) {
            ITypeBinding type = (ITypeBinding)types.iterator().next();
            Iterator it = types.iterator();
            while (it.hasNext()) {
                ITypeBinding other = (ITypeBinding)it.next();
                if (!this.getGeneralizeTypeRefactoring().isSubTypeOf(type, other)) continue;
                type = other;
            }
            return this.findItem(this.fTreeViewer.getTree().getItems(), type);
        }

        private TreeItem findItem(TreeItem[] items, ITypeBinding type) {
            int i = 0;
            while (i < items.length) {
                if (items[i].getData().equals(type)) {
                    return items[i];
                }
                ++i;
            }
            i = 0;
            while (i < items.length) {
                TreeItem item = this.findItem(items[i].getItems(), type);
                if (item != null) {
                    return item;
                }
                ++i;
            }
            return null;
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            this.setControl((Control)composite);
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData());
            Label label = new Label(composite, 0);
            label.setText(Messages.format(RefactoringMessages.ChangeTypeWizard_pleaseChooseType, ((ChangeTypeRefactoring)this.getRefactoring()).getTarget()));
            label.setLayoutData((Object)new GridData());
            this.addTreeComponent(composite);
            Dialog.applyDialogFont((Control)composite);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void addTreeComponent(Composite parent) {
            GridData gd;
            block4: {
                this.fTreeViewer = new TreeViewer(parent, 2820);
                gd = new GridData(1808);
                gd.grabExcessHorizontalSpace = true;
                gd.grabExcessVerticalSpace = true;
                GC gc = null;
                try {
                    gc = new GC((Drawable)parent);
                    gc.setFont(gc.getFont());
                    gd.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)gc.getFontMetrics(), (int)6);
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    if (gc != null) {
                        gc.dispose();
                        gc = null;
                    }
                    throw throwable;
                }
                {
                    Object var4_6 = null;
                    if (gc == null) break block4;
                }
                gc.dispose();
                gc = null;
            }
            this.fTreeViewer.getTree().setLayoutData((Object)gd);
            this.fTreeViewer.setContentProvider((IContentProvider)new ChangeTypeContentProvider((ChangeTypeRefactoring)this.getRefactoring()));
            this.fLabelProvider = new ChangeTypeLabelProvider();
            this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fLabelProvider);
            ISelectionChangedListener listener = new ISelectionChangedListener(this){
                final /* synthetic */ ChangeTypeInputPage this$1;
                {
                    this.this$1 = changeTypeInputPage;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                    ChangeTypeInputPage.access$3(this.this$1, (ITypeBinding)selection.getFirstElement());
                }
            };
            this.fTreeViewer.addSelectionChangedListener(listener);
            this.fTreeViewer.setInput((Object)new ChangeTypeContentProvider.RootType(this.getGeneralizeTypeRefactoring().getOriginalType()));
            this.fTreeViewer.expandToLevel(10);
        }

        private void typeSelected(ITypeBinding type) {
            boolean isValid = this.getGeneralizeTypeRefactoring().getValidTypes().contains(type);
            this.setPageComplete(isValid);
            if (isValid) {
                this.setMessage("");
            } else if (this.getGeneralizeTypeRefactoring().getOriginalType().equals((Object)type)) {
                this.setMessage(Messages.format(RefactoringMessages.ChangeTypeWizard_with_itself, type.getName()));
            } else {
                this.setMessage(Messages.format(RefactoringMessages.ChangeTypeWizard_grayed_types, new Object[]{type.getName(), this.getGeneralizeTypeRefactoring().getOriginalType().getName()}));
            }
        }

        private ChangeTypeRefactoring getGeneralizeTypeRefactoring() {
            return (ChangeTypeRefactoring)this.getRefactoring();
        }

        public IWizardPage getNextPage() {
            this.initializeRefactoring();
            return super.getNextPage();
        }

        private ITypeBinding getSelectedType() {
            IStructuredSelection ss = (IStructuredSelection)this.fTreeViewer.getSelection();
            return (ITypeBinding)ss.getFirstElement();
        }

        public boolean performFinish() {
            this.initializeRefactoring();
            return super.performFinish();
        }

        private void initializeRefactoring() {
            this.getGeneralizeTypeRefactoring().setSelectedType(this.getSelectedType());
        }

        public void dispose() {
            this.fTreeViewer = null;
            super.dispose();
        }

        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (visible && this.fTreeViewer != null) {
                this.fTreeViewer.getTree().setFocus();
            }
            if (!this.fTreeUpdated) {
                this.fTreeViewer.getTree().getDisplay().asyncExec((Runnable)new ValidTypesTask());
                this.fTreeUpdated = true;
            }
        }

        static /* synthetic */ void access$3(ChangeTypeInputPage changeTypeInputPage, ITypeBinding iTypeBinding) {
            changeTypeInputPage.typeSelected(iTypeBinding);
        }

        static /* synthetic */ ChangeTypeWizard access$4(ChangeTypeInputPage changeTypeInputPage) {
            return changeTypeInputPage.ChangeTypeWizard.this;
        }

        private class ValidTypesTask
        implements Runnable {
            private Collection fInvalidTypes;
            private Collection fValidTypes;

            ValidTypesTask() {
            }

            public void run() {
                IRunnableWithProgress runnable = new IRunnableWithProgress(this){
                    final /* synthetic */ ValidTypesTask this$2;
                    {
                        this.this$2 = validTypesTask;
                    }

                    public void run(IProgressMonitor pm) {
                        pm.beginTask(RefactoringMessages.ChangeTypeWizard_analyzing, 1000);
                        ChangeTypeRefactoring ct = (ChangeTypeRefactoring)ChangeTypeInputPage.access$4(ValidTypesTask.access$4(this.this$2)).getRefactoring();
                        ValidTypesTask.access$0(this.this$2, new HashSet<E>());
                        ValidTypesTask.access$1(this.this$2).addAll(ChangeTypeWizard.access$0(ChangeTypeInputPage.access$4(ValidTypesTask.access$4(this.this$2))).getAllSuperTypes(ct.getOriginalType()));
                        ValidTypesTask.access$2(this.this$2, ct.computeValidTypes((IProgressMonitor)new SubProgressMonitor(pm, 950)));
                        ValidTypesTask.access$1(this.this$2).add(ct.getOriginalType());
                        ValidTypesTask.access$1(this.this$2).removeAll(ValidTypesTask.access$3(this.this$2));
                        pm.worked(50);
                        pm.done();
                    }
                };
                boolean internalError = false;
                try {
                    ChangeTypeInputPage.this.getWizard().getContainer().run(true, true, runnable);
                }
                catch (InvocationTargetException e) {
                    internalError = true;
                    JavaPlugin.log(e);
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.ChangeTypeWizard_internalError);
                }
                catch (InterruptedException interruptedException) {
                    ChangeTypeInputPage.this.setMessage(RefactoringMessages.ChangeTypeWizard_computationInterrupted);
                }
                ChangeTypeInputPage.this.fLabelProvider.grayOut(this.fInvalidTypes);
                if (internalError) {
                    ChangeTypeInputPage.this.setPageComplete(false);
                } else if (this.fValidTypes == null || this.fValidTypes.size() == 0) {
                    ChangeTypeInputPage.this.setErrorMessage(RefactoringMessages.ChangeTypeWizard_declCannotBeChanged);
                    ChangeTypeInputPage.this.setPageComplete(false);
                } else {
                    TreeItem selection = ChangeTypeInputPage.this.getInitialSelection(this.fValidTypes);
                    ChangeTypeInputPage.this.fTreeViewer.getTree().setSelection(new TreeItem[]{selection});
                    ChangeTypeInputPage.this.setPageComplete(true);
                    ChangeTypeInputPage.this.setMessage("");
                }
            }

            static /* synthetic */ void access$0(ValidTypesTask validTypesTask, Collection collection) {
                validTypesTask.fInvalidTypes = collection;
            }

            static /* synthetic */ Collection access$1(ValidTypesTask validTypesTask) {
                return validTypesTask.fInvalidTypes;
            }

            static /* synthetic */ void access$2(ValidTypesTask validTypesTask, Collection collection) {
                validTypesTask.fValidTypes = collection;
            }

            static /* synthetic */ Collection access$3(ValidTypesTask validTypesTask) {
                return validTypesTask.fValidTypes;
            }

            static /* synthetic */ ChangeTypeInputPage access$4(ValidTypesTask validTypesTask) {
                return validTypesTask.ChangeTypeInputPage.this;
            }
        }
    }
}

