/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public final class ToggleCommentAction
extends TextEditorAction {
    private ITextOperationTarget fOperationTarget;
    private String fDocumentPartitioning;
    private Map fPrefixesMap;
    static /* synthetic */ Class class$0;

    public ToggleCommentAction(ResourceBundle bundle, String prefix, ITextEditor editor) {
        super(bundle, prefix, editor);
    }

    public void run() {
        if (this.fOperationTarget == null || this.fDocumentPartitioning == null || this.fPrefixesMap == null) {
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (editor == null) {
            return;
        }
        if (!this.validateEditorInputState()) {
            return;
        }
        final int operationCode = this.isSelectionCommented(editor.getSelectionProvider().getSelection()) ? 12 : 11;
        Shell shell = editor.getSite().getShell();
        if (!this.fOperationTarget.canDoOperation(operationCode)) {
            if (shell != null) {
                MessageDialog.openError((Shell)shell, (String)JavaEditorMessages.ToggleComment_error_title, (String)JavaEditorMessages.ToggleComment_error_message);
            }
            return;
        }
        Display display = null;
        if (shell != null && !shell.isDisposed()) {
            display = shell.getDisplay();
        }
        BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

            public void run() {
                ToggleCommentAction.this.fOperationTarget.doOperation(operationCode);
            }
        });
    }

    private boolean isSelectionCommented(ISelection selection) {
        if (!(selection instanceof ITextSelection)) {
            return false;
        }
        ITextSelection textSelection = (ITextSelection)selection;
        if (textSelection.getStartLine() < 0 || textSelection.getEndLine() < 0) {
            return false;
        }
        IDocument document = this.getTextEditor().getDocumentProvider().getDocument((Object)this.getTextEditor().getEditorInput());
        try {
            IRegion block = this.getTextBlockFromSelection(textSelection, document);
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)document, (String)this.fDocumentPartitioning, (int)block.getOffset(), (int)block.getLength(), (boolean)false);
            int lineCount = 0;
            int[] lines = new int[regions.length * 2];
            int i = 0;
            int j = 0;
            while (i < regions.length) {
                lines[j] = this.getFirstCompleteLineOfRegion((IRegion)regions[i], document);
                int length = regions[i].getLength();
                int offset = regions[i].getOffset() + length;
                if (length > 0) {
                    --offset;
                }
                lines[j + 1] = lines[j] == -1 ? -1 : document.getLineOfOffset(offset);
                lineCount += lines[j + 1] - lines[j] + 1;
                ++i;
                j += 2;
            }
            i = 0;
            j = 0;
            while (i < regions.length) {
                String[] prefixes = (String[])this.fPrefixesMap.get(regions[i].getType());
                if (prefixes != null && prefixes.length > 0 && lines[j] >= 0 && lines[j + 1] >= 0 && !this.isBlockCommented(lines[j], lines[j + 1], prefixes, document)) {
                    return false;
                }
                ++i;
                j += 2;
            }
            return true;
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return false;
        }
    }

    private IRegion getTextBlockFromSelection(ITextSelection selection, IDocument document) {
        try {
            IRegion line = document.getLineInformationOfOffset(selection.getOffset());
            int length = selection.getLength() == 0 ? line.getLength() : selection.getLength() + (selection.getOffset() - line.getOffset());
            return new Region(line.getOffset(), length);
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return null;
        }
    }

    private int getFirstCompleteLineOfRegion(IRegion region, IDocument document) {
        try {
            int startLine = document.getLineOfOffset(region.getOffset());
            int offset = document.getLineOffset(startLine);
            if (offset >= region.getOffset()) {
                return startLine;
            }
            offset = document.getLineOffset(startLine + 1);
            return offset > region.getOffset() + region.getLength() ? -1 : startLine + 1;
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return -1;
        }
    }

    private boolean isBlockCommented(int startLine, int endLine, String[] prefixes, IDocument document) {
        try {
            int i = startLine;
            while (i <= endLine) {
                IRegion line = document.getLineInformation(i);
                String text = document.get(line.getOffset(), line.getLength());
                int[] found = TextUtilities.indexOf((String[])prefixes, (String)text, (int)0);
                if (found[0] == -1) {
                    return false;
                }
                String s = document.get(line.getOffset(), found[0]);
                if ((s = s.trim()).length() != 0) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        catch (BadLocationException x) {
            JavaPlugin.log(x);
            return false;
        }
    }

    public void update() {
        super.update();
        if (!this.canModifyEditor()) {
            this.setEnabled(false);
            return;
        }
        ITextEditor editor = this.getTextEditor();
        if (this.fOperationTarget == null && editor != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.ITextOperationTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.fOperationTarget = (ITextOperationTarget)editor.getAdapter((Class)clazz);
        }
        boolean isEnabled = this.fOperationTarget != null && this.fOperationTarget.canDoOperation(11) && this.fOperationTarget.canDoOperation(12);
        this.setEnabled(isEnabled);
    }

    public void setEditor(ITextEditor editor) {
        super.setEditor(editor);
        this.fOperationTarget = null;
    }

    public void configure(ISourceViewer sourceViewer, SourceViewerConfiguration configuration) {
        this.fPrefixesMap = null;
        String[] types = configuration.getConfiguredContentTypes(sourceViewer);
        HashMap<String, String[]> prefixesMap = new HashMap<String, String[]>(types.length);
        int i = 0;
        while (i < types.length) {
            String type = types[i];
            String[] prefixes = configuration.getDefaultPrefixes(sourceViewer, type);
            if (prefixes != null && prefixes.length > 0) {
                int emptyPrefixes = 0;
                int j = 0;
                while (j < prefixes.length) {
                    if (prefixes[j].length() == 0) {
                        ++emptyPrefixes;
                    }
                    ++j;
                }
                if (emptyPrefixes > 0) {
                    String[] nonemptyPrefixes = new String[prefixes.length - emptyPrefixes];
                    int j2 = 0;
                    int k = 0;
                    while (j2 < prefixes.length) {
                        String prefix = prefixes[j2];
                        if (prefix.length() != 0) {
                            nonemptyPrefixes[k] = prefix;
                            ++k;
                        }
                        ++j2;
                    }
                    prefixes = nonemptyPrefixes;
                }
                prefixesMap.put(type, prefixes);
            }
            ++i;
        }
        this.fDocumentPartitioning = configuration.getConfiguredDocumentPartitioning(sourceViewer);
        this.fPrefixesMap = prefixesMap;
    }
}

