/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.ArrayAccess;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CastExpression;
import org.eclipse.jdt.core.dom.CatchClause;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Comment;
import org.eclipse.jdt.core.dom.ConditionalExpression;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InstanceofExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.SourceRange;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.HierarchicalASTVisitor;
import org.eclipse.jdt.internal.corext.refactoring.structure.constraints.SuperTypeConstraintsModel;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.CompilationUnitRange;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints2.ConstraintVariable2;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;

public final class SuperTypeConstraintsCreator
extends HierarchicalASTVisitor {
    private static final String PROPERTY_CONSTRAINT_VARIABLE = "cv";
    private final Stack fCurrentMethods = new Stack();
    private final boolean fInstanceOf;
    private final SuperTypeConstraintsModel fModel;

    private static void getOriginalMethods(IMethodBinding binding, ITypeBinding type, Collection originals, boolean implementations) {
        ITypeBinding ancestor = type.getSuperclass();
        if (!implementations) {
            ITypeBinding[] types = type.getInterfaces();
            int index = 0;
            while (index < types.length) {
                SuperTypeConstraintsCreator.getOriginalMethods(binding, types[index], originals, implementations);
                ++index;
            }
            if (ancestor != null) {
                SuperTypeConstraintsCreator.getOriginalMethods(binding, ancestor, originals, implementations);
            }
        }
        if (implementations && ancestor != null) {
            SuperTypeConstraintsCreator.getOriginalMethods(binding, ancestor, originals, implementations);
        }
        IMethodBinding[] methods = type.getDeclaredMethods();
        IMethodBinding method = null;
        int index = 0;
        while (index < methods.length) {
            method = methods[index];
            if (!binding.getKey().equals(method.getKey())) {
                boolean match = false;
                IMethodBinding current = null;
                Iterator iterator = originals.iterator();
                while (iterator.hasNext()) {
                    current = (IMethodBinding)iterator.next();
                    if (!Bindings.areOverriddenMethods(method, current)) continue;
                    match = true;
                }
                if (!match && Bindings.areOverriddenMethods(binding, method)) {
                    originals.add(method);
                }
            }
            ++index;
        }
    }

    public SuperTypeConstraintsCreator(SuperTypeConstraintsModel model, boolean instanceofs) {
        Assert.isNotNull(model);
        this.fModel = model;
        this.fInstanceOf = instanceofs;
    }

    public final void endVisit(ArrayAccess node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, node.getArray().getProperty(PROPERTY_CONSTRAINT_VARIABLE));
    }

    public final void endVisit(ArrayCreation node) {
        ConstraintVariable2 descendant;
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        ArrayInitializer initializer = node.getInitializer();
        if (initializer != null && (descendant = (ConstraintVariable2)initializer.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    public final void endVisit(ArrayInitializer node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null && binding.isArray()) {
            ConstraintVariable2 ancestor = this.fModel.createIndependentTypeVariable(binding.getElementType());
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
            Expression expression = null;
            ConstraintVariable2 descendant = null;
            List expressions = node.expressions();
            int index = 0;
            while (index < expressions.size()) {
                expression = (Expression)expressions.get(index);
                descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (descendant != null) {
                    this.fModel.createSubtypeConstraint(descendant, ancestor);
                }
                ++index;
            }
        }
    }

    public final void endVisit(ArrayType node) {
        ArrayType array = null;
        Type component = node.getComponentType();
        while (component instanceof ArrayType) {
            array = (ArrayType)component;
            component = array.getComponentType();
        }
        ConstraintVariable2 variable = this.fModel.createTypeVariable(component);
        if (variable != null) {
            component.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    public final void endVisit(Assignment node) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getLeftHandSide().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        ConstraintVariable2 descendant = (ConstraintVariable2)node.getRightHandSide().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        if (ancestor != null && descendant != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    public final void endVisit(CastExpression node) {
        ConstraintVariable2 first = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (first != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)first);
            ConstraintVariable2 second = (ConstraintVariable2)node.getExpression().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
            if (second != null) {
                this.fModel.createCastVariable(node, second);
            }
        }
    }

    public final void endVisit(CatchClause node) {
        ConstraintVariable2 ancestor;
        ITypeBinding binding;
        ConstraintVariable2 descendant;
        SingleVariableDeclaration declaration = node.getException();
        if (declaration != null && (descendant = (ConstraintVariable2)declaration.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null && (binding = node.getAST().resolveWellKnownType("java.lang.Throwable")) != null && (ancestor = this.fModel.createImmutableTypeVariable(binding)) != null) {
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    public final void endVisit(ClassInstanceCreation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
            ConstraintVariable2 variable = null;
            AnonymousClassDeclaration declaration = node.getAnonymousClassDeclaration();
            if (declaration != null) {
                ITypeBinding type = declaration.resolveBinding();
                if (type != null) {
                    variable = this.fModel.createImmutableTypeVariable(type);
                }
            } else {
                ITypeBinding type = node.resolveTypeBinding();
                if (type != null) {
                    variable = this.fModel.createImmutableTypeVariable(type);
                }
            }
            if (variable != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
            }
        }
    }

    public final void endVisit(ConditionalExpression node) {
        ITypeBinding binding;
        Expression elseExpression;
        ConstraintVariable2 thenVariable = null;
        ConstraintVariable2 elseVariable = null;
        Expression thenExpression = node.getThenExpression();
        if (thenExpression != null) {
            thenVariable = (ConstraintVariable2)thenExpression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        }
        if ((elseExpression = node.getElseExpression()) != null) {
            elseVariable = (ConstraintVariable2)elseExpression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        }
        if ((binding = node.resolveTypeBinding()) != null) {
            ConstraintVariable2 ancestor;
            if (binding.isArray()) {
                binding = binding.getElementType();
            }
            if ((ancestor = this.fModel.createIndependentTypeVariable(binding)) != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
                if (thenVariable != null) {
                    this.fModel.createSubtypeConstraint(thenVariable, ancestor);
                }
                if (elseVariable != null) {
                    this.fModel.createSubtypeConstraint(elseVariable, ancestor);
                }
                if (thenVariable != null && elseVariable != null) {
                    this.fModel.createConditionalTypeConstraint(ancestor, thenVariable, elseVariable);
                }
            }
        }
    }

    public final void endVisit(ConstructorInvocation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
        }
    }

    public final void endVisit(FieldAccess node) {
        this.endVisit(node.resolveFieldBinding(), node.getExpression(), (Expression)node);
    }

    public final void endVisit(FieldDeclaration node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    private void endVisit(IMethodBinding binding) {
        IMethodBinding method = null;
        ConstraintVariable2 ancestor = null;
        ConstraintVariable2 descendant = this.fModel.createReturnTypeVariable(binding);
        if (descendant != null) {
            Collection originals = this.getOriginalMethods(binding);
            Iterator iterator = originals.iterator();
            while (iterator.hasNext()) {
                method = (IMethodBinding)iterator.next();
                if (method.getKey().equals(binding.getKey()) || (ancestor = this.fModel.createReturnTypeVariable(method)) == null) continue;
                this.fModel.createCovariantTypeConstraint(descendant, ancestor);
            }
        }
    }

    private void endVisit(IMethodBinding binding, ConstraintVariable2 descendant) {
        ITypeBinding declaring = null;
        IMethodBinding method = null;
        Collection originals = this.getOriginalMethods(binding);
        Iterator iterator = originals.iterator();
        while (iterator.hasNext()) {
            ConstraintVariable2 ancestor;
            method = (IMethodBinding)iterator.next();
            declaring = method.getDeclaringClass();
            if (declaring == null || (ancestor = this.fModel.createDeclaringTypeVariable(declaring)) == null) continue;
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    private void endVisit(ITypeBinding binding, Name node) {
        ConstraintVariable2 variable = this.fModel.createExceptionVariable(node);
        if (variable != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    private void endVisit(IVariableBinding binding, Expression qualifier, Expression access) {
        ConstraintVariable2 ancestor;
        ITypeBinding type;
        access.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createVariableVariable(binding));
        if (qualifier != null && (type = binding.getDeclaringClass()) != null && (ancestor = this.fModel.createDeclaringTypeVariable(type)) != null) {
            ConstraintVariable2 descendant = (ConstraintVariable2)qualifier.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
            if (ancestor != null && descendant != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
        }
    }

    private void endVisit(List arguments, IMethodBinding binding) {
        Expression expression = null;
        ConstraintVariable2 ancestor = null;
        ConstraintVariable2 descendant = null;
        int index = 0;
        while (index < arguments.size()) {
            expression = (Expression)arguments.get(index);
            descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
            ancestor = this.fModel.createMethodParameterVariable(binding, index);
            if (ancestor != null && descendant != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
            ++index;
        }
    }

    private void endVisit(List fragments, Type type, ASTNode parent) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)type.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (ancestor != null) {
            IVariableBinding binding = null;
            ConstraintVariable2 descendant = null;
            VariableDeclarationFragment fragment = null;
            int index = 0;
            while (index < fragments.size()) {
                fragment = (VariableDeclarationFragment)fragments.get(index);
                descendant = (ConstraintVariable2)fragment.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (descendant != null) {
                    this.fModel.createSubtypeConstraint(descendant, ancestor);
                }
                if ((binding = fragment.resolveBinding()) != null && (descendant = this.fModel.createVariableVariable(binding)) != null) {
                    this.fModel.createEqualityConstraint(ancestor, descendant);
                }
                ++index;
            }
            parent.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
        }
    }

    public final void endVisit(MethodDeclaration node) {
        this.fCurrentMethods.pop();
        IMethodBinding binding = node.resolveBinding();
        if (binding != null) {
            ITypeBinding throwable;
            List exceptions;
            Type type;
            if (!binding.isConstructor() && (type = node.getReturnType2()) != null) {
                ConstraintVariable2 first = this.fModel.createReturnTypeVariable(binding);
                ConstraintVariable2 second = (ConstraintVariable2)type.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                if (first != null) {
                    if (second != null) {
                        this.fModel.createEqualityConstraint(first, second);
                    }
                    this.endVisit(binding);
                }
            }
            ConstraintVariable2 ancestor = null;
            ConstraintVariable2 descendant = null;
            IVariableBinding variable = null;
            List parameters = node.parameters();
            if (!parameters.isEmpty()) {
                Collection originals = this.getOriginalMethods(binding);
                SingleVariableDeclaration declaration = null;
                int index = 0;
                while (index < parameters.size()) {
                    declaration = (SingleVariableDeclaration)parameters.get(index);
                    ancestor = this.fModel.createMethodParameterVariable(binding, index);
                    if (ancestor != null) {
                        descendant = (ConstraintVariable2)declaration.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                        if (descendant != null) {
                            this.fModel.createEqualityConstraint(descendant, ancestor);
                        }
                        if ((variable = declaration.resolveBinding()) != null && (descendant = this.fModel.createVariableVariable(variable)) != null) {
                            this.fModel.createEqualityConstraint(ancestor, descendant);
                        }
                        IMethodBinding method = null;
                        Iterator iterator = originals.iterator();
                        while (iterator.hasNext()) {
                            method = (IMethodBinding)iterator.next();
                            if (method.getKey().equals(binding.getKey()) || (descendant = this.fModel.createMethodParameterVariable(method, index)) == null) continue;
                            this.fModel.createEqualityConstraint(ancestor, descendant);
                        }
                    }
                    ++index;
                }
            }
            if (!(exceptions = node.thrownExceptions()).isEmpty() && (throwable = node.getAST().resolveWellKnownType("java.lang.Throwable")) != null && (ancestor = this.fModel.createImmutableTypeVariable(throwable)) != null) {
                Name exception = null;
                int index = 0;
                while (index < exceptions.size()) {
                    exception = (Name)exceptions.get(index);
                    descendant = (ConstraintVariable2)exception.getProperty(PROPERTY_CONSTRAINT_VARIABLE);
                    if (descendant != null) {
                        this.fModel.createSubtypeConstraint(descendant, ancestor);
                    }
                    ++index;
                }
            }
        }
    }

    public final void endVisit(MethodInvocation node) {
        IMethodBinding binding = node.resolveMethodBinding();
        if (binding != null) {
            ConstraintVariable2 descendant;
            this.endVisit(node, binding);
            this.endVisit(node.arguments(), binding);
            Expression expression = node.getExpression();
            if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                this.endVisit(binding, descendant);
            }
        }
    }

    private void endVisit(MethodInvocation invocation, IMethodBinding binding) {
        ConstraintVariable2 variable;
        if (!binding.isConstructor() && (variable = this.fModel.createReturnTypeVariable(binding)) != null) {
            invocation.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
    }

    public final void endVisit(NullLiteral node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createImmutableTypeVariable(node.resolveTypeBinding()));
    }

    public final void endVisit(ParenthesizedExpression node) {
        node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, node.getExpression().getProperty(PROPERTY_CONSTRAINT_VARIABLE));
    }

    public final void endVisit(QualifiedName node) {
        ConstraintVariable2 variable;
        ASTNode parent = node.getParent();
        Name qualifier = node.getQualifier();
        IBinding binding = qualifier.resolveBinding();
        if (binding instanceof ITypeBinding && (variable = this.fModel.createTypeVariable((ITypeBinding)binding, new CompilationUnitRange(RefactoringASTParser.getCompilationUnit((ASTNode)node), new SourceRange(qualifier.getStartPosition(), qualifier.getLength())))) != null) {
            qualifier.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)variable);
        }
        if ((binding = node.getName().resolveBinding()) instanceof IVariableBinding && !(parent instanceof ImportDeclaration)) {
            this.endVisit((IVariableBinding)binding, (Expression)qualifier, (Expression)node);
        } else if (binding instanceof ITypeBinding && parent instanceof MethodDeclaration) {
            this.endVisit((ITypeBinding)binding, (Name)node);
        }
    }

    public final void endVisit(ReturnStatement node) {
        ConstraintVariable2 ancestor;
        IMethodBinding binding;
        MethodDeclaration declaration;
        ConstraintVariable2 descendant;
        Expression expression = node.getExpression();
        if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null && (declaration = (MethodDeclaration)this.fCurrentMethods.peek()) != null && (binding = declaration.resolveBinding()) != null && (ancestor = this.fModel.createReturnTypeVariable(binding)) != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
            this.fModel.createSubtypeConstraint(descendant, ancestor);
        }
    }

    public final void endVisit(SimpleName node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof ImportDeclaration || parent instanceof PackageDeclaration || parent instanceof AbstractTypeDeclaration)) {
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding && !(parent instanceof MethodDeclaration)) {
                this.endVisit((IVariableBinding)binding, null, (Expression)node);
            } else if (binding instanceof ITypeBinding && parent instanceof MethodDeclaration) {
                this.endVisit((ITypeBinding)binding, (Name)node);
            }
        }
    }

    public final void endVisit(SingleVariableDeclaration node) {
        ConstraintVariable2 ancestor = (ConstraintVariable2)node.getType().getProperty(PROPERTY_CONSTRAINT_VARIABLE);
        if (ancestor != null) {
            ConstraintVariable2 descendant;
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
            Expression expression = node.getInitializer();
            if (expression != null && (descendant = (ConstraintVariable2)expression.getProperty(PROPERTY_CONSTRAINT_VARIABLE)) != null) {
                this.fModel.createSubtypeConstraint(descendant, ancestor);
            }
        }
    }

    public final void endVisit(SuperConstructorInvocation node) {
        IMethodBinding binding = node.resolveConstructorBinding();
        if (binding != null) {
            this.endVisit(node.arguments(), binding);
        }
    }

    public final void endVisit(SuperFieldAccess node) {
        SimpleName name = node.getName();
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariableBinding) {
            this.endVisit((IVariableBinding)binding, null, (Expression)node);
        }
    }

    public final void endVisit(SuperMethodInvocation node) {
        IMethodBinding superBinding = node.resolveMethodBinding();
        if (superBinding != null) {
            ConstraintVariable2 ancestor;
            IMethodBinding subBinding;
            this.endVisit(node.arguments(), superBinding);
            MethodDeclaration declaration = (MethodDeclaration)this.fCurrentMethods.peek();
            if (declaration != null && (subBinding = declaration.resolveBinding()) != null && (ancestor = this.fModel.createReturnTypeVariable(superBinding)) != null) {
                node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)ancestor);
                ConstraintVariable2 descendant = this.fModel.createReturnTypeVariable(subBinding);
                if (descendant != null) {
                    this.fModel.createEqualityConstraint(descendant, ancestor);
                }
            }
        }
    }

    public final void endVisit(ThisExpression node) {
        ITypeBinding binding = node.resolveTypeBinding();
        if (binding != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createDeclaringTypeVariable(binding));
        }
    }

    public final void endVisit(Type node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof AbstractTypeDeclaration || parent instanceof ClassInstanceCreation || parent instanceof TypeLiteral || parent instanceof InstanceofExpression && !this.fInstanceOf)) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, (Object)this.fModel.createTypeVariable(node));
        }
    }

    public final void endVisit(VariableDeclarationExpression node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    public final void endVisit(VariableDeclarationFragment node) {
        Expression initializer = node.getInitializer();
        if (initializer != null) {
            node.setProperty(PROPERTY_CONSTRAINT_VARIABLE, initializer.getProperty(PROPERTY_CONSTRAINT_VARIABLE));
        }
    }

    public final void endVisit(VariableDeclarationStatement node) {
        this.endVisit(node.fragments(), node.getType(), (ASTNode)node);
    }

    private Collection getOriginalMethods(IMethodBinding binding) {
        ArrayList<IMethodBinding> originals = new ArrayList<IMethodBinding>();
        ITypeBinding type = binding.getDeclaringClass();
        SuperTypeConstraintsCreator.getOriginalMethods(binding, type, originals, false);
        SuperTypeConstraintsCreator.getOriginalMethods(binding, type, originals, true);
        if (originals.isEmpty()) {
            originals.add(binding);
        }
        return originals;
    }

    public final boolean visit(AnnotationTypeDeclaration node) {
        return false;
    }

    public final boolean visit(Comment node) {
        return false;
    }

    public final boolean visit(MethodDeclaration node) {
        this.fCurrentMethods.push(node);
        return super.visit(node);
    }

    public final boolean visit(ThisExpression node) {
        return false;
    }

    public final boolean visit(Type node) {
        return false;
    }
}

