/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class RenameEnumConstProcessor
extends RenameFieldProcessor {
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameEnumConstProcessor";

    public RenameEnumConstProcessor(IField field) {
        super(field);
    }

    public boolean isApplicable() throws CoreException {
        return RefactoringAvailabilityTester.isRenameEnumConstAvailable(this.getField());
    }

    public String canEnableGetterRenaming() throws CoreException {
        return "";
    }

    public String canEnableSetterRenaming() throws CoreException {
        return "";
    }

    public RefactoringStatus checkNewElementName(String newName) throws CoreException {
        RefactoringStatus result = Checks.checkEnumConstantName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.getField(), newName)) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_another_name);
        }
        if (this.getField().getDeclaringType().getField(newName).exists()) {
            result.addFatalError(RefactoringCoreMessages.RenameEnumConstRefactoring_const_already_defined);
        }
        return result;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public String getProcessorName() {
        return Messages.format(RefactoringCoreMessages.RenameEnumConstRefactoring_name, new String[]{this.getCurrentElementName(), this.getNewElementName()});
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
    }
}

