/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.codemanipulation.ImportRewrite;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.JavaElementMapper;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.code.CallInliner;
import org.eclipse.jdt.internal.corext.refactoring.code.Invocations;
import org.eclipse.jdt.internal.corext.refactoring.code.SourceProvider;
import org.eclipse.jdt.internal.corext.refactoring.code.TargetProvider;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class InlineMethodRefactoring
extends Refactoring {
    private ICompilationUnit fInitialCUnit;
    private ASTNode fInitialNode;
    private TextChangeManager fChangeManager;
    private SourceProvider fSourceProvider;
    private TargetProvider fTargetProvider;
    private boolean fDeleteSource;
    private Mode fCurrentMode;
    private Mode fInitialMode;
    static /* synthetic */ Class class$0;

    private InlineMethodRefactoring(ICompilationUnit unit, ASTNode node) {
        Assert.isNotNull(unit);
        Assert.isNotNull(node);
        this.fInitialCUnit = unit;
        this.fInitialNode = node;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodInvocation node) {
        this(unit, (ASTNode)node);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, SuperMethodInvocation node) {
        this(unit, (ASTNode)node);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, ConstructorInvocation node) {
        this(unit, (ASTNode)node);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_SINGLE;
        this.fDeleteSource = false;
    }

    private InlineMethodRefactoring(ICompilationUnit unit, MethodDeclaration node) {
        this(unit, (ASTNode)node);
        this.fSourceProvider = new SourceProvider(unit, node);
        this.fTargetProvider = TargetProvider.create(unit, node);
        this.fInitialMode = this.fCurrentMode = Mode.INLINE_ALL;
        this.fDeleteSource = true;
    }

    public static InlineMethodRefactoring create(ICompilationUnit unit, CompilationUnit root, int offset, int length) {
        ASTNode node = InlineMethodRefactoring.getTargetNode(unit, root, offset, length);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 32) {
            return new InlineMethodRefactoring(unit, (MethodInvocation)node);
        }
        if (node.getNodeType() == 31) {
            return new InlineMethodRefactoring(unit, (MethodDeclaration)node);
        }
        if (node.getNodeType() == 48) {
            return new InlineMethodRefactoring(unit, (SuperMethodInvocation)node);
        }
        if (node.getNodeType() == 17) {
            return new InlineMethodRefactoring(unit, (ConstructorInvocation)node);
        }
        return null;
    }

    public String getName() {
        return RefactoringCoreMessages.InlineMethodRefactoring_name;
    }

    public boolean getDeleteSource() {
        return this.fDeleteSource;
    }

    public void setDeleteSource(boolean remove) {
        this.fDeleteSource = remove;
    }

    public Mode getInitialMode() {
        return this.fInitialMode;
    }

    public RefactoringStatus setCurrentMode(Mode mode) throws JavaModelException {
        if (this.fCurrentMode == mode) {
            return new RefactoringStatus();
        }
        Assert.isTrue(this.getInitialMode() == Mode.INLINE_SINGLE);
        this.fCurrentMode = mode;
        this.fTargetProvider = mode == Mode.INLINE_SINGLE ? TargetProvider.create(this.fInitialCUnit, (MethodInvocation)this.fInitialNode) : TargetProvider.create(this.fSourceProvider.getCompilationUnit(), this.fSourceProvider.getDeclaration());
        return this.fTargetProvider.checkActivation();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        if (this.fSourceProvider == null && Invocations.isInvocation(this.fInitialNode)) {
            this.fSourceProvider = InlineMethodRefactoring.resolveSourceProvider(result, this.fInitialCUnit, this.fInitialNode);
            if (result.hasFatalError()) {
                return result;
            }
        }
        this.fTargetProvider.setSourceProvider(this.fSourceProvider);
        result.merge(this.fSourceProvider.checkActivation());
        result.merge(this.fTargetProvider.checkActivation());
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 3);
        this.fChangeManager = new TextChangeManager();
        RefactoringStatus result = new RefactoringStatus();
        this.fSourceProvider.initialize();
        this.fTargetProvider.initialize();
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_searching);
        RefactoringStatus searchStatus = new RefactoringStatus();
        ICompilationUnit[] units = this.fTargetProvider.getAffectedCompilationUnits(searchStatus, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        if (searchStatus.hasFatalError()) {
            result.merge(searchStatus);
            return result;
        }
        result.merge(Checks.validateModifiesFiles(this.getFilesToBeModified(units), this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        this.checkOverridden(result, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        SubProgressMonitor sub = new SubProgressMonitor(pm, 1);
        sub.beginTask("", units.length * 3);
        int c = 0;
        while (c < units.length) {
            block19: {
                Object var20_21;
                ICompilationUnit unit = units[c];
                sub.subTask(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_processing, unit.getElementName()));
                CallInliner inliner = null;
                try {
                    boolean added = false;
                    MultiTextEdit root = new MultiTextEdit();
                    CompilationUnitChange change = (CompilationUnitChange)this.fChangeManager.get(unit);
                    change.setEdit((TextEdit)root);
                    BodyDeclaration[] bodies = this.fTargetProvider.getAffectedBodyDeclarations(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                    if (bodies.length == 0) {
                        var20_21 = null;
                        if (inliner != null) {
                            inliner.dispose();
                        }
                        break block19;
                    }
                    inliner = new CallInliner(unit, bodies[0].getAST(), this.fSourceProvider);
                    int b = 0;
                    while (b < bodies.length) {
                        BodyDeclaration body = bodies[b];
                        inliner.initialize(body);
                        RefactoringStatus nestedInvocations = new RefactoringStatus();
                        ASTNode[] invocations = this.removeNestedCalls(nestedInvocations, unit, this.fTargetProvider.getInvocations(body, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                        int i = 0;
                        while (i < invocations.length) {
                            ASTNode invocation = invocations[i];
                            result.merge(inliner.initialize(invocation, this.fTargetProvider.getStatusSeverity()));
                            if (result.hasFatalError()) break;
                            if (result.getSeverity() < this.fTargetProvider.getStatusSeverity()) {
                                added = true;
                                TextEditGroup group = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_inline);
                                change.addTextEditGroup(group);
                                result.merge(inliner.perform(group));
                            } else {
                                this.fDeleteSource = false;
                            }
                            ++i;
                        }
                        if (!nestedInvocations.isOK()) {
                            result.merge(nestedInvocations);
                            this.fDeleteSource = false;
                        }
                        ++b;
                    }
                    if (!added) {
                        this.fChangeManager.remove(unit);
                    } else {
                        TextEdit edit;
                        root.addChild(inliner.getModifications());
                        ImportRewrite rewrite = inliner.getImportEdit();
                        if (!(rewrite.isEmpty() || (edit = rewrite.createEdit(inliner.getBuffer().getDocument(), null)) instanceof MultiTextEdit && ((MultiTextEdit)edit).getChildrenSize() <= 0)) {
                            root.addChild(edit);
                            change.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_import, new TextEdit[]{edit}));
                        }
                    }
                    var20_21 = null;
                    if (inliner != null) {
                        inliner.dispose();
                    }
                }
                catch (Throwable throwable) {
                    var20_21 = null;
                    if (inliner != null) {
                        inliner.dispose();
                    }
                    throw throwable;
                }
                sub.worked(1);
                if (sub.isCanceled()) {
                    throw new OperationCanceledException();
                }
            }
            ++c;
        }
        result.merge(searchStatus);
        sub.done();
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fDeleteSource && this.fCurrentMode == Mode.INLINE_ALL) {
            TextChange change = this.fChangeManager.get(this.fSourceProvider.getCompilationUnit());
            TextEdit delete = this.fSourceProvider.getDeleteEdit();
            TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.InlineMethodRefactoring_edit_delete, new TextEdit[]{delete});
            TextEdit root = change.getEdit();
            if (root != null) {
                TextChangeCompatibility.insert(root, delete);
            } else {
                change.setEdit(delete);
            }
            change.addTextEditGroup(description);
        }
        return new DynamicValidationStateChange(RefactoringCoreMessages.InlineMethodRefactoring_edit_inlineCall, (Change[])this.fChangeManager.getAllChanges());
    }

    private static SourceProvider resolveSourceProvider(RefactoringStatus status, ICompilationUnit unit, ASTNode invocation) throws JavaModelException {
        CompilationUnit root = (CompilationUnit)invocation.getRoot();
        IMethodBinding methodBinding = Invocations.resolveBinding(invocation);
        if (methodBinding == null) {
            status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
            return null;
        }
        MethodDeclaration declaration = (MethodDeclaration)root.findDeclaringNode((IBinding)methodBinding);
        if (declaration != null) {
            return new SourceProvider(unit, declaration);
        }
        IMethod method = (IMethod)methodBinding.getJavaElement();
        if (method != null) {
            ICompilationUnit source = method.getCompilationUnit();
            if (source == null) {
                status.addFatalError(Messages.format(RefactoringCoreMessages.InlineMethodRefactoring_error_classFile, method.getElementName()));
                return null;
            }
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((declaration = (MethodDeclaration)JavaElementMapper.perform((IMember)method, clazz)) != null) {
                return new SourceProvider(source, declaration);
            }
        }
        status.addFatalError(RefactoringCoreMessages.InlineMethodRefactoring_error_noMethodDeclaration);
        return null;
    }

    private static ASTNode getTargetNode(ICompilationUnit unit, CompilationUnit root, int offset, int length) {
        ASTNode node = null;
        try {
            node = InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length, unit));
        }
        catch (JavaModelException javaModelException) {
            node = null;
        }
        if (node != null) {
            return node;
        }
        return InlineMethodRefactoring.checkNode(NodeFinder.perform((ASTNode)root, offset, length));
    }

    private static ASTNode checkNode(ASTNode node) {
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == 42) {
            node = node.getParent();
        } else if (node.getNodeType() == 21) {
            node = ((ExpressionStatement)node).getExpression();
        }
        switch (node.getNodeType()) {
            case 17: 
            case 31: 
            case 32: 
            case 48: {
                return node;
            }
        }
        return null;
    }

    private IFile[] getFilesToBeModified(ICompilationUnit[] units) {
        IFile file;
        ArrayList<IFile> result = new ArrayList<IFile>(units.length + 1);
        int i = 0;
        while (i < units.length) {
            file = this.getFile(units[i]);
            if (file != null) {
                result.add(file);
            }
            ++i;
        }
        file = this.getFile(this.fSourceProvider.getCompilationUnit());
        if (file != null && !result.contains(file)) {
            result.add(file);
        }
        return result.toArray(new IFile[result.size()]);
    }

    private IFile getFile(ICompilationUnit unit) {
        IResource resource = (unit = JavaModelUtil.toOriginal(unit)).getResource();
        if (resource != null && resource.getType() == 1) {
            return (IFile)resource;
        }
        return null;
    }

    private void checkOverridden(RefactoringStatus status, IProgressMonitor pm) throws JavaModelException {
        pm.beginTask("", 9);
        pm.setTaskName(RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden);
        MethodDeclaration decl = this.fSourceProvider.getDeclaration();
        IMethod method = Bindings.findMethod(decl.resolveBinding(), this.fSourceProvider.getCompilationUnit().getJavaProject());
        if (method == null || Flags.isPrivate((int)method.getFlags())) {
            pm.worked(8);
            return;
        }
        IType type = method.getDeclaringType();
        ITypeHierarchy hierarchy = type.newTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 6));
        this.checkSubTypes(status, method, hierarchy.getAllSubtypes(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperClasses(status, method, hierarchy.getAllSuperclasses(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        this.checkSuperInterfaces(status, method, hierarchy.getAllSuperInterfaces(type), (IProgressMonitor)new SubProgressMonitor(pm, 1));
        pm.setTaskName("");
    }

    private void checkSubTypes(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overridden_error, pm);
    }

    private void checkSuperClasses(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_overrides_error, pm);
    }

    private void checkSuperInterfaces(RefactoringStatus result, IMethod method, IType[] types, IProgressMonitor pm) {
        this.checkTypes(result, method, types, RefactoringCoreMessages.InlineMethodRefactoring_checking_implements_error, pm);
    }

    private void checkTypes(RefactoringStatus result, IMethod method, IType[] types, String key, IProgressMonitor pm) {
        pm.beginTask("", types.length);
        int i = 0;
        while (i < types.length) {
            pm.worked(1);
            IMethod[] overridden = types[i].findMethods(method);
            if (overridden != null && overridden.length > 0) {
                result.addError(Messages.format(key, types[i].getElementName()), JavaStatusContext.create((IMember)overridden[0]));
            }
            ++i;
        }
    }

    private ASTNode[] removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] invocations) {
        if (invocations.length <= 1) {
            return invocations;
        }
        ASTNode[] parents = new ASTNode[invocations.length];
        int i = 0;
        while (i < invocations.length) {
            parents[i] = invocations[i].getParent();
            ++i;
        }
        i = 0;
        while (i < invocations.length) {
            this.removeNestedCalls(status, unit, parents, invocations, i);
            ++i;
        }
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        int i2 = 0;
        while (i2 < invocations.length) {
            if (invocations[i2] != null) {
                result.add(invocations[i2]);
            }
            ++i2;
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private void removeNestedCalls(RefactoringStatus status, ICompilationUnit unit, ASTNode[] parents, ASTNode[] invocations, int index) {
        ASTNode invocation = invocations[index];
        int i = 0;
        while (i < parents.length) {
            ASTNode parent = parents[i];
            while (parent != null) {
                if (parent == invocation) {
                    status.addError(RefactoringCoreMessages.InlineMethodRefactoring_nestedInvocation, JavaStatusContext.create(unit, parent));
                    invocations[index] = null;
                }
                parent = parent.getParent();
            }
            ++i;
        }
    }

    public static class Mode {
        public static final Mode INLINE_ALL = new Mode();
        public static final Mode INLINE_SINGLE = new Mode();

        private Mode() {
        }
    }
}

