/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.build.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class ManifestModifier
extends Task {
    private String manifestLocation;
    private Map newValues = new HashMap();
    private static String DELIM = "#|";
    private Manifest manifest = null;
    private boolean contentChanged = false;

    public void setKeyValue(String values) {
        StringTokenizer tokenizer = new StringTokenizer(values, DELIM, false);
        while (tokenizer.hasMoreElements()) {
            String key = tokenizer.nextToken();
            String value = tokenizer.nextToken();
            if (value.equals("null")) {
                value = null;
            }
            this.newValues.put(key, value);
        }
    }

    public void execute() {
        this.loadManifest();
        this.applyChanges();
        this.writeManifest();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeManifest() {
        if (!this.contentChanged) {
            return;
        }
        BufferedOutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(this.manifestLocation));
            try {
                this.manifest.write(os);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ((OutputStream)os).close();
                throw throwable;
            }
            {
                Object var2_4 = null;
                ((OutputStream)os).close();
                return;
            }
        }
        catch (IOException iOException) {
            new BuildException("Problem writing the content of the manifest : " + this.manifestLocation);
        }
    }

    private void applyChanges() {
        Iterator iter = this.newValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (value == null) {
                this.removeAttribute(key);
                continue;
            }
            this.changeValue(key, value);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadManifest() {
        try {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.manifestLocation));
            try {
                this.manifest = new Manifest(is);
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                ((InputStream)is).close();
                throw throwable;
            }
            {
                Object var2_4 = null;
                ((InputStream)is).close();
                return;
            }
        }
        catch (IOException iOException) {
            new BuildException("Problem reading the content of the manifest : " + this.manifestLocation);
        }
    }

    private void changeValue(String key, String value) {
        if (this.manifest.getMainAttributes().getValue(key).equals(value)) {
            return;
        }
        this.contentChanged = true;
        this.manifest.getMainAttributes().put(new Attributes.Name(key), value);
    }

    private void removeAttribute(String key) {
        this.contentChanged = true;
        this.manifest.getMainAttributes().remove(new Attributes.Name(key));
    }

    public void setManifestLocation(String path) {
        this.manifestLocation = path;
    }
}

