/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.File;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginExtensionPoint;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CoreUtility {
    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    public static void createFolder(IFolder folder) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent);
            }
            folder.create(true, true, null);
        }
    }

    public static void createProject(IProject project, IPath location, IProgressMonitor monitor) throws CoreException {
        if (!Platform.getLocation().equals((Object)location)) {
            IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
            desc.setLocation(location);
            project.create(desc, monitor);
        } else {
            project.create(monitor);
        }
    }

    public static String getWritableString(String source) {
        if (source == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            char c = source.charAt(i);
            switch (c) {
                case '&': {
                    buf.append("&amp;");
                    break;
                }
                case '<': {
                    buf.append("&lt;");
                    break;
                }
                case '>': {
                    buf.append("&gt;");
                    break;
                }
                case '\'': {
                    buf.append("&apos;");
                    break;
                }
                case '\"': {
                    buf.append("&quot;");
                    break;
                }
                default: {
                    buf.append(c);
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String normalize(String text) {
        if (text == null || text.trim().length() == 0) {
            return "";
        }
        text = text.replaceAll("\\r|\\n|\\f|\\t", " ");
        return text.replaceAll("\\s+", " ");
    }

    public static void deleteContent(File curr) {
        if (curr.exists()) {
            File[] children;
            if (curr.isDirectory() && (children = curr.listFiles()) != null) {
                int i = 0;
                while (i < children.length) {
                    CoreUtility.deleteContent(children[i]);
                    ++i;
                }
            }
            curr.delete();
        }
    }

    public static Element writeExtension(Document doc, IPluginExtension extension) {
        Element child = doc.createElement("extension");
        if (extension.getPoint() != null) {
            child.setAttribute("point", CoreUtility.getWritableString(extension.getPoint()));
        }
        if (extension.getName() != null) {
            child.setAttribute("name", CoreUtility.getWritableString(extension.getName()));
        }
        if (extension.getId() != null) {
            child.setAttribute("id", CoreUtility.getWritableString(extension.getId()));
        }
        if (extension instanceof PluginExtension) {
            child.setAttribute("line", Integer.toString(((PluginExtension)extension).getStartLine()));
        }
        IPluginObject[] children = extension.getChildren();
        int i = 0;
        while (i < children.length) {
            child.appendChild(CoreUtility.writeElement(doc, (IPluginElement)children[i]));
            ++i;
        }
        return child;
    }

    public static Element writeElement(Document doc, IPluginElement element) {
        Element child = doc.createElement(element.getName());
        IPluginAttribute[] attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.length) {
            child.setAttribute(attrs[i].getName(), CoreUtility.getWritableString(attrs[i].getValue()));
            ++i;
        }
        IPluginObject[] elements = element.getChildren();
        int i2 = 0;
        while (i2 < elements.length) {
            child.appendChild(CoreUtility.writeElement(doc, (IPluginElement)elements[i2]));
            ++i2;
        }
        return child;
    }

    public static Element writeExtensionPoint(Document doc, IPluginExtensionPoint extPoint) {
        Element child = doc.createElement("extension-point");
        if (extPoint.getId() != null) {
            child.setAttribute("id", CoreUtility.getWritableString(extPoint.getId()));
        }
        if (extPoint.getName() != null) {
            child.setAttribute("name", CoreUtility.getWritableString(extPoint.getName()));
        }
        if (extPoint.getSchema() != null) {
            child.setAttribute("schema", CoreUtility.getWritableString(extPoint.getSchema()));
        }
        if (extPoint instanceof PluginExtensionPoint) {
            child.setAttribute("line", Integer.toString(((PluginExtensionPoint)extPoint).getStartLine()));
        }
        return child;
    }

    public static boolean guessUnpack(BundleDescription bundle) {
        IPluginModelBase model;
        if (bundle == null) {
            return true;
        }
        if (new File(bundle.getLocation()).isFile()) {
            return false;
        }
        IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
        IContainer container = root.getContainerForLocation((IPath)new Path(bundle.getLocation()));
        if (container == null) {
            return true;
        }
        if (container instanceof IProject) {
            try {
                if (!((IProject)container).hasNature("org.eclipse.jdt.core.javanature")) {
                    return true;
                }
            }
            catch (CoreException coreException) {}
        }
        if ((model = PDECore.getDefault().getModelManager().findModel(bundle)) == null) {
            return true;
        }
        IPluginLibrary[] libraries = model.getPluginBase().getLibraries();
        if (libraries.length == 0 && PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            return false;
        }
        int i = 0;
        while (i < libraries.length) {
            if (libraries[i].getName().equals(".")) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

