/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.EntryFileAdapter;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.RequiredPluginsClasspathContainer;

public class ModelEntry
extends PlatformObject {
    public static final int AUTOMATIC = 0;
    public static final int WORKSPACE = 1;
    public static final int EXTERNAL = 2;
    private String id;
    private IPluginModelBase workspaceModel;
    private IPluginModelBase externalModel;
    private int mode = 0;
    private RequiredPluginsClasspathContainer classpathContainer;
    private boolean inJavaSearch = false;
    private PluginModelManager manager;

    public ModelEntry(PluginModelManager manager, String id) {
        this.manager = manager;
        this.id = id;
    }

    public IPluginModelBase getActiveModel() {
        if (this.mode == 0) {
            if (this.workspaceModel != null) {
                return this.workspaceModel;
            }
            return this.externalModel;
        }
        return this.mode == 1 ? this.workspaceModel : this.externalModel;
    }

    public String getId() {
        return this.id;
    }

    public Object[] getChildren() {
        File file;
        if (this.workspaceModel == null && this.externalModel != null && !(file = new File(this.externalModel.getInstallLocation())).isFile()) {
            EntryFileAdapter adapter = new EntryFileAdapter(this, file, this.manager.getFileAdapterFactory());
            return adapter.getChildren();
        }
        return new Object[0];
    }

    public boolean isInJavaSearch() {
        return this.inJavaSearch;
    }

    void setInJavaSearch(boolean value) {
        this.inJavaSearch = value;
    }

    public void setWorkspaceModel(IPluginModelBase model) {
        this.workspaceModel = model;
        this.classpathContainer = null;
    }

    public void setExternalModel(IPluginModelBase model) {
        this.externalModel = model;
        this.classpathContainer = null;
    }

    public IPluginModelBase getWorkspaceModel() {
        return this.workspaceModel;
    }

    public IPluginModelBase getExternalModel() {
        return this.externalModel;
    }

    public boolean isEmpty() {
        return this.workspaceModel == null && this.externalModel == null;
    }

    public RequiredPluginsClasspathContainer getClasspathContainer() {
        if (this.classpathContainer == null) {
            this.classpathContainer = new RequiredPluginsClasspathContainer(this.workspaceModel);
        }
        return this.classpathContainer;
    }

    public void updateClasspathContainer(boolean force, boolean doCheckClasspath) throws CoreException {
        if (this.shouldUpdateClasspathContainer(force, doCheckClasspath)) {
            IProject project = this.workspaceModel.getUnderlyingResource().getProject();
            IJavaProject[] javaProjects = new IJavaProject[]{JavaCore.create((IProject)project)};
            IClasspathContainer[] containers = new IClasspathContainer[]{this.getClasspathContainer()};
            Path path = new Path("org.eclipse.pde.core.requiredPlugins");
            try {
                this.getClasspathContainer().reset();
                JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
            }
            catch (OperationCanceledException e) {
                this.getClasspathContainer().reset();
                throw e;
            }
        }
    }

    public boolean shouldUpdateClasspathContainer(boolean force, boolean doCheckClasspath) throws CoreException {
        if (this.workspaceModel == null) {
            return false;
        }
        IProject project = this.workspaceModel.getUnderlyingResource().getProject();
        if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
            return false;
        }
        if (doCheckClasspath && !this.workspaceModel.isLoaded()) {
            return false;
        }
        if (force) {
            this.classpathContainer = null;
        }
        RequiredPluginsClasspathContainer container = this.getClasspathContainer();
        container.reset();
        return true;
    }

    public static void updateUnknownClasspathContainer(IJavaProject javaProject) throws CoreException {
        if (javaProject == null) {
            return;
        }
        Path path = new Path("org.eclipse.pde.core.requiredPlugins");
        JavaCore.setClasspathContainer((IPath)path, (IJavaProject[])new IJavaProject[]{javaProject}, (IClasspathContainer[])new IClasspathContainer[]{new RequiredPluginsClasspathContainer(null)}, null);
    }

    public boolean isAffected(IPluginBase[] changedPlugins, ArrayList oldIds) {
        if (this.workspaceModel == null || !this.workspaceModel.isLoaded()) {
            return false;
        }
        IPluginBase plugin = this.workspaceModel.getPluginBase();
        int i = 0;
        while (i < changedPlugins.length) {
            IPluginBase changedPlugin = changedPlugins[i];
            String id = changedPlugin.getId();
            if (id != null) {
                if (plugin.getId() != null && plugin.getId().equals(id)) {
                    return true;
                }
                if (this.isRequired(changedPlugin)) {
                    return true;
                }
            }
            ++i;
        }
        i = 0;
        while (i < oldIds.size()) {
            String oldId = (String)oldIds.get(i);
            if (plugin.getId().equals(oldId)) {
                return true;
            }
            if (this.isRequired(oldId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isRequired(IPluginBase changedPlugin) {
        String id = changedPlugin instanceof IFragment ? ((IFragment)changedPlugin).getPluginId() : changedPlugin.getId();
        return this.isRequired(id);
    }

    private boolean isRequired(String changedId) {
        return this.id == null ? false : this.getRequiredIds().contains(changedId);
    }

    private HashSet getRequiredIds() {
        IPluginBase plugin = this.workspaceModel.getPluginBase();
        HashSet<String> set = new HashSet<String>();
        if (plugin instanceof IFragment) {
            this.addParentPlugin(((IFragment)plugin).getPluginId(), set);
        }
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            this.addDependency(imports[i].getId(), set);
            ++i;
        }
        String id = plugin.getId();
        if (!(this.manager.isOSGiRuntime() || id.startsWith("org.eclipse.swt") || id.equals("org.eclipse.core.boot") || id.equals("org.apache.xerces"))) {
            set.add("org.eclipse.core.boot");
            set.add("org.eclipse.core.runtime");
        }
        try {
            IBuildEntry entry;
            IBuild build = ClasspathUtilCore.getBuild(plugin.getPluginModel());
            IBuildEntry iBuildEntry = entry = build == null ? null : build.getEntry("jars.extra.classpath");
            if (entry != null) {
                String[] tokens = entry.getTokens();
                int i2 = 0;
                while (i2 < tokens.length) {
                    Path path = new Path(tokens[i2]);
                    String device = path.getDevice();
                    if (device == null) {
                        if (path.segmentCount() > 1 && path.segment(0).equals("..")) {
                            set.add(path.segment(1));
                        }
                    } else if (device.equals("platform:") && path.segmentCount() > 1 && path.segment(0).equals("plugin")) {
                        set.add(path.segment(1));
                    }
                    ++i2;
                }
            }
        }
        catch (CoreException coreException) {}
        return set;
    }

    private void addDependency(String id, HashSet set) {
        if (id == null || !set.add(id)) {
            return;
        }
        ModelEntry entry = this.manager.findEntry(id);
        if (entry != null) {
            IPluginBase plugin = entry.getActiveModel().getPluginBase();
            IPluginImport[] imports = plugin.getImports();
            int i = 0;
            while (i < imports.length) {
                if (imports[i].isReexported()) {
                    this.addDependency(imports[i].getId(), set);
                }
                ++i;
            }
        }
    }

    private void addParentPlugin(String id, HashSet set) {
        if (id == null || !set.add(id)) {
            return;
        }
        ModelEntry entry = this.manager.findEntry(id);
        if (entry != null) {
            IPluginBase plugin = entry.getActiveModel().getPluginBase();
            IPluginImport[] imports = plugin.getImports();
            int i = 0;
            while (i < imports.length) {
                this.addDependency(imports[i].getId(), set);
                ++i;
            }
        }
    }
}

