/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.subscriber;

import java.util.ArrayList;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSFile;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ICVSRunnable;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.Update;
import org.eclipse.team.internal.ccvs.core.connection.CVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.connection.CVSServerException;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFile;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTree;
import org.eclipse.team.internal.ccvs.core.resources.RemoteFolderTreeBuilder;
import org.eclipse.team.internal.ccvs.core.syncinfo.FolderSyncInfo;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.subscriber.CVSSubscriberOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class RefreshDirtyStateOperation
extends CVSSubscriberOperation {
    protected RefreshDirtyStateOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected void run(SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        final SyncInfoFilter.ContentComparisonSyncInfoFilter comparator = new SyncInfoFilter.ContentComparisonSyncInfoFilter(false);
        final SyncInfo[] infos = set.getSyncInfos();
        if (infos.length == 0) {
            return;
        }
        monitor.beginTask(null, 200);
        IProject project = infos[0].getLocal().getProject();
        ICVSFolder folder = CVSWorkspaceRoot.getCVSFolderFor((IContainer)project);
        this.ensureBaseContentsCached(folder, infos, Policy.subMonitorFor(monitor, 100));
        folder.run(new ICVSRunnable(){

            public void run(IProgressMonitor monitor) throws CVSException {
                monitor.beginTask(null, infos.length * 100);
                int i = 0;
                while (i < infos.length) {
                    SyncInfo info = infos[i];
                    IResource resource = info.getLocal();
                    if (resource.getType() == 1 && comparator.compareContents((IFile)resource, info.getBase(), Policy.subMonitorFor(monitor, 100))) {
                        ICVSFile cvsFile = CVSWorkspaceRoot.getCVSFileFor((IFile)((IFile)resource));
                        cvsFile.checkedIn(null, false);
                    }
                    ++i;
                }
                monitor.done();
            }
        }, Policy.subMonitorFor(monitor, 100));
        monitor.done();
    }

    private void ensureBaseContentsCached(ICVSFolder project, SyncInfo[] infos, IProgressMonitor monitor) throws CVSException {
        ICVSRepositoryLocation location = this.getRemoteLocation(project);
        if (location == null) {
            return;
        }
        monitor.beginTask(null, 100);
        SyncInfo[] needContents = this.getBaseFilesWithUncachedContents(infos, Policy.subMonitorFor(monitor, 10));
        if (needContents.length == 0) {
            return;
        }
        RemoteFolderTree tree = RemoteFolderTreeBuilder.buildBaseTree((CVSRepositoryLocation)((CVSRepositoryLocation)location), (ICVSFolder)project, null, (IProgressMonitor)Policy.subMonitorFor(monitor, 20));
        ICVSFile[] files = this.getFilesToUpdate(tree, infos);
        this.replaceContents(location, (ICVSFolder)tree, files, Policy.subMonitorFor(monitor, 70));
        monitor.done();
    }

    private ICVSFile[] getFilesToUpdate(RemoteFolderTree tree, SyncInfo[] infos) throws CVSException {
        ArrayList<ICVSFile> newFiles = new ArrayList<ICVSFile>();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            ICVSFile file = tree.getFile(info.getLocal().getProjectRelativePath().toString());
            newFiles.add(file);
            ++i;
        }
        return newFiles.toArray(new ICVSFile[newFiles.size()]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void replaceContents(ICVSRepositoryLocation location, ICVSFolder project, ICVSFile[] files, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(null, 100);
        Session session = new Session(location, project, false);
        try {
            session.open(Policy.subMonitorFor(monitor, 10));
            IStatus execute = Command.UPDATE.execute(session, Command.NO_GLOBAL_OPTIONS, new Command.LocalOption[]{Update.IGNORE_LOCAL_CHANGES}, (ICVSResource[])files, null, Policy.subMonitorFor(monitor, 90));
            if (execute.getCode() == -10) {
                throw new CVSServerException(execute);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            session.close();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        session.close();
    }

    private SyncInfo[] getBaseFilesWithUncachedContents(SyncInfo[] infos, IProgressMonitor monitor) {
        ArrayList<SyncInfo> files = new ArrayList<SyncInfo>();
        int i = 0;
        while (i < infos.length) {
            RemoteFile remote;
            SyncInfo info = infos[i];
            IResourceVariant base = info.getBase();
            if (base instanceof RemoteFile && !(remote = (RemoteFile)base).isContentsCached()) {
                files.add(info);
            }
            ++i;
        }
        return files.toArray(new SyncInfo[files.size()]);
    }

    private ICVSRepositoryLocation getRemoteLocation(ICVSFolder project) throws CVSException {
        FolderSyncInfo info = project.getFolderSyncInfo();
        if (info == null) {
            return null;
        }
        return KnownRepositories.getInstance().getRepository(info.getRoot());
    }

    protected String getErrorTitle() {
        return CVSUIMessages.RefreshDirtyStateOperation_0;
    }

    protected String getJobName() {
        return CVSUIMessages.RefreshDirtyStateOperation_1;
    }
}

