/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.repo;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSTeamProvider;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.actions.CVSAction;
import org.eclipse.team.internal.ccvs.ui.model.RepositoryLocationSchedulingRule;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoriesView;
import org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot;
import org.eclipse.team.internal.ui.dialogs.DetailsDialogWithProjects;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.progress.IProgressService;

public class RemoveRootAction
extends SelectionListenerAction {
    private IStructuredSelection selection;
    Shell shell;
    private RepositoriesView view;
    static /* synthetic */ Class class$0;

    public RemoveRootAction(Shell shell, RepositoriesView view) {
        super(CVSUIMessages.RemoteRootAction_label);
        this.view = view;
        this.shell = shell;
    }

    protected ICVSRepositoryLocation[] getSelectedRemoteRoots() {
        ArrayList<ICVSRepositoryLocation> resources = null;
        if (this.selection != null && !this.selection.isEmpty()) {
            resources = new ArrayList<ICVSRepositoryLocation>();
            Iterator elements = this.selection.iterator();
            while (elements.hasNext()) {
                Object next;
                Object e = elements.next();
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.internal.ccvs.ui.repo.RepositoryRoot");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((next = CVSAction.getAdapter(e, (Class)clazz)) instanceof RepositoryRoot)) continue;
                resources.add(((RepositoryRoot)((Object)next)).getRoot());
            }
        }
        if (resources != null && !resources.isEmpty()) {
            ICVSRepositoryLocation[] result = new ICVSRepositoryLocation[resources.size()];
            resources.toArray(result);
            return result;
        }
        return new ICVSRepositoryLocation[0];
    }

    public void run() {
        ICVSRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        if (roots.length == 0) {
            return;
        }
        int i = 0;
        while (i < roots.length) {
            block10: {
                final ICVSRepositoryLocation root = roots[i];
                try {
                    IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                    final ArrayList<IProject> shared = new ArrayList<IProject>();
                    int j = 0;
                    while (j < projects.length) {
                        CVSTeamProvider cvsProvider;
                        RepositoryProvider teamProvider = RepositoryProvider.getProvider((IProject)projects[j], (String)CVSProviderPlugin.getTypeId());
                        if (teamProvider != null && (cvsProvider = (CVSTeamProvider)teamProvider).getCVSWorkspaceRoot().getRemoteLocation().equals(roots[i])) {
                            shared.add(projects[j]);
                        }
                        ++j;
                    }
                    if (!shared.isEmpty()) {
                        final String location = roots[i].getLocation(true);
                        this.shell.getDisplay().syncExec(new Runnable(){

                            public void run() {
                                DetailsDialogWithProjects dialog = new DetailsDialogWithProjects(RemoveRootAction.this.shell, CVSUIMessages.RemoteRootAction_Unable_to_Discard_Location_1, NLS.bind((String)CVSUIMessages.RemoteRootAction_Projects_in_the_local_workspace_are_shared_with__2, (Object[])new String[]{location}), CVSUIMessages.RemoteRootAction_The_projects_that_are_shared_with_the_above_repository_are__4, shared.toArray(new IProject[shared.size()]), false, "dialog_error_image");
                                dialog.open();
                            }
                        });
                        break block10;
                    }
                    IProgressService manager = PlatformUI.getWorkbench().getProgressService();
                    try {
                        manager.busyCursorWhile(new IRunnableWithProgress(){

                            /*
                             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                             * Enabled aggressive block sorting
                             * Enabled unnecessary exception pruning
                             * Enabled aggressive exception aggregation
                             */
                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                RepositoryLocationSchedulingRule rule = new RepositoryLocationSchedulingRule(root);
                                try {
                                    Platform.getJobManager().beginRule((ISchedulingRule)rule, monitor);
                                    RemoveRootAction.this.view.getContentProvider().cancelJobs(root);
                                    KnownRepositories.getInstance().disposeRepository(root);
                                }
                                catch (Throwable throwable) {
                                    Object var3_4 = null;
                                    Platform.getJobManager().endRule((ISchedulingRule)rule);
                                    throw throwable;
                                }
                                {
                                    Object var3_5 = null;
                                }
                                Platform.getJobManager().endRule((ISchedulingRule)rule);
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        throw CVSException.wrapException((Exception)e);
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
                catch (CVSException e) {
                    CVSUIPlugin.openError(this.view.getShell(), null, null, e, 15);
                }
            }
            ++i;
        }
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        ICVSRepositoryLocation[] roots = this.getSelectedRemoteRoots();
        boolean b = roots.length > 0;
        this.setEnabled(b);
        return b;
    }
}

