/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.cm;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.service.cm.ConfigurationPermission;

final class ConfigurationPermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -6917638867081695839L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof ConfigurationPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        ConfigurationPermission sp = (ConfigurationPermission)permission;
        String name = sp.getName();
        ConfigurationPermission existing = (ConfigurationPermission)this.permissions.get(name);
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            if (oldMask != (newMask = sp.getMask())) {
                this.permissions.put(name, new ConfigurationPermission(name, oldMask | newMask));
            }
        } else {
            this.permissions.put(name, permission);
        }
        if (!this.all_allowed && name.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int last;
        ConfigurationPermission x;
        if (!(permission instanceof ConfigurationPermission)) {
            return false;
        }
        ConfigurationPermission sp = (ConfigurationPermission)permission;
        int desired = sp.getMask();
        int effective = 0;
        if (this.all_allowed && (x = (ConfigurationPermission)this.permissions.get("*")) != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        String name = sp.getName();
        x = (ConfigurationPermission)this.permissions.get(name);
        if (x != null && ((effective |= x.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            x = (ConfigurationPermission)this.permissions.get(name = String.valueOf(name.substring(0, last + 1)) + "*");
            if (x != null && ((effective |= x.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

