/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.contentmergeviewer;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.IEncodedStreamContentAccessor;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.contentmergeviewer.ContentMergeViewer;
import org.eclipse.compare.contentmergeviewer.IDocumentRange;
import org.eclipse.compare.contentmergeviewer.IMergeViewerContentProvider;
import org.eclipse.compare.contentmergeviewer.ITokenComparator;
import org.eclipse.compare.internal.BufferedCanvas;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.CompareNavigator;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.DocumentManager;
import org.eclipse.compare.internal.INavigatable;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.compare.internal.MergeViewerAction;
import org.eclipse.compare.internal.MergeViewerContentProvider;
import org.eclipse.compare.internal.TokenComparator;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IKeyBindingService;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.progress.IProgressService;

public class TextMergeViewer
extends ContentMergeViewer {
    private static final boolean DEBUG = false;
    private static final boolean FIX_47640 = true;
    private static final String[] GLOBAL_ACTIONS = new String[]{ActionFactory.UNDO.getId(), ActionFactory.REDO.getId(), ActionFactory.CUT.getId(), ActionFactory.COPY.getId(), ActionFactory.PASTE.getId(), ActionFactory.DELETE.getId(), ActionFactory.SELECT_ALL.getId(), ActionFactory.SAVE.getId()};
    private static final String[] TEXT_ACTIONS = new String[]{"undo", "redo", "cut", "copy", "paste", "delete", "selectAll", "save"};
    private static final String BUNDLE_NAME = "org.eclipse.compare.contentmergeviewer.TextMergeViewerResources";
    private static final String INCOMING_COLOR = "INCOMING_COLOR";
    private static final String OUTGOING_COLOR = "OUTGOING_COLOR";
    private static final String CONFLICTING_COLOR = "CONFLICTING_COLOR";
    private static final String RESOLVED_COLOR = "RESOLVED_COLOR";
    private static final int MARGIN_WIDTH = 6;
    private static final int CENTER_WIDTH = 34;
    private static final int BIRDS_EYE_VIEW_WIDTH = 12;
    private static final int BIRDS_EYE_VIEW_INSET = 2;
    private static final int RESOLVE_SIZE = 5;
    private static final boolean APPEND_CONFLICT = true;
    private static final int LW = 1;
    private static final boolean USE_MERGING_TOKEN_DIFF = false;
    private boolean fLeftIsLocal;
    private boolean fShowCurrentOnly = false;
    private boolean fShowCurrentOnly2 = false;
    private int fMarginWidth = 6;
    private int fTopInset;
    private RGB fBackground;
    private RGB fForeground;
    private boolean fPollSystemForeground = true;
    private boolean fPollSystemBackground = true;
    private RGB SELECTED_INCOMING;
    private RGB INCOMING;
    private RGB INCOMING_FILL;
    private RGB SELECTED_CONFLICT;
    private RGB CONFLICT;
    private RGB CONFLICT_FILL;
    private RGB SELECTED_OUTGOING;
    private RGB OUTGOING;
    private RGB OUTGOING_FILL;
    private RGB RESOLVED;
    private boolean fEndOfDocReached;
    private IDocumentListener fDocumentListener;
    private IPreferenceStore fPreferenceStore;
    private IPropertyChangeListener fPreferenceChangeListener;
    private ArrayList fAllDiffs;
    private ArrayList fChangeDiffs;
    private Diff fCurrentDiff;
    private HashMap fNewAncestorRanges = new HashMap();
    private HashMap fNewLeftRanges = new HashMap();
    private HashMap fNewRightRanges = new HashMap();
    private MergeSourceViewer fAncestor;
    private MergeSourceViewer fLeft;
    private MergeSourceViewer fRight;
    private int fLeftLineCount;
    private int fRightLineCount;
    private String fLeftEncoding;
    private String fRightEncoding;
    private boolean fInScrolling;
    private int[] fPts = new int[8];
    private boolean fIgnoreAncestor = false;
    private ActionContributionItem fIgnoreAncestorItem;
    private boolean fHighlightRanges;
    private boolean fShowPseudoConflicts = false;
    private boolean fUseSplines = true;
    private boolean fUseSingleLine = true;
    private boolean fUseResolveUI = true;
    private String fSymbolicFontName = this.getClass().getName();
    private ActionContributionItem fNextItem;
    private ActionContributionItem fPreviousItem;
    private ActionContributionItem fCopyDiffLeftToRightItem;
    private ActionContributionItem fCopyDiffRightToLeftItem;
    private IKeyBindingService fKeyBindingService;
    private boolean fSynchronizedScrolling = true;
    private boolean fShowMoreInfo = false;
    private MergeSourceViewer fFocusPart;
    private boolean fSubDoc = true;
    private IPositionUpdater fPositionUpdater;
    private boolean fIsMotif;
    private boolean fIsCarbon;
    private boolean fHasErrors;
    private BufferedCanvas fAncestorCanvas;
    private BufferedCanvas fLeftCanvas;
    private BufferedCanvas fRightCanvas;
    private Canvas fScrollCanvas;
    private ScrollBar fVScrollBar;
    private Canvas fBirdsEyeCanvas;
    private Canvas fSummaryHeader;
    private HeaderPainter fHeaderPainter;
    private Map fColors;
    private Cursor fBirdsEyeCursor;
    private double[] fBasicCenterCurve;
    private Button fCenterButton;
    private Diff fButtonDiff;

    public TextMergeViewer(Composite parent, CompareConfiguration configuration) {
        this(parent, 0, configuration);
    }

    public TextMergeViewer(Composite parent, int style, CompareConfiguration configuration) {
        super(style, ResourceBundle.getBundle(BUNDLE_NAME), configuration);
        String platform = SWT.getPlatform();
        this.fIsMotif = "motif".equals(platform);
        this.fIsCarbon = "carbon".equals(platform);
        if (this.fIsMotif) {
            this.fMarginWidth = 0;
        }
        Display display = parent.getDisplay();
        this.fPreferenceChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TextMergeViewer.this.propertyChange(event);
            }
        };
        this.fPreferenceStore = configuration.getPreferenceStore();
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPreferenceChangeListener);
            this.checkForColorUpdate(display);
            this.fLeftIsLocal = Utilities.getBoolean(configuration, "LEFT_IS_LOCAL", false);
            this.fSynchronizedScrolling = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            this.fShowMoreInfo = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
        }
        this.fDocumentListener = new IDocumentListener(){

            public void documentAboutToBeChanged(DocumentEvent e) {
            }

            public void documentChanged(DocumentEvent e) {
                TextMergeViewer.this.documentChanged(e);
            }
        };
        this.buildControl(parent);
        INavigatable nav = new INavigatable(){

            public boolean gotoDifference(boolean next) {
                return TextMergeViewer.this.navigate(next, false, false);
            }
        };
        this.fComposite.setData("org.eclipse.compare.internal.Navigator", (Object)nav);
        this.fBirdsEyeCursor = new Cursor((Device)parent.getDisplay(), 21);
        JFaceResources.getFontRegistry().addListener(this.fPreferenceChangeListener);
        JFaceResources.getColorRegistry().addListener(this.fPreferenceChangeListener);
        this.updateFont();
    }

    private void updateFont() {
        Font f = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (f != null) {
            if (this.fAncestor != null) {
                this.fAncestor.setFont(f);
            }
            if (this.fLeft != null) {
                this.fLeft.setFont(f);
            }
            if (this.fRight != null) {
                this.fRight.setFont(f);
            }
        }
    }

    private void checkForColorUpdate(Display display) {
        if (this.fPollSystemForeground) {
            RGB fg = display.getSystemColor(24).getRGB();
            if (this.fForeground == null || !fg.equals((Object)this.fForeground)) {
                this.fForeground = fg;
                this.updateColors(display);
            }
        }
        if (this.fPollSystemBackground) {
            RGB bg = display.getSystemColor(25).getRGB();
            if (this.fBackground == null || !bg.equals((Object)this.fBackground)) {
                this.fBackground = bg;
                this.updateColors(display);
            }
        }
    }

    public void setBackgroundColor(RGB background) {
        this.fPollSystemBackground = background == null;
        this.fBackground = background;
        this.updateColors(null);
    }

    private RGB getBackground(Display display) {
        if (this.fBackground != null) {
            return this.fBackground;
        }
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        return display.getSystemColor(25).getRGB();
    }

    public void setForegroundColor(RGB foreground) {
        this.fPollSystemForeground = foreground == null;
        this.fForeground = foreground;
        this.updateColors(null);
    }

    private void updateColors(Display display) {
        if (display == null) {
            display = this.fComposite.getDisplay();
        }
        Color color = null;
        if (this.fBackground != null) {
            color = this.getColor(display, this.fBackground);
        }
        if (this.fAncestor != null) {
            this.fAncestor.setBackgroundColor(color);
        }
        if (this.fLeft != null) {
            this.fLeft.setBackgroundColor(color);
        }
        if (this.fRight != null) {
            this.fRight.setBackgroundColor(color);
        }
        ColorRegistry registry = JFaceResources.getColorRegistry();
        RGB bg = this.getBackground(display);
        this.SELECTED_INCOMING = registry.getRGB(INCOMING_COLOR);
        if (this.SELECTED_INCOMING == null) {
            this.SELECTED_INCOMING = new RGB(0, 0, 255);
        }
        this.INCOMING = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.6);
        this.INCOMING_FILL = TextMergeViewer.interpolate(this.SELECTED_INCOMING, bg, 0.97);
        this.SELECTED_OUTGOING = registry.getRGB(OUTGOING_COLOR);
        if (this.SELECTED_OUTGOING == null) {
            this.SELECTED_OUTGOING = new RGB(0, 0, 0);
        }
        this.OUTGOING = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.6);
        this.OUTGOING_FILL = TextMergeViewer.interpolate(this.SELECTED_OUTGOING, bg, 0.97);
        this.SELECTED_CONFLICT = registry.getRGB(CONFLICTING_COLOR);
        if (this.SELECTED_CONFLICT == null) {
            this.SELECTED_CONFLICT = new RGB(255, 0, 0);
        }
        this.CONFLICT = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.6);
        this.CONFLICT_FILL = TextMergeViewer.interpolate(this.SELECTED_CONFLICT, bg, 0.97);
        this.RESOLVED = registry.getRGB(RESOLVED_COLOR);
        if (this.RESOLVED == null) {
            this.RESOLVED = new RGB(0, 255, 0);
        }
        this.refreshBirdsEyeView();
        this.invalidateLines();
        this.updateAllDiffBackgrounds(display);
    }

    public void invalidateTextPresentation() {
        if (this.fAncestor != null) {
            this.fAncestor.invalidateTextPresentation();
        }
        if (this.fLeft != null) {
            this.fLeft.invalidateTextPresentation();
        }
        if (this.fRight != null) {
            this.fRight.invalidateTextPresentation();
        }
    }

    protected void configureTextViewer(TextViewer textViewer) {
    }

    protected ITokenComparator createTokenComparator(String line) {
        return new TokenComparator(line);
    }

    protected IDocumentPartitioner getDocumentPartitioner() {
        return null;
    }

    protected void handleDispose(DisposeEvent event) {
        if (this.fKeyBindingService != null) {
            IAction a;
            if (this.fNextItem != null && (a = this.fNextItem.getAction()) != null) {
                this.fKeyBindingService.unregisterAction(a);
            }
            if (this.fPreviousItem != null && (a = this.fPreviousItem.getAction()) != null) {
                this.fKeyBindingService.unregisterAction(a);
            }
            if (this.fCopyDiffLeftToRightItem != null && (a = this.fCopyDiffLeftToRightItem.getAction()) != null) {
                this.fKeyBindingService.unregisterAction(a);
            }
            if (this.fCopyDiffRightToLeftItem != null && (a = this.fCopyDiffRightToLeftItem.getAction()) != null) {
                this.fKeyBindingService.unregisterAction(a);
            }
            this.fKeyBindingService = null;
        }
        Object input = this.getInput();
        DocumentManager.remove(this.getDocument2('A', input));
        DocumentManager.remove(this.getDocument2('L', input));
        DocumentManager.remove(this.getDocument2('R', input));
        if (this.fPreferenceChangeListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fPreferenceChangeListener);
            JFaceResources.getColorRegistry().removeListener(this.fPreferenceChangeListener);
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPreferenceChangeListener);
            }
            this.fPreferenceChangeListener = null;
        }
        this.fLeftCanvas = null;
        this.fRightCanvas = null;
        this.fVScrollBar = null;
        this.fBirdsEyeCanvas = null;
        this.fSummaryHeader = null;
        this.unsetDocument(this.fAncestor);
        this.unsetDocument(this.fLeft);
        this.unsetDocument(this.fRight);
        if (this.fColors != null) {
            Iterator i = this.fColors.values().iterator();
            while (i.hasNext()) {
                Color color = (Color)i.next();
                if (color.isDisposed()) continue;
                color.dispose();
            }
            this.fColors = null;
        }
        if (this.fBirdsEyeCursor != null) {
            this.fBirdsEyeCursor.dispose();
            this.fBirdsEyeCursor = null;
        }
        super.handleDispose(event);
    }

    protected void createControls(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.compare.text_merge_view_context");
        if (this.fMarginWidth > 0) {
            this.fAncestorCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fAncestor, TextMergeViewer.this.fAncestorCanvas, false);
                }
            };
            this.fAncestorCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fAncestorCanvas, TextMergeViewer.this.fAncestor, e.y), false);
                }
            });
        }
        this.fAncestor = this.createPart(composite);
        this.fAncestor.setEditable(false);
        this.fSummaryHeader = new Canvas(composite, 0);
        this.fHeaderPainter = new HeaderPainter();
        this.fSummaryHeader.addPaintListener((PaintListener)this.fHeaderPainter);
        this.updateResolveStatus();
        if (this.fMarginWidth > 0) {
            this.fLeftCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fLeft, TextMergeViewer.this.fLeftCanvas, false);
                }
            };
            this.fLeftCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fLeftCanvas, TextMergeViewer.this.fLeft, e.y), false);
                }
            });
        }
        this.fLeft = this.createPart(composite);
        this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fLeft.addAction("save", this.fLeftSaveAction);
        this.fRight = this.createPart(composite);
        this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.addAction("save", this.fRightSaveAction);
        this.hsynchViewport((TextViewer)this.fAncestor, (TextViewer)this.fLeft, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fLeft, (TextViewer)this.fAncestor, (TextViewer)this.fRight);
        this.hsynchViewport((TextViewer)this.fRight, (TextViewer)this.fAncestor, (TextViewer)this.fLeft);
        if (this.fMarginWidth > 0) {
            this.fRightCanvas = new BufferedCanvas(composite, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintSides(gc, TextMergeViewer.this.fRight, TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fSynchronizedScrolling);
                }
            };
            this.fRightCanvas.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handleMouseInSides(TextMergeViewer.this.fRightCanvas, TextMergeViewer.this.fRight, e.y), false);
                }
            });
        }
        this.fScrollCanvas = new Canvas(composite, 512);
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        this.fTopInset = trim.y;
        this.fVScrollBar = this.fScrollCanvas.getVerticalBar();
        this.fVScrollBar.setIncrement(1);
        this.fVScrollBar.setVisible(true);
        this.fVScrollBar.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int vpos = ((ScrollBar)e.widget).getSelection();
                TextMergeViewer.this.scrollVertical(vpos, vpos, vpos, null);
                TextMergeViewer.this.workaround65205();
            }
        });
        this.fBirdsEyeCanvas = new BufferedCanvas(composite, 0){

            public void doPaint(GC gc) {
                TextMergeViewer.this.paintBirdsEyeView(this, gc);
            }
        };
        this.fBirdsEyeCanvas.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.setCurrentDiff2(TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y), true);
            }
        });
        this.fBirdsEyeCanvas.addMouseMoveListener(new MouseMoveListener(){
            private Cursor fLastCursor;

            public void mouseMove(MouseEvent e) {
                Cursor cursor = null;
                Diff diff = TextMergeViewer.this.handlemouseInBirdsEyeView(TextMergeViewer.this.fBirdsEyeCanvas, e.y);
                if (diff != null && diff.fDirection != 0) {
                    cursor = TextMergeViewer.this.fBirdsEyeCursor;
                }
                if (this.fLastCursor != cursor) {
                    TextMergeViewer.this.fBirdsEyeCanvas.setCursor(cursor);
                    this.fLastCursor = cursor;
                }
            }
        });
    }

    private void hsynchViewport(TextViewer tv1, TextViewer tv2, TextViewer tv3) {
        StyledText st1 = tv1.getTextWidget();
        final StyledText st2 = tv2.getTextWidget();
        final StyledText st3 = tv3.getTextWidget();
        final ScrollBar sb1 = st1.getHorizontalBar();
        sb1.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TextMergeViewer.this.fSynchronizedScrolling) {
                    int max = sb1.getMaximum() - sb1.getThumb();
                    double v = 0.0;
                    if (max > 0) {
                        v = (float)sb1.getSelection() / (float)max;
                    }
                    if (st2.isVisible()) {
                        ScrollBar sb2 = st2.getHorizontalBar();
                        st2.setHorizontalPixel((int)((double)(sb2.getMaximum() - sb2.getThumb()) * v));
                    }
                    if (st3.isVisible()) {
                        ScrollBar sb3 = st3.getHorizontalBar();
                        st3.setHorizontalPixel((int)((double)(sb3.getMaximum() - sb3.getThumb()) * v));
                    }
                    TextMergeViewer.this.workaround65205();
                }
            }
        });
    }

    private void workaround65205() {
        if (this.fIsCarbon && this.fComposite != null && !this.fComposite.isDisposed()) {
            this.fComposite.getDisplay().update();
        }
    }

    private void setCurrentDiff2(Diff diff, boolean reveal) {
        if (diff != null && diff.fDirection != 0) {
            this.setCurrentDiff(diff, reveal);
        }
    }

    private Diff handleMouseInSides(Canvas canvas, MergeSourceViewer tp, int my) {
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(tp), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                if (my < y || my >= y + h) continue;
                return diff;
            }
        }
        return null;
    }

    private Diff getDiffUnderMouse(Canvas canvas, int mx, int my, Rectangle r) {
        if (!this.fSynchronizedScrolling) {
            return null;
        }
        int lineHeight = this.fLeft.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int w = size.x;
        if (!this.fHighlightRanges) {
            return null;
        }
        if (this.fChangeDiffs != null) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.fRightPos, region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                if (my < cy || my >= cy + 5 || mx < cx || mx >= cx + 5) continue;
                if (r != null) {
                    int SIZE = this.fIsCarbon ? 30 : 20;
                    r.x = cx + (5 - SIZE) / 2;
                    r.y = cy + (5 - SIZE) / 2;
                    r.width = SIZE;
                    r.height = SIZE;
                }
                return diff;
            }
        }
        return null;
    }

    private Diff handlemouseInBirdsEyeView(Canvas canvas, int my) {
        int virtualHeight;
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return null;
        }
        int y = 0;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                int h;
                Diff diff = (Diff)e.next();
                int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight(this.fShowAncestor) : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if (my >= yy && my < yy + hh) {
                        return diff;
                    }
                }
                y += h;
                ++i;
            }
        }
        return null;
    }

    private void paintBirdsEyeView(Canvas canvas, GC gc) {
        int virtualHeight;
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Point size = canvas.getSize();
        int n = virtualHeight = this.fSynchronizedScrolling ? this.getVirtualHeight() : this.getRightHeight();
        if (virtualHeight < this.getViewportHeight()) {
            return;
        }
        Display display = canvas.getDisplay();
        int y = 0;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                int h;
                Diff diff = (Diff)e.next();
                int n2 = h = this.fSynchronizedScrolling ? diff.getMaxDiffHeight(this.fShowAncestor) : diff.getRightHeight();
                if (this.useChange(diff.fDirection) && !diff.fIsWhitespace) {
                    Color c;
                    int yy = y * size.y / virtualHeight;
                    int hh = h * size.y / virtualHeight;
                    if (hh < 3) {
                        hh = 3;
                    }
                    if ((c = this.getColor(display, this.getFillColor(diff))) != null) {
                        gc.setBackground(c);
                        gc.fillRectangle(2, yy, size.x - 4, hh);
                    }
                    if ((c = this.getColor(display, this.getStrokeColor(diff))) != null) {
                        gc.setForeground(c);
                        r.x = 2;
                        r.y = yy;
                        r.width = size.x - 4 - 1;
                        r.height = hh;
                        if (diff == this.fCurrentDiff || this.fCurrentDiff != null && diff == this.fCurrentDiff.fParent) {
                            gc.setLineWidth(2);
                            ++r.x;
                            ++r.y;
                            --r.width;
                            --r.height;
                        } else {
                            gc.setLineWidth(1);
                        }
                        gc.drawRectangle(r);
                    }
                }
                y += h;
                ++i;
            }
        }
    }

    private void refreshBirdsEyeView() {
        if (this.fBirdsEyeCanvas != null) {
            this.fBirdsEyeCanvas.redraw();
        }
    }

    boolean internalSetFocus() {
        StyledText st;
        if (this.fFocusPart == null) {
            if (this.fLeft != null && this.fLeft.getEnabled()) {
                this.fFocusPart = this.fLeft;
            } else if (this.fRight != null && this.fRight.getEnabled()) {
                this.fFocusPart = this.fRight;
            } else if (this.fAncestor != null && this.fAncestor.getEnabled()) {
                this.fFocusPart = this.fAncestor;
            }
        }
        if (this.fFocusPart != null && (st = this.fFocusPart.getTextWidget()) != null) {
            return st.setFocus();
        }
        return false;
    }

    Control createCenter(Composite parent) {
        if (this.fSynchronizedScrolling) {
            BufferedCanvas canvas = new BufferedCanvas(parent, 0){

                public void doPaint(GC gc) {
                    TextMergeViewer.this.paintCenter(this, gc);
                }
            };
            if (this.fUseResolveUI) {
                new HoverResizer(canvas, 1);
                this.fCenterButton = new Button((Composite)canvas, this.fIsCarbon ? 0x800000 : 8);
                if (this.fNormalCursor == null) {
                    this.fNormalCursor = new Cursor((Device)canvas.getDisplay(), 0);
                }
                this.fCenterButton.setCursor(this.fNormalCursor);
                this.fCenterButton.setText("<");
                this.fCenterButton.pack();
                this.fCenterButton.setVisible(false);
                this.fCenterButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        TextMergeViewer.this.fCenterButton.setVisible(false);
                        if (TextMergeViewer.this.fButtonDiff != null) {
                            TextMergeViewer.this.setCurrentDiff(TextMergeViewer.this.fButtonDiff, false);
                            TextMergeViewer.this.copy(TextMergeViewer.this.fCurrentDiff, false, ((TextMergeViewer)TextMergeViewer.this).fCurrentDiff.fDirection == 1);
                        }
                    }
                });
            } else {
                new ContentMergeViewer.Resizer((Control)canvas, 1);
            }
            return canvas;
        }
        return super.createCenter(parent);
    }

    private boolean handleMouseMoveOverCenter(Canvas canvas, int x, int y) {
        Rectangle r = new Rectangle(0, 0, 0, 0);
        Diff diff = this.getDiffUnderMouse(canvas, x, y, r);
        if (diff != null && !diff.isUnresolvedIncomingOrConflicting()) {
            diff = null;
        }
        if (diff != this.fButtonDiff) {
            if (diff != null) {
                if (this.fLeft.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText("<");
                    String tt = this.fCopyDiffRightToLeftItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else if (this.fRight.isEditable()) {
                    this.fButtonDiff = diff;
                    this.fCenterButton.setText(">");
                    String tt = this.fCopyDiffLeftToRightItem.getAction().getToolTipText();
                    this.fCenterButton.setToolTipText(tt);
                    this.fCenterButton.setBounds(r);
                    this.fCenterButton.setVisible(true);
                } else {
                    this.fButtonDiff = null;
                }
            } else {
                this.fCenterButton.setVisible(false);
                this.fButtonDiff = null;
            }
        }
        return this.fButtonDiff != null;
    }

    int getCenterWidth() {
        if (this.fSynchronizedScrolling) {
            return 34;
        }
        return super.getCenterWidth();
    }

    private MergeSourceViewer createPart(Composite parent) {
        final MergeSourceViewer part = new MergeSourceViewer(parent, this.getResourceBundle());
        StyledText te = part.getTextWidget();
        if (!this.fConfirmSave) {
            part.hideSaveAction();
        }
        te.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TextMergeViewer.this.paint(e, part);
            }
        });
        te.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                TextMergeViewer.this.handleSelectionChanged(part);
            }
        });
        te.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent fe) {
                TextMergeViewer.this.fFocusPart = part;
                TextMergeViewer.this.connectGlobalActions(TextMergeViewer.this.fFocusPart);
            }

            public void focusLost(FocusEvent fe) {
                TextMergeViewer.this.connectGlobalActions(null);
            }
        });
        part.addViewportListener(new IViewportListener(){

            public void viewportChanged(int verticalPosition) {
                TextMergeViewer.this.syncViewport(part);
            }
        });
        Font font = JFaceResources.getFont((String)this.fSymbolicFontName);
        if (font != null) {
            te.setFont(font);
        }
        if (this.fBackground != null) {
            te.setBackground(this.getColor(parent.getDisplay(), this.fBackground));
        }
        this.configureTextViewer((TextViewer)part);
        return part;
    }

    private void connectGlobalActions(MergeSourceViewer part) {
        IActionBars actionBars = Utilities.findActionBars((Control)this.fComposite);
        if (actionBars != null) {
            int i = 0;
            while (i < GLOBAL_ACTIONS.length) {
                MergeViewerAction action = null;
                if (part != null && (action = part.getAction(TEXT_ACTIONS[i])) == null && TEXT_ACTIONS[i].equals("save")) {
                    action = part == this.fLeft ? this.fLeftSaveAction : this.fRightSaveAction;
                }
                actionBars.setGlobalActionHandler(GLOBAL_ACTIONS[i], (IAction)action);
                ++i;
            }
            actionBars.updateActionBars();
        }
    }

    ITypedElement getLeg(char type, Object input) {
        if (input instanceof ICompareInput) {
            switch (type) {
                case 'A': {
                    return ((ICompareInput)input).getAncestor();
                }
                case 'L': {
                    return ((ICompareInput)input).getLeft();
                }
                case 'R': {
                    return ((ICompareInput)input).getRight();
                }
            }
        }
        return null;
    }

    IDocument getDocument(char type, Object input) {
        ITypedElement te = this.getLeg(type, input);
        if (te instanceof IDocument) {
            return (IDocument)te;
        }
        if (te instanceof IDocumentRange) {
            return ((IDocumentRange)((Object)te)).getDocument();
        }
        if (te instanceof IStreamContentAccessor) {
            return DocumentManager.get(te);
        }
        return null;
    }

    IDocument getDocument2(char type, Object input) {
        IDocument doc = this.getDocument(type, input);
        if (doc != null) {
            return doc;
        }
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return this.getDocument(type, parent);
        }
        return null;
    }

    boolean sameDoc(char type, Object newInput, Object oldInput) {
        IDocument oldDoc;
        IDocument newDoc = this.getDocument2(type, newInput);
        return newDoc == (oldDoc = this.getDocument2(type, oldInput));
    }

    protected boolean doSave(Object newInput, Object oldInput) {
        if (oldInput != null && newInput != null && this.sameDoc('A', newInput, oldInput) && this.sameDoc('L', newInput, oldInput) && this.sameDoc('R', newInput, oldInput)) {
            return false;
        }
        IDocument aDoc = this.getDocument2('A', oldInput);
        DocumentManager.remove(aDoc);
        IDocument lDoc = this.getDocument2('L', oldInput);
        DocumentManager.remove(lDoc);
        IDocument rDoc = this.getDocument2('R', oldInput);
        DocumentManager.remove(rDoc);
        return super.doSave(newInput, oldInput);
    }

    private ITypedElement getParent(char type) {
        Object input = this.getInput();
        if (input instanceof IDiffElement) {
            IDiffContainer parent = ((IDiffElement)input).getParent();
            return this.getLeg(type, parent);
        }
        return null;
    }

    protected void updateContent(Object ancestor, Object left, Object right) {
        ICompareInput ci;
        IDiffContainer parent;
        boolean emptyInput = ancestor == null && left == null && right == null;
        Object input = this.getInput();
        Position leftRange = null;
        Position rightRange = null;
        if (!emptyInput && (left == null || right == null) && input instanceof IDiffElement && (parent = ((IDiffElement)input).getParent()) instanceof ICompareInput && ((ci = (ICompareInput)((Object)parent)).getAncestor() instanceof IDocumentRange || ci.getLeft() instanceof IDocumentRange || ci.getRight() instanceof IDocumentRange)) {
            if (left instanceof IDocumentRange) {
                leftRange = ((IDocumentRange)left).getRange();
            }
            if (right instanceof IDocumentRange) {
                rightRange = ((IDocumentRange)right).getRange();
            }
            ancestor = ci.getAncestor();
            left = ci.getLeft();
            right = ci.getRight();
        }
        int n = 0;
        if (left != null) {
            ++n;
        }
        if (right != null) {
            ++n;
        }
        this.fHighlightRanges = n > 1;
        this.fCurrentDiff = null;
        this.fChangeDiffs = null;
        this.fAllDiffs = null;
        this.fEndOfDocReached = false;
        this.fHasErrors = false;
        CompareConfiguration cc = this.getCompareConfiguration();
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            mcp.setAncestorError(null);
            mcp.setLeftError(null);
            mcp.setRightError(null);
        }
        this.setDocument(this.fLeft, 'L', left);
        this.fLeftLineCount = this.fLeft.getLineCount();
        this.fLeftEncoding = TextMergeViewer.getEncoding(left);
        this.setDocument(this.fRight, 'R', right);
        this.fRightLineCount = this.fRight.getLineCount();
        this.fRightEncoding = TextMergeViewer.getEncoding(right);
        this.setDocument(this.fAncestor, 'A', ancestor);
        this.updateHeader();
        this.updateControls();
        this.updateToolItems();
        if (!this.fHasErrors) {
            this.doDiff();
        }
        this.fRight.setEditable(cc.isRightEditable() && cp.isRightEditable(input));
        this.fLeft.setEditable(cc.isLeftEditable() && cp.isLeftEditable(input));
        this.invalidateLines();
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
        if (!(this.fHasErrors || emptyInput || this.fComposite.isDisposed())) {
            Diff selectDiff = null;
            if (leftRange != null) {
                selectDiff = this.findDiff('L', leftRange);
            } else if (rightRange != null) {
                selectDiff = this.findDiff('R', rightRange);
            }
            if (selectDiff != null) {
                this.setCurrentDiff(selectDiff, true);
            } else {
                this.selectFirstDiff();
            }
        }
    }

    private Diff findDiff(char c, Position range) {
        MergeSourceViewer v;
        int start = range.getOffset();
        int end = start + range.getLength();
        if (c == 'L') {
            v = this.fLeft;
        } else if (c == 'R') {
            v = this.fRight;
        } else {
            return null;
        }
        if (this.fChangeDiffs != null) {
            Iterator iter = this.fChangeDiffs.iterator();
            while (iter.hasNext()) {
                Diff diff = (Diff)iter.next();
                if (diff.isDeleted() || diff.fDirection == 0 || !diff.overlaps(v, start, end)) continue;
                return diff;
            }
        }
        return null;
    }

    private static String getEncoding(Object o) {
        String encoding = null;
        if (o instanceof IEncodedStreamContentAccessor) {
            try {
                encoding = ((IEncodedStreamContentAccessor)o).getCharset();
            }
            catch (CoreException coreException) {}
        }
        if (encoding == null) {
            encoding = ResourcesPlugin.getEncoding();
        }
        return encoding;
    }

    private void updateDiffBackground(Diff diff) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (diff == null || diff.fIsToken) {
            return;
        }
        if (this.fShowCurrentOnly && !this.isCurrentDiff(diff)) {
            return;
        }
        Color c = this.getColor(null, this.getFillColor(diff));
        if (c == null) {
            return;
        }
        if (this.isThreeWay()) {
            this.fAncestor.setLineBackground(diff.fAncestorPos, c);
        }
        this.fLeft.setLineBackground(diff.fLeftPos, c);
        this.fRight.setLineBackground(diff.fRightPos, c);
    }

    private void updateAllDiffBackgrounds(Display display) {
        if (this.fChangeDiffs != null) {
            boolean threeWay = this.isThreeWay();
            Iterator iter = this.fChangeDiffs.iterator();
            while (iter.hasNext()) {
                Diff diff = (Diff)iter.next();
                Color c = this.getColor(display, this.getFillColor(diff));
                if (threeWay) {
                    this.fAncestor.setLineBackground(diff.fAncestorPos, c);
                }
                this.fLeft.setLineBackground(diff.fLeftPos, c);
                this.fRight.setLineBackground(diff.fRightPos, c);
            }
        }
    }

    boolean isCurrentDiff(Diff diff) {
        if (diff == null) {
            return false;
        }
        if (diff == this.fCurrentDiff) {
            return true;
        }
        return this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
    }

    private void documentChanged(DocumentEvent e) {
        IDocument doc = e.getDocument();
        if (doc == this.fLeft.getDocument()) {
            this.setLeftDirty(true);
        } else if (doc == this.fRight.getDocument()) {
            this.setRightDirty(true);
        }
        this.updateLines(doc);
    }

    protected int findInsertionPosition(char type, ICompareInput input) {
        ITypedElement other = null;
        char otherType = '\u0000';
        switch (type) {
            case 'A': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getRight();
                otherType = 'R';
                break;
            }
            case 'L': {
                other = input.getRight();
                otherType = 'R';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
                break;
            }
            case 'R': {
                other = input.getLeft();
                otherType = 'L';
                if (other != null) break;
                other = input.getAncestor();
                otherType = 'A';
            }
        }
        if (other instanceof IDocumentRange) {
            IDocumentRange dr = (IDocumentRange)((Object)other);
            Position p = dr.getRange();
            Diff diff = this.findDiff(otherType, p.offset);
            if (diff != null) {
                switch (type) {
                    case 'A': {
                        if (diff.fAncestorPos == null) break;
                        return diff.fAncestorPos.offset;
                    }
                    case 'L': {
                        if (diff.fLeftPos == null) break;
                        return diff.fLeftPos.offset;
                    }
                    case 'R': {
                        if (diff.fRightPos == null) break;
                        return diff.fRightPos.offset;
                    }
                }
            }
        }
        return 0;
    }

    private void setError(char type, String message) {
        IMergeViewerContentProvider cp = this.getMergeContentProvider();
        if (cp instanceof MergeViewerContentProvider) {
            MergeViewerContentProvider mcp = (MergeViewerContentProvider)cp;
            switch (type) {
                case 'A': {
                    mcp.setAncestorError(message);
                    break;
                }
                case 'L': {
                    mcp.setLeftError(message);
                    break;
                }
                case 'R': {
                    mcp.setRightError(message);
                }
            }
        }
        this.fHasErrors = true;
    }

    private boolean setDocument(MergeSourceViewer tp, char type, Object o) {
        IDocument oldDoc;
        if (tp == null) {
            return false;
        }
        IDocument newDoc = null;
        Position range = null;
        if (o instanceof IDocumentRange) {
            newDoc = ((IDocumentRange)o).getDocument();
            range = ((IDocumentRange)o).getRange();
        } else if (o instanceof IDocument) {
            newDoc = (IDocument)o;
        } else if (o instanceof IStreamContentAccessor) {
            newDoc = DocumentManager.get(o);
            if (newDoc == null) {
                IStreamContentAccessor sca = (IStreamContentAccessor)o;
                String s = null;
                try {
                    s = Utilities.readString(sca);
                }
                catch (CoreException ex) {
                    this.setError(type, ex.getMessage());
                }
                newDoc = new Document(s != null ? s : "");
                DocumentManager.put(o, newDoc);
                IDocumentPartitioner partitioner = this.getDocumentPartitioner();
                if (partitioner != null) {
                    newDoc.setDocumentPartitioner(partitioner);
                    partitioner.connect(newDoc);
                }
            }
        } else if (o == null) {
            ITypedElement parent = this.getParent(type);
            if (parent instanceof IDocumentRange) {
                newDoc = ((IDocumentRange)((Object)parent)).getDocument();
                newDoc.addPositionCategory("DocumentRangeCategory");
                Object input = this.getInput();
                range = this.getNewRange(type, input);
                if (range == null) {
                    int pos = 0;
                    if (input instanceof ICompareInput) {
                        pos = this.findInsertionPosition(type, (ICompareInput)input);
                    }
                    range = new Position(pos, 0);
                    try {
                        newDoc.addPosition("DocumentRangeCategory", range);
                    }
                    catch (BadPositionCategoryException badPositionCategoryException) {
                    }
                    catch (BadLocationException badLocationException) {}
                    this.addNewRange(type, input, range);
                }
            } else if (parent instanceof IDocument) {
                newDoc = ((IDocumentRange)o).getDocument();
            }
        }
        boolean enabled = true;
        if (newDoc == null) {
            newDoc = new Document("");
            enabled = false;
        }
        if (newDoc != (oldDoc = tp.getDocument())) {
            this.unsetDocument(tp);
            if (newDoc != null) {
                newDoc.addPositionCategory("DocumentRangeCategory");
                if (this.fPositionUpdater == null) {
                    this.fPositionUpdater = new ChildPositionUpdater("DocumentRangeCategory");
                } else {
                    newDoc.removePositionUpdater(this.fPositionUpdater);
                }
                newDoc.addPositionUpdater(this.fPositionUpdater);
            }
            if (newDoc != null) {
                tp.setRegion(range);
                if (this.fSubDoc) {
                    if (range != null) {
                        IRegion r = this.normalizeDocumentRegion(newDoc, TextMergeViewer.toRegion(range));
                        tp.setDocument(newDoc, r.getOffset(), r.getLength());
                    } else {
                        tp.setDocument(newDoc);
                    }
                } else {
                    tp.setDocument(newDoc);
                }
                tp.rememberDocument(newDoc);
                newDoc.addDocumentListener(this.fDocumentListener);
            }
        } else {
            tp.setRegion(range);
            if (this.fSubDoc) {
                if (range != null) {
                    IRegion r = this.normalizeDocumentRegion(newDoc, TextMergeViewer.toRegion(range));
                    tp.setVisibleRegion(r.getOffset(), r.getLength());
                } else {
                    tp.resetVisibleRegion();
                }
            } else {
                tp.resetVisibleRegion();
            }
        }
        tp.setEnabled(enabled);
        return enabled;
    }

    private Position getNewRange(char type, Object input) {
        switch (type) {
            case 'A': {
                return (Position)this.fNewAncestorRanges.get(input);
            }
            case 'L': {
                return (Position)this.fNewLeftRanges.get(input);
            }
            case 'R': {
                return (Position)this.fNewRightRanges.get(input);
            }
        }
        return null;
    }

    private void addNewRange(char type, Object input, Position range) {
        switch (type) {
            case 'A': {
                this.fNewAncestorRanges.put(input, range);
                break;
            }
            case 'L': {
                this.fNewLeftRanges.put(input, range);
                break;
            }
            case 'R': {
                this.fNewRightRanges.put(input, range);
            }
        }
    }

    private void unsetDocument(MergeSourceViewer tp) {
        IDocument oldDoc = tp.getDocument();
        if (oldDoc == null) {
            oldDoc = tp.getRememberedDocument();
        }
        if (oldDoc != null) {
            tp.rememberDocument(null);
            if (this.fPositionUpdater != null) {
                oldDoc.removePositionUpdater(this.fPositionUpdater);
            }
            try {
                oldDoc.removePositionCategory("DocumentRangeCategory");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
            oldDoc.removeDocumentListener(this.fDocumentListener);
        }
    }

    protected byte[] getContents(boolean left) {
        String contents;
        IDocument d;
        MergeSourceViewer v;
        MergeSourceViewer mergeSourceViewer = v = left ? this.fLeft : this.fRight;
        if (v != null && (d = v.getDocument()) != null && (contents = d.get()) != null) {
            byte[] bytes;
            try {
                bytes = contents.getBytes(left ? this.fLeftEncoding : this.fRightEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                bytes = contents.getBytes();
            }
            return bytes;
        }
        return null;
    }

    private IRegion normalizeDocumentRegion(IDocument doc, IRegion region) {
        if (region == null || doc == null) {
            return region;
        }
        int maxLength = doc.getLength();
        int start = region.getOffset();
        if (start < 0) {
            start = 0;
        } else if (start > maxLength) {
            start = maxLength;
        }
        int length = region.getLength();
        if (length < 0) {
            length = 0;
        } else if (start + length > maxLength) {
            length = maxLength - start;
        }
        return new Region(start, length);
    }

    protected final void handleResizeAncestor(int x, int y, int width, int height) {
        if (width > 0) {
            Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(true);
            }
            if (this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().setVisible(true);
            }
            if (this.fAncestorCanvas != null) {
                this.fAncestorCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
                width -= this.fMarginWidth;
            }
            this.fAncestor.getTextWidget().setBounds(x, y, width, height);
        } else {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.setVisible(false);
            }
            if (this.fAncestor.isControlOkToUse()) {
                StyledText t = this.fAncestor.getTextWidget();
                t.setVisible(false);
                t.setBounds(0, 0, 0, 0);
                if (this.fFocusPart == this.fAncestor) {
                    this.fFocusPart = this.fLeft;
                    this.fFocusPart.getTextWidget().setFocus();
                }
            }
        }
    }

    protected final void handleResizeLeftRight(int x, int y, int width1, int centerWidth, int width2, int height) {
        if (this.fBirdsEyeCanvas != null) {
            width2 -= 12;
        }
        Rectangle trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
        int scrollbarHeight = trim.height + trim.x;
        Composite composite = (Composite)this.getControl();
        int leftTextWidth = width1;
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            x += this.fMarginWidth;
            leftTextWidth -= this.fMarginWidth;
        }
        this.fLeft.getTextWidget().setBounds(x, y, leftTextWidth, height);
        x += leftTextWidth;
        if (this.fCenter == null || this.fCenter.isDisposed()) {
            this.fCenter = this.createCenter(composite);
        }
        this.fCenter.setBounds(x, y, centerWidth, height - scrollbarHeight);
        x += centerWidth;
        if (!this.fSynchronizedScrolling && this.fRightCanvas != null) {
            this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
            this.fRightCanvas.redraw();
            x += this.fMarginWidth;
        }
        int scrollbarWidth = 0;
        if (this.fSynchronizedScrolling && this.fScrollCanvas != null) {
            trim = this.fLeft.getTextWidget().computeTrim(0, 0, 0, 0);
            scrollbarWidth = trim.width + 2 * trim.x;
        }
        int rightTextWidth = width2 - scrollbarWidth;
        if (this.fRightCanvas != null) {
            rightTextWidth -= this.fMarginWidth;
        }
        this.fRight.getTextWidget().setBounds(x, y, rightTextWidth, height);
        x += rightTextWidth;
        if (this.fSynchronizedScrolling) {
            if (this.fRightCanvas != null) {
                this.fRightCanvas.setBounds(x, y, this.fMarginWidth, height - scrollbarHeight);
                x += this.fMarginWidth;
            }
            if (this.fScrollCanvas != null) {
                this.fScrollCanvas.setBounds(x, y, scrollbarWidth, height - scrollbarHeight);
            }
        }
        if (this.fBirdsEyeCanvas != null) {
            int verticalScrollbarButtonHeight = scrollbarWidth;
            int horizontalScrollbarButtonHeight = scrollbarHeight;
            if (this.fIsCarbon) {
                verticalScrollbarButtonHeight += 2;
                horizontalScrollbarButtonHeight = 18;
            }
            if (this.fSummaryHeader != null) {
                this.fSummaryHeader.setBounds(x + scrollbarWidth, y, 12, verticalScrollbarButtonHeight);
            }
            this.fBirdsEyeCanvas.setBounds(x + scrollbarWidth, y += verticalScrollbarButtonHeight, 12, height - (2 * verticalScrollbarButtonHeight + horizontalScrollbarButtonHeight));
        }
        this.updateVScrollBar();
        this.refreshBirdsEyeView();
    }

    private void handleSelectionChanged(MergeSourceViewer tw) {
        Point p = tw.getSelectedRange();
        Diff d = this.findDiff(tw, p.x, p.x + p.y);
        this.updateStatus(d);
        this.setCurrentDiff(d, false);
    }

    private static IRegion toRegion(Position position) {
        if (position != null) {
            return new Region(position.getOffset(), position.getLength());
        }
        return null;
    }

    private static int maxWork(IRangeComparator a, IRangeComparator l, IRangeComparator r) {
        int ln = l.getRangeCount();
        int rn = r.getRangeCount();
        if (a != null) {
            int an = a.getRangeCount();
            return 2 * Math.max(an, ln) + 2 * Math.max(an, rn);
        }
        return 2 * Math.max(ln, rn);
    }

    /*
     * Unable to fully structure code
     */
    private void doDiff() {
        block23: {
            block22: {
                this.fAllDiffs = new ArrayList<E>();
                this.fChangeDiffs = new ArrayList<E>();
                this.fCurrentDiff = null;
                aDoc = null;
                lDoc = this.fLeft.getDocument();
                rDoc = this.fRight.getDocument();
                if (lDoc == null || rDoc == null) {
                    return;
                }
                aRegion = null;
                lRegion = this.fLeft.getRegion();
                rRegion = this.fRight.getRegion();
                threeWay = this.isThreeWay();
                if (threeWay && !this.fIgnoreAncestor) {
                    aDoc = this.fAncestor.getDocument();
                    aRegion = this.fAncestor.getRegion();
                }
                this.fAncestor.resetLineBackground();
                this.fLeft.resetLineBackground();
                this.fRight.resetLineBackground();
                ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
                sright = new DocLineComparator(rDoc, TextMergeViewer.toRegion(rRegion), ignoreWhiteSpace);
                sleft = new DocLineComparator(lDoc, TextMergeViewer.toRegion(lRegion), ignoreWhiteSpace);
                sancestor = null;
                if (aDoc != null) {
                    sancestor = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
                }
                if (!this.fSubDoc && rRegion != null && lRegion != null) {
                    astart = 0;
                    as = 0;
                    if (aRegion != null) {
                        astart = aRegion.getOffset();
                        as = Math.max(0, astart - 1);
                    }
                    ys = Math.max(0, lRegion.getOffset() - 1);
                    ms = Math.max(0, rRegion.getOffset() - 1);
                    if (as > 0 || ys > 0 || ms > 0) {
                        diff = new Diff(null, 0, aDoc, aRegion, 0, astart, lDoc, lRegion, 0, lRegion.getOffset(), rDoc, rRegion, 0, rRegion.getOffset());
                        this.fAllDiffs.add(diff);
                    }
                }
                bundle = this.getResourceBundle();
                result = new Object[1];
                sa = sancestor;
                sl = sleft;
                sr = sright;
                runnable = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                        String progressTitle = Utilities.getString(bundle, "compareProgressTask.title");
                        monitor.beginTask(progressTitle, TextMergeViewer.maxWork(sa, sl, sr));
                        try {
                            result[0] = RangeDifferencer.findRanges(monitor, sa, sl, sr);
                        }
                        catch (OutOfMemoryError ex) {
                            System.gc();
                            throw new InvocationTargetException(ex);
                        }
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.done();
                    }
                };
                progressService = PlatformUI.getWorkbench().getProgressService();
                e = null;
                try {
                    progressService.run(true, true, runnable);
                    e = (RangeDifference[])result[0];
                }
                catch (InvocationTargetException v0) {
                    title = Utilities.getString(bundle, "tooComplexError.title");
                    format = Utilities.getString(bundle, "tooComplexError.format");
                    msg = MessageFormat.format(format, new Object[]{Integer.toString(progressService.getLongOperationTime() / 1000)});
                    MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
                    e = null;
                }
                catch (InterruptedException v1) {}
                if (e != null) break block22;
                diff = new Diff(null, 0, aDoc, aRegion, 0, aDoc != null ? aDoc.getLength() : 0, lDoc, lRegion, 0, lDoc.getLength(), rDoc, rRegion, 0, rDoc.getLength());
                this.fAllDiffs.add(diff);
                break block23;
            }
            i = 0;
            while (i < e.length) {
                a = null;
                s = null;
                d = null;
                es = e[i];
                kind = es.kind();
                ancestorStart = 0;
                ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = TextMergeViewer.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
                }
                leftStart = sleft.getTokenStart(es.leftStart());
                leftEnd = TextMergeViewer.getTokenEnd2(sleft, es.leftStart(), es.leftLength());
                rightStart = sright.getTokenStart(es.rightStart());
                rightEnd = TextMergeViewer.getTokenEnd2(sright, es.rightStart(), es.rightLength());
                diff = new Diff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart, leftEnd, rDoc, rRegion, rightStart, rightEnd);
                this.fAllDiffs.add(diff);
                if (!ignoreWhiteSpace) ** GOTO lbl-1000
                if (sancestor != null) {
                    a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                }
                s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                if ((a == null || a.trim().length() == 0) && s.trim().length() == 0 && d.trim().length() == 0) {
                    diff.fIsWhitespace = true;
                } else if (this.useChange(kind)) {
                    this.fChangeDiffs.add(diff);
                    this.updateDiffBackground(diff);
                    if (s == null) {
                        s = this.extract2(lDoc, sleft, es.leftStart(), es.leftLength());
                    }
                    if (d == null) {
                        d = this.extract2(rDoc, sright, es.rightStart(), es.rightLength());
                    }
                    if (s.length() > 0 && d.length() > 0) {
                        if (a == null && sancestor != null) {
                            a = this.extract2(aDoc, sancestor, es.ancestorStart(), es.ancestorLength());
                        }
                        this.simpleTokenDiff(diff, aDoc, a, rDoc, d, lDoc, s);
                    }
                }
                ++i;
            }
        }
        if (!this.fSubDoc && rRegion != null && lRegion != null) {
            aEnd = 0;
            aLen = 0;
            if (aRegion != null && aDoc != null) {
                aEnd = aRegion.getOffset() + aRegion.getLength();
                aLen = aDoc.getLength();
            }
            diff = new Diff(null, 0, aDoc, aRegion, aEnd, aLen, lDoc, lRegion, lRegion.getOffset() + lRegion.getLength(), lDoc.getLength(), rDoc, rRegion, rRegion.getOffset() + rRegion.getLength(), rDoc.getLength());
            this.fAllDiffs.add(diff);
        }
    }

    private Diff findDiff(char type, int pos) {
        IDocument aDoc = null;
        IDocument lDoc = this.fLeft.getDocument();
        IDocument rDoc = this.fRight.getDocument();
        if (lDoc == null || rDoc == null) {
            return null;
        }
        Position aRegion = null;
        Position lRegion = null;
        Position rRegion = null;
        boolean threeWay = this.isThreeWay();
        if (threeWay && !this.fIgnoreAncestor) {
            aDoc = this.fAncestor.getDocument();
        }
        boolean ignoreWhiteSpace = Utilities.getBoolean(this.getCompareConfiguration(), "IGNORE_WHITESPACE", false);
        DocLineComparator sright = new DocLineComparator(rDoc, TextMergeViewer.toRegion(rRegion), ignoreWhiteSpace);
        DocLineComparator sleft = new DocLineComparator(lDoc, TextMergeViewer.toRegion(lRegion), ignoreWhiteSpace);
        DocLineComparator sancestor = null;
        if (aDoc != null) {
            sancestor = new DocLineComparator(aDoc, TextMergeViewer.toRegion(aRegion), ignoreWhiteSpace);
        }
        final ResourceBundle bundle = this.getResourceBundle();
        final Object[] result = new Object[1];
        final DocLineComparator sa = sancestor;
        final DocLineComparator sl = sleft;
        final DocLineComparator sr = sright;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                String progressTitle = Utilities.getString(bundle, "compareProgressTask.title");
                monitor.beginTask(progressTitle, TextMergeViewer.maxWork(sa, sl, sr));
                try {
                    result[0] = RangeDifferencer.findRanges(monitor, sa, sl, sr);
                }
                catch (OutOfMemoryError ex) {
                    System.gc();
                    throw new InvocationTargetException(ex);
                }
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                monitor.done();
            }
        };
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        RangeDifference[] e = null;
        try {
            progressService.run(true, true, runnable);
            e = (RangeDifference[])result[0];
        }
        catch (InvocationTargetException invocationTargetException) {
            String title = Utilities.getString(bundle, "tooComplexError.title");
            String format = Utilities.getString(bundle, "tooComplexError.format");
            String msg = MessageFormat.format(format, Integer.toString(progressService.getLongOperationTime() / 1000));
            MessageDialog.openError((Shell)this.fComposite.getShell(), (String)title, (String)msg);
            e = null;
        }
        catch (InterruptedException interruptedException) {}
        if (e != null) {
            int i = 0;
            while (i < e.length) {
                int rightEnd;
                int rightStart;
                int leftEnd;
                int leftStart;
                Diff diff;
                RangeDifference es = e[i];
                int kind = es.kind();
                int ancestorStart = 0;
                int ancestorEnd = 0;
                if (sancestor != null) {
                    ancestorStart = sancestor.getTokenStart(es.ancestorStart());
                    ancestorEnd = TextMergeViewer.getTokenEnd2(sancestor, es.ancestorStart(), es.ancestorLength());
                }
                if ((diff = new Diff(null, kind, aDoc, aRegion, ancestorStart, ancestorEnd, lDoc, lRegion, leftStart = sleft.getTokenStart(es.leftStart()), leftEnd = TextMergeViewer.getTokenEnd2(sleft, es.leftStart(), es.leftLength()), rDoc, rRegion, rightStart = sright.getTokenStart(es.rightStart()), rightEnd = TextMergeViewer.getTokenEnd2(sright, es.rightStart(), es.rightLength()))).isInRange(type, pos)) {
                    return diff;
                }
                ++i;
            }
        }
        return null;
    }

    private boolean useChange(int kind) {
        if (kind == 0) {
            return false;
        }
        if (kind == 4) {
            return this.fShowPseudoConflicts;
        }
        return true;
    }

    private int getTokenEnd(ITokenComparator tc, int start, int count) {
        if (count <= 0) {
            return tc.getTokenStart(start);
        }
        int index = start + count - 1;
        return tc.getTokenStart(index) + tc.getTokenLength(index);
    }

    private static int getTokenEnd2(ITokenComparator tc, int start, int length) {
        return tc.getTokenStart(start + length);
    }

    private String extract2(IDocument doc, ITokenComparator tc, int start, int length) {
        int count = tc.getRangeCount();
        if (length > 0 && count > 0) {
            int startPos = tc.getTokenStart(start);
            int endPos = length == 1 ? startPos + tc.getTokenLength(start) : tc.getTokenStart(start + length);
            try {
                return doc.get(startPos, endPos - startPos);
            }
            catch (BadLocationException badLocationException) {}
        }
        return "";
    }

    private void simpleTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        int ancestorStart = 0;
        ITokenComparator sa = null;
        if (ancestorDoc != null) {
            ancestorStart = baseDiff.fAncestorPos.getOffset();
            sa = this.createTokenComparator(a);
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] e = RangeDifferencer.findRanges(sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < e.length) {
            RangeDifference es = e[i];
            int kind = es.kind();
            if (kind != 0) {
                int ancestorStart2 = ancestorStart;
                int ancestorEnd2 = ancestorStart;
                if (ancestorDoc != null) {
                    ancestorStart2 += sa.getTokenStart(es.ancestorStart());
                    ancestorEnd2 += this.getTokenEnd(sa, es.ancestorStart(), es.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(es.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, es.leftStart(), es.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(es.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, es.rightStart(), es.rightLength());
                Diff diff = new Diff(baseDiff, kind, ancestorDoc, null, ancestorStart2, ancestorEnd2, leftDoc, null, leftStart2, leftEnd2, rightDoc, null, rightStart2, rightEnd2);
                int leftS = baseDiff.fLeftPos.offset;
                int leftE = baseDiff.fLeftPos.offset + baseDiff.fLeftPos.length;
                int rightS = baseDiff.fRightPos.offset;
                int rightE = baseDiff.fRightPos.offset + baseDiff.fRightPos.length;
                if (leftS != leftStart2 || leftE != leftEnd2 || rightS != rightStart2 || rightE != rightEnd2) {
                    diff.fIsToken = true;
                    baseDiff.add(diff);
                }
            }
            ++i;
        }
    }

    private void mergingTokenDiff(Diff baseDiff, IDocument ancestorDoc, String a, IDocument rightDoc, String d, IDocument leftDoc, String s) {
        ITokenComparator sa = null;
        int ancestorStart = 0;
        if (ancestorDoc != null) {
            sa = this.createTokenComparator(a);
            ancestorStart = baseDiff.fAncestorPos.getOffset();
        }
        int rightStart = baseDiff.fRightPos.getOffset();
        ITokenComparator sm = this.createTokenComparator(d);
        int leftStart = baseDiff.fLeftPos.getOffset();
        ITokenComparator sy = this.createTokenComparator(s);
        RangeDifference[] r = RangeDifferencer.findRanges(sa, (IRangeComparator)sy, (IRangeComparator)sm);
        int i = 0;
        while (i < r.length) {
            RangeDifference es = r[i];
            int start = i;
            int leftLine = -1;
            int rightLine = -1;
            try {
                leftLine = leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart()));
                rightLine = rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()));
            }
            catch (BadLocationException badLocationException) {}
            ++i;
            while (i < r.length) {
                es = r[i];
                try {
                    if (leftLine != leftDoc.getLineOfOffset(leftStart + sy.getTokenStart(es.leftStart())) || rightLine != rightDoc.getLineOfOffset(rightStart + sm.getTokenStart(es.rightStart()))) {
                        break;
                    }
                }
                catch (BadLocationException badLocationException) {}
                ++i;
            }
            int end = i;
            RangeDifference first = null;
            int ii = start;
            while (ii < end) {
                es = r[ii];
                if (this.useChange(es.kind())) {
                    first = es;
                    break;
                }
                ++ii;
            }
            RangeDifference last = null;
            int ii2 = end - 1;
            while (ii2 >= start) {
                es = r[ii2];
                if (this.useChange(es.kind())) {
                    last = es;
                    break;
                }
                --ii2;
            }
            if (first != null && last != null) {
                int ancestorStart2 = 0;
                int ancestorEnd2 = 0;
                if (ancestorDoc != null) {
                    ancestorStart2 = ancestorStart + sa.getTokenStart(first.ancestorStart());
                    ancestorEnd2 = ancestorStart + this.getTokenEnd(sa, last.ancestorStart(), last.ancestorLength());
                }
                int leftStart2 = leftStart + sy.getTokenStart(first.leftStart());
                int leftEnd2 = leftStart + this.getTokenEnd(sy, last.leftStart(), last.leftLength());
                int rightStart2 = rightStart + sm.getTokenStart(first.rightStart());
                int rightEnd2 = rightStart + this.getTokenEnd(sm, last.rightStart(), last.rightLength());
                Diff diff = new Diff(baseDiff, first.kind(), ancestorDoc, null, ancestorStart2, ancestorEnd2 + 1, leftDoc, null, leftStart2, leftEnd2 + 1, rightDoc, null, rightStart2, rightEnd2 + 1);
                diff.fIsToken = true;
                baseDiff.add(diff);
            }
            ++i;
        }
    }

    private void updateControls() {
        IAction a;
        IMergeViewerContentProvider cp;
        boolean leftToRight = false;
        boolean rightToLeft = false;
        this.updateStatus(this.fCurrentDiff);
        this.updateResolveStatus();
        if (this.fCurrentDiff != null && (cp = this.getMergeContentProvider()) != null) {
            rightToLeft = cp.isLeftEditable(this.getInput());
            leftToRight = cp.isRightEditable(this.getInput());
        }
        if (this.fDirectionLabel != null) {
            if (this.fHighlightRanges && this.fCurrentDiff != null && this.isThreeWay() && !this.fIgnoreAncestor) {
                this.fDirectionLabel.setImage(this.fCurrentDiff.getImage());
            } else {
                this.fDirectionLabel.setImage(null);
            }
        }
        if (this.fCopyDiffLeftToRightItem != null) {
            ((Action)this.fCopyDiffLeftToRightItem.getAction()).setEnabled(leftToRight);
        }
        if (this.fCopyDiffRightToLeftItem != null) {
            ((Action)this.fCopyDiffRightToLeftItem.getAction()).setEnabled(rightToLeft);
        }
        boolean enableNavigation = false;
        if (this.fCurrentDiff == null && this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
            enableNavigation = true;
        } else if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 1) {
            enableNavigation = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fDiffs != null) {
            enableNavigation = true;
        } else if (this.fCurrentDiff != null && this.fCurrentDiff.fIsToken) {
            enableNavigation = true;
        }
        if (this.fNextItem != null) {
            a = this.fNextItem.getAction();
            a.setEnabled(enableNavigation);
        }
        if (this.fPreviousItem != null) {
            a = this.fPreviousItem.getAction();
            a.setEnabled(enableNavigation);
        }
    }

    private void updateResolveStatus() {
        RGB rgb = null;
        if (this.showResolveUI()) {
            int incomingOrConflicting = 0;
            int unresolvedIncoming = 0;
            int unresolvedConflicting = 0;
            if (this.fChangeDiffs != null) {
                Iterator e = this.fChangeDiffs.iterator();
                while (e.hasNext()) {
                    Diff d = (Diff)e.next();
                    if (!d.isIncomingOrConflicting()) continue;
                    ++incomingOrConflicting;
                    if (d.fResolved) continue;
                    if (d.fDirection == 1) {
                        ++unresolvedConflicting;
                        break;
                    }
                    ++unresolvedIncoming;
                }
            }
            if (incomingOrConflicting > 0) {
                rgb = unresolvedConflicting > 0 ? this.SELECTED_CONFLICT : (unresolvedIncoming > 0 ? this.SELECTED_INCOMING : this.RESOLVED);
            }
        }
        if (this.fHeaderPainter.setColor(rgb)) {
            this.fSummaryHeader.redraw();
        }
    }

    private void updateStatus(Diff diff) {
        String format;
        String diffDescription;
        if (!this.fShowMoreInfo) {
            return;
        }
        IActionBars bars = Utilities.findActionBars((Control)this.fComposite);
        if (bars == null) {
            return;
        }
        IStatusLineManager slm = bars.getStatusLineManager();
        if (slm == null) {
            return;
        }
        if (diff == null) {
            diffDescription = CompareMessages.TextMergeViewer_diffDescription_noDiff_format;
        } else {
            if (diff.fIsToken) {
                diff = diff.fParent;
            }
            format = CompareMessages.TextMergeViewer_diffDescription_diff_format;
            diffDescription = MessageFormat.format(format, this.getDiffType(diff), this.getDiffNumber(diff), this.getDiffRange(this.fLeft, diff.fLeftPos), this.getDiffRange(this.fRight, diff.fRightPos));
        }
        format = CompareMessages.TextMergeViewer_statusLine_format;
        String s = MessageFormat.format(format, this.getCursorPosition(this.fLeft), this.getCursorPosition(this.fRight), diffDescription);
        slm.setMessage(s);
    }

    private void clearStatus() {
        IActionBars bars = Utilities.findActionBars((Control)this.fComposite);
        if (bars == null) {
            return;
        }
        IStatusLineManager slm = bars.getStatusLineManager();
        if (slm == null) {
            return;
        }
        slm.setMessage(null);
    }

    private String getDiffType(Diff diff) {
        String s = "";
        switch (diff.fDirection) {
            case 3: {
                s = CompareMessages.TextMergeViewer_direction_outgoing;
                break;
            }
            case 2: {
                s = CompareMessages.TextMergeViewer_direction_incoming;
                break;
            }
            case 1: {
                s = CompareMessages.TextMergeViewer_direction_conflicting;
            }
        }
        String format = CompareMessages.TextMergeViewer_diffType_format;
        return MessageFormat.format(format, s, diff.changeType());
    }

    private String getDiffNumber(Diff diff) {
        int diffNumber = 0;
        if (this.fChangeDiffs != null) {
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff d = (Diff)e.next();
                ++diffNumber;
                if (d == diff) break;
            }
        }
        return Integer.toString(diffNumber);
    }

    private String getDiffRange(MergeSourceViewer v, Position pos) {
        Point p = v.getLineRange(pos, new Point(0, 0));
        int endLine = p.x + p.y;
        int startLine = p.x + 1;
        String format = endLine < startLine ? CompareMessages.TextMergeViewer_beforeLine_format : CompareMessages.TextMergeViewer_range_format;
        return MessageFormat.format(format, Integer.toString(startLine), Integer.toString(endLine));
    }

    private String getCursorPosition(MergeSourceViewer v) {
        if (v != null) {
            StyledText styledText = v.getTextWidget();
            IDocument document = v.getDocument();
            if (document != null) {
                int offset = v.getVisibleRegion().getOffset();
                int caret = offset + styledText.getCaretOffset();
                try {
                    int line = document.getLineOfOffset(caret);
                    int lineOffset = document.getLineOffset(line);
                    int occurrences = 0;
                    int i = lineOffset;
                    while (i < caret) {
                        if ('\t' == document.getChar(i)) {
                            ++occurrences;
                        }
                        ++i;
                    }
                    int tabWidth = styledText.getTabs();
                    int column = caret - lineOffset + (tabWidth - 1) * occurrences;
                    String format = CompareMessages.TextMergeViewer_cursorPosition_format;
                    return MessageFormat.format(format, Integer.toString(line + 1), Integer.toString(column + 1));
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return "";
    }

    protected void updateHeader() {
        super.updateHeader();
        this.updateControls();
    }

    protected void createToolItems(ToolBarManager tbm) {
        IWorkbenchPartSite ps = Utilities.findSite((Control)this.fComposite);
        this.fKeyBindingService = ps != null ? ps.getKeyBindingService() : null;
        Action ignoreAncestorAction = new Action(){

            public void run() {
                TextMergeViewer.this.setIgnoreAncestor(!TextMergeViewer.this.fIgnoreAncestor);
                Utilities.initToggleAction((IAction)this, TextMergeViewer.this.getResourceBundle(), "action.IgnoreAncestor.", TextMergeViewer.this.fIgnoreAncestor);
            }
        };
        ignoreAncestorAction.setChecked(this.fIgnoreAncestor);
        Utilities.initAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.");
        Utilities.initToggleAction((IAction)ignoreAncestorAction, this.getResourceBundle(), "action.IgnoreAncestor.", this.fIgnoreAncestor);
        this.fIgnoreAncestorItem = new ActionContributionItem((IAction)ignoreAncestorAction);
        this.fIgnoreAncestorItem.setVisible(false);
        tbm.appendToGroup("modes", (IContributionItem)this.fIgnoreAncestorItem);
        tbm.add((IContributionItem)new Separator());
        Action a = new Action(){

            public void run() {
                TextMergeViewer.this.navigate(true, true, true);
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.NextDiff.");
        this.fNextItem = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fNextItem);
        Utilities.registerAction(this.fKeyBindingService, (IAction)a, "org.eclipse.compare.selectNextChange");
        a = new Action(){

            public void run() {
                TextMergeViewer.this.navigate(false, true, true);
            }
        };
        Utilities.initAction((IAction)a, this.getResourceBundle(), "action.PrevDiff.");
        this.fPreviousItem = new ActionContributionItem((IAction)a);
        tbm.appendToGroup("navigation", (IContributionItem)this.fPreviousItem);
        Utilities.registerAction(this.fKeyBindingService, (IAction)a, "org.eclipse.compare.selectPreviousChange");
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc.isRightEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffLeftToRight();
                }
            };
            Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffLeftToRight.");
            this.fCopyDiffLeftToRightItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffLeftToRightItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffLeftToRightItem);
            Utilities.registerAction(this.fKeyBindingService, (IAction)a, "org.eclipse.compare.copyLeftToRight");
        }
        if (cc.isLeftEditable()) {
            a = new Action(){

                public void run() {
                    TextMergeViewer.this.copyDiffRightToLeft();
                }
            };
            Utilities.initAction((IAction)a, this.getResourceBundle(), "action.CopyDiffRightToLeft.");
            this.fCopyDiffRightToLeftItem = new ActionContributionItem((IAction)a);
            this.fCopyDiffRightToLeftItem.setVisible(true);
            tbm.appendToGroup("merge", (IContributionItem)this.fCopyDiffRightToLeftItem);
            Utilities.registerAction(this.fKeyBindingService, (IAction)a, "org.eclipse.compare.copyRightToLeft");
        }
    }

    void propertyChange(PropertyChangeEvent event) {
        String key = event.getProperty();
        if (key.equals("IGNORE_WHITESPACE") || key.equals("org.eclipse.compare.ShowPseudoConflicts")) {
            this.fShowPseudoConflicts = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowPseudoConflicts");
            this.fCurrentDiff = null;
            this.fChangeDiffs = null;
            this.fAllDiffs = null;
            this.doDiff();
            this.updateControls();
            this.invalidateLines();
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
            this.selectFirstDiff();
        } else if (key.equals("org.eclipse.compare.UseSingleLine")) {
            this.fUseSingleLine = this.fPreferenceStore.getBoolean("org.eclipse.compare.UseSingleLine");
            this.fBasicCenterCurve = null;
            this.updateResolveStatus();
            this.invalidateLines();
        } else if (key.equals(this.fSymbolicFontName)) {
            this.updateFont();
            this.invalidateLines();
        } else if (key.equals(INCOMING_COLOR) || key.equals(OUTGOING_COLOR) || key.equals(CONFLICTING_COLOR) || key.equals(RESOLVED_COLOR)) {
            this.updateColors(null);
            this.invalidateLines();
        } else if (key.equals("org.eclipse.compare.SynchronizeScrolling")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.SynchronizeScrolling");
            if (b != this.fSynchronizedScrolling) {
                this.toggleSynchMode();
            }
        } else if (key.equals("org.eclipse.compare.ShowMoreInfo")) {
            boolean b = this.fPreferenceStore.getBoolean("org.eclipse.compare.ShowMoreInfo");
            if (b != this.fShowMoreInfo) {
                this.fShowMoreInfo = b;
                if (this.fShowMoreInfo) {
                    this.updateStatus(this.fCurrentDiff);
                } else {
                    this.clearStatus();
                }
            }
        } else {
            super.propertyChange(event);
        }
    }

    private void setIgnoreAncestor(boolean ignore) {
        if (ignore != this.fIgnoreAncestor) {
            this.fIgnoreAncestor = ignore;
            this.setAncestorVisibility(false, !this.fIgnoreAncestor);
            this.fCurrentDiff = null;
            this.fChangeDiffs = null;
            this.fAllDiffs = null;
            this.doDiff();
            this.invalidateLines();
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
            this.selectFirstDiff();
        }
    }

    private void selectFirstDiff() {
        if (this.fLeft == null || this.fRight == null) {
            return;
        }
        if (this.fLeft.getDocument() == null || this.fRight.getDocument() == null) {
            return;
        }
        Diff firstDiff = null;
        firstDiff = CompareNavigator.getDirection((Control)this.fComposite) ? TextMergeViewer.findNext(this.fRight, this.fChangeDiffs, -1, -1, false) : TextMergeViewer.findPrev(this.fRight, this.fChangeDiffs, 9999999, 9999999, false);
        this.setCurrentDiff(firstDiff, true);
    }

    private void toggleSynchMode() {
        this.fSynchronizedScrolling = !this.fSynchronizedScrolling;
        this.scrollVertical(0, 0, 0, null);
        Control center = this.getCenter();
        if (center != null && !center.isDisposed()) {
            center.dispose();
        }
        this.fLeft.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fRight.getTextWidget().getVerticalBar().setVisible(!this.fSynchronizedScrolling);
        this.fComposite.layout(true);
    }

    protected void updateToolItems() {
        IAction a;
        if (this.fIgnoreAncestorItem != null) {
            this.fIgnoreAncestorItem.setVisible(this.isThreeWay());
        }
        if (this.fCopyDiffLeftToRightItem != null && (a = this.fCopyDiffLeftToRightItem.getAction()) != null) {
            a.setEnabled(a.isEnabled() && !this.fHasErrors);
        }
        if (this.fCopyDiffRightToLeftItem != null && (a = this.fCopyDiffRightToLeftItem.getAction()) != null) {
            a.setEnabled(a.isEnabled() && !this.fHasErrors);
        }
        super.updateToolItems();
    }

    private void updateLines(IDocument d) {
        int l;
        boolean left = false;
        boolean right = false;
        if (d == this.fLeft.getDocument()) {
            l = this.fLeft.getLineCount();
            left = this.fLeftLineCount != l;
            this.fLeftLineCount = l;
        } else if (d == this.fRight.getDocument()) {
            l = this.fRight.getLineCount();
            right = this.fRightLineCount != l;
            this.fRightLineCount = l;
        }
        if (left || right) {
            Control center;
            if (left) {
                if (this.fLeftCanvas != null) {
                    this.fLeftCanvas.redraw();
                }
            } else if (this.fRightCanvas != null) {
                this.fRightCanvas.redraw();
            }
            if ((center = this.getCenter()) != null) {
                center.redraw();
            }
            this.updateVScrollBar();
            this.refreshBirdsEyeView();
        }
    }

    private void invalidateLines() {
        if (this.isThreeWay()) {
            if (Utilities.okToUse((Widget)this.fAncestorCanvas)) {
                this.fAncestorCanvas.redraw();
            }
            if (this.fAncestor != null && this.fAncestor.isControlOkToUse()) {
                this.fAncestor.getTextWidget().redraw();
            }
        }
        if (Utilities.okToUse((Widget)this.fLeftCanvas)) {
            this.fLeftCanvas.redraw();
        }
        if (this.fLeft != null && this.fLeft.isControlOkToUse()) {
            this.fLeft.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.getCenter())) {
            this.getCenter().redraw();
        }
        if (this.fRight != null && this.fRight.isControlOkToUse()) {
            this.fRight.getTextWidget().redraw();
        }
        if (Utilities.okToUse((Widget)this.fRightCanvas)) {
            this.fRightCanvas.redraw();
        }
    }

    private boolean showResolveUI() {
        if (!this.fUseResolveUI || !this.isThreeWay() || this.fIgnoreAncestor) {
            return false;
        }
        CompareConfiguration cc = this.getCompareConfiguration();
        if (cc == null) {
            return false;
        }
        boolean l = cc.isLeftEditable();
        boolean r = cc.isRightEditable();
        return l || r;
    }

    private void paintCenter(Canvas canvas, GC g) {
        Display display = canvas.getDisplay();
        this.checkForColorUpdate(display);
        if (!this.fSynchronizedScrolling) {
            return;
        }
        int lineHeight = this.fLeft.getTextWidget().getLineHeight();
        int visibleHeight = this.fRight.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = size.x;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x + 1, 0, w - 2, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            g.fillRectangle(0, 0, 1, size.y);
            g.fillRectangle(w - 1, 0, 1, size.y);
        }
        if (!this.fHighlightRanges) {
            return;
        }
        boolean showResolveUI = this.showResolveUI();
        if (this.fChangeDiffs != null) {
            int lshift = this.fLeft.getVerticalScrollOffset();
            int rshift = this.fRight.getVerticalScrollOffset();
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                int i;
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                this.fLeft.getLineRange(diff.fLeftPos, region);
                int ly = region.x * lineHeight + lshift;
                int lh = region.y * lineHeight;
                this.fRight.getLineRange(diff.fRightPos, region);
                int ry = region.x * lineHeight + rshift;
                int rh = region.y * lineHeight;
                if (Math.max(ly + lh, ry + rh) < 0) continue;
                if (Math.min(ly, ry) >= visibleHeight) break;
                this.fPts[0] = x;
                this.fPts[1] = ly;
                this.fPts[2] = w;
                this.fPts[3] = ry;
                this.fPts[6] = x;
                this.fPts[7] = ly + lh;
                this.fPts[4] = w;
                this.fPts[5] = ry + rh;
                Color fillColor = this.getColor(display, this.getFillColor(diff));
                Color strokeColor = this.getColor(display, this.getStrokeColor(diff));
                if (this.fUseSingleLine) {
                    int w2 = 3;
                    g.setBackground(fillColor);
                    g.fillRectangle(0, ly, w2, lh);
                    g.fillRectangle(w - w2, ry, w2, rh);
                    g.setLineWidth(1);
                    g.setForeground(strokeColor);
                    g.drawRectangle(-1, ly, w2, lh);
                    g.drawRectangle(w - w2, ry, w2, rh);
                    if (this.fUseSplines) {
                        int[] points = this.getCenterCurvePoints(w2, ly + lh / 2, w - w2, ry + rh / 2);
                        i = 1;
                        while (i < points.length) {
                            g.drawLine(w2 + i - 1, points[i - 1], w2 + i, points[i]);
                            ++i;
                        }
                    } else {
                        g.drawLine(w2, ly + lh / 2, w - w2, ry + rh / 2);
                    }
                } else if (this.fUseSplines) {
                    g.setBackground(fillColor);
                    g.setLineWidth(1);
                    g.setForeground(strokeColor);
                    int[] topPoints = this.getCenterCurvePoints(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    int[] bottomPoints = this.getCenterCurvePoints(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                    g.setForeground(fillColor);
                    g.drawLine(0, bottomPoints[0], 0, topPoints[0]);
                    i = 1;
                    while (i < bottomPoints.length) {
                        g.setForeground(fillColor);
                        g.drawLine(i, bottomPoints[i], i, topPoints[i]);
                        g.setForeground(strokeColor);
                        g.drawLine(i - 1, topPoints[i - 1], i, topPoints[i]);
                        g.drawLine(i - 1, bottomPoints[i - 1], i, bottomPoints[i]);
                        ++i;
                    }
                } else {
                    g.setBackground(fillColor);
                    g.fillPolygon(this.fPts);
                    g.setLineWidth(1);
                    g.setForeground(strokeColor);
                    g.drawLine(this.fPts[0], this.fPts[1], this.fPts[2], this.fPts[3]);
                    g.drawLine(this.fPts[6], this.fPts[7], this.fPts[4], this.fPts[5]);
                }
                if (!this.fUseSingleLine || !showResolveUI || !diff.isUnresolvedIncomingOrConflicting()) continue;
                int cx = (w - 5) / 2;
                int cy = (ly + lh / 2 + (ry + rh / 2) - 5) / 2;
                g.setBackground(fillColor);
                g.fillRectangle(cx, cy, 5, 5);
                g.setForeground(strokeColor);
                g.drawRectangle(cx, cy, 5, 5);
            }
        }
    }

    private int[] getCenterCurvePoints(int startx, int starty, int endx, int endy) {
        if (this.fBasicCenterCurve == null) {
            this.buildBaseCenterCurve(endx - startx);
        }
        double height = endy - starty;
        height /= 2.0;
        int width = endx - startx;
        int[] points = new int[width];
        int i = 0;
        while (i < width) {
            points[i] = (int)(-height * this.fBasicCenterCurve[i] + height + (double)starty);
            ++i;
        }
        return points;
    }

    private void buildBaseCenterCurve(int w) {
        double width = w;
        this.fBasicCenterCurve = new double[this.getCenterWidth()];
        int i = 0;
        while (i < this.getCenterWidth()) {
            double r = (double)i / width;
            this.fBasicCenterCurve[i] = Math.cos(Math.PI * r);
            ++i;
        }
    }

    private void paintSides(GC g, MergeSourceViewer tp, Canvas canvas, boolean right) {
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int visibleHeight = tp.getViewportHeight();
        Point size = canvas.getSize();
        int x = 0;
        int w = this.fMarginWidth;
        int w2 = w / 2;
        g.setBackground(canvas.getBackground());
        g.fillRectangle(x, 0, w, size.y);
        if (!this.fIsMotif) {
            g.setBackground(display.getSystemColor(18));
            if (right) {
                g.fillRectangle(0, 0, 1, size.y);
            } else {
                g.fillRectangle(size.x - 1, 0, 1, size.y);
            }
        }
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs != null) {
            int shift = tp.getVerticalScrollOffset() + 1;
            Point region = new Point(0, 0);
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (diff.isDeleted() || this.fShowCurrentOnly2 && !this.isCurrentDiff(diff)) continue;
                tp.getLineRange(diff.getPosition(tp), region);
                int y = region.x * lineHeight + shift;
                int h = region.y * lineHeight;
                if (y + h < 0) continue;
                if (y >= visibleHeight) break;
                g.setBackground(this.getColor(display, this.getFillColor(diff)));
                if (right) {
                    g.fillRectangle(x, y, w2, h);
                } else {
                    g.fillRectangle(x + w2, y, w2, h);
                }
                g.setLineWidth(1);
                g.setForeground(this.getColor(display, this.getStrokeColor(diff)));
                if (right) {
                    g.drawRectangle(x - 1, y - 1, w2, h);
                    continue;
                }
                g.drawRectangle(x + w2, y - 1, w2, h);
            }
        }
    }

    private void paint(PaintEvent event, MergeSourceViewer tp) {
        if (!this.fHighlightRanges) {
            return;
        }
        if (this.fChangeDiffs == null) {
            return;
        }
        Control canvas = (Control)event.widget;
        GC g = event.gc;
        Display display = canvas.getDisplay();
        int lineHeight = tp.getTextWidget().getLineHeight();
        int w = canvas.getSize().x;
        int shift = tp.getVerticalScrollOffset() + 1;
        int maxh = event.y + event.height;
        shift += this.fTopInset;
        Point range = new Point(0, 0);
        Iterator e = this.fChangeDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            if (diff.isDeleted() || this.fShowCurrentOnly && !this.isCurrentDiff(diff)) continue;
            tp.getLineRange(diff.getPosition(tp), range);
            int y = range.x * lineHeight + shift;
            int h = range.y * lineHeight;
            if (y + h < event.y) continue;
            if (y > maxh) break;
            g.setBackground(this.getColor(display, this.getStrokeColor(diff)));
            g.fillRectangle(0, y - 1, w, 1);
            g.fillRectangle(0, y + h - 1, w, 1);
        }
    }

    private RGB getFillColor(Diff diff) {
        boolean selected = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        RGB selected_fill = this.getBackground(null);
        if (this.isThreeWay() && !this.fIgnoreAncestor) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.INCOMING_FILL;
                    }
                    return selected ? selected_fill : this.OUTGOING_FILL;
                }
                case 4: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? selected_fill : this.OUTGOING_FILL;
                    }
                    return selected ? selected_fill : this.INCOMING_FILL;
                }
                case 1: {
                    return selected ? selected_fill : this.CONFLICT_FILL;
                }
            }
            return null;
        }
        return selected ? selected_fill : this.OUTGOING_FILL;
    }

    private RGB getStrokeColor(Diff diff) {
        boolean selected;
        boolean bl = selected = this.fCurrentDiff != null && this.fCurrentDiff.fParent == diff;
        if (this.isThreeWay() && !this.fIgnoreAncestor) {
            switch (diff.fDirection) {
                case 2: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_INCOMING : this.INCOMING;
                    }
                    return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                }
                case 4: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
                case 3: {
                    if (this.fLeftIsLocal) {
                        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
                    }
                    return selected ? this.SELECTED_INCOMING : this.INCOMING;
                }
                case 1: {
                    return selected ? this.SELECTED_CONFLICT : this.CONFLICT;
                }
            }
            return null;
        }
        return selected ? this.SELECTED_OUTGOING : this.OUTGOING;
    }

    private Color getColor(Display display, RGB rgb) {
        Color c;
        if (rgb == null) {
            return null;
        }
        if (this.fColors == null) {
            this.fColors = new HashMap(20);
        }
        if ((c = (Color)this.fColors.get(rgb)) == null) {
            c = new Color((Device)display, rgb);
            this.fColors.put(rgb, c);
        }
        return c;
    }

    static RGB interpolate(RGB fg, RGB bg, double scale) {
        if (fg != null && bg != null) {
            return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
        }
        if (fg != null) {
            return fg;
        }
        if (bg != null) {
            return bg;
        }
        return new RGB(128, 128, 128);
    }

    private boolean navigate(boolean down, boolean wrap, boolean deep) {
        Diff diff = null;
        do {
            if (this.fChangeDiffs != null) {
                MergeSourceViewer part = this.fFocusPart;
                if (part == null) {
                    part = this.fRight;
                }
                if (part != null) {
                    Point s = part.getSelectedRange();
                    diff = down ? TextMergeViewer.findNext(part, this.fChangeDiffs, s.x, s.x + s.y, deep) : TextMergeViewer.findPrev(part, this.fChangeDiffs, s.x, s.x + s.y, deep);
                }
            }
            if (diff == null) {
                if (wrap) {
                    if (!this.fEndOfDocReached) {
                        this.fEndOfDocReached = true;
                        if (!this.endOfDocumentReached(down)) {
                            return true;
                        }
                    }
                    this.fEndOfDocReached = false;
                    if (this.fChangeDiffs != null && this.fChangeDiffs.size() > 0) {
                        diff = down ? (Diff)this.fChangeDiffs.get(0) : (Diff)this.fChangeDiffs.get(this.fChangeDiffs.size() - 1);
                    }
                } else {
                    this.fEndOfDocReached = false;
                    return true;
                }
            }
            this.setCurrentDiff(diff, true);
        } while (diff != null && diff.fDirection == 4 && !this.getAncestorEnabled());
        return false;
    }

    private boolean endOfDocumentReached(boolean down) {
        Control c = this.getControl();
        if (Utilities.okToUse((Widget)c)) {
            c.getDisplay().beep();
            if (down) {
                return MessageDialog.openQuestion((Shell)c.getShell(), (String)CompareMessages.TextMergeViewer_atEnd_title, (String)CompareMessages.TextMergeViewer_atEnd_message);
            }
            return MessageDialog.openQuestion((Shell)c.getShell(), (String)CompareMessages.TextMergeViewer_atBeginning_title, (String)CompareMessages.TextMergeViewer_atBeginning_message);
        }
        return false;
    }

    private Diff findDiff(MergeSourceViewer tp, int rangeStart, int rangeEnd) {
        if (this.fChangeDiffs != null) {
            Iterator e = this.fChangeDiffs.iterator();
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                if (!diff.overlaps(tp, rangeStart, rangeEnd)) continue;
                return diff;
            }
        }
        return null;
    }

    private static Diff findNext(MergeSourceViewer tp, List v, int start, int end, boolean deep) {
        int i = 0;
        while (i < v.size()) {
            Diff diff = (Diff)v.get(i);
            Position p = diff.getPosition(tp);
            if (p != null) {
                int startOffset = p.getOffset();
                if (end < startOffset) {
                    return diff;
                }
                if (deep && diff.fDiffs != null) {
                    Diff d = null;
                    int endOffset = startOffset + p.getLength();
                    if (start == startOffset && (end == endOffset || end == endOffset - 1)) {
                        d = TextMergeViewer.findNext(tp, diff.fDiffs, start - 1, start - 1, deep);
                    } else if (end < endOffset) {
                        d = TextMergeViewer.findNext(tp, diff.fDiffs, start, end, deep);
                    }
                    if (d != null) {
                        return d;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Diff findPrev(MergeSourceViewer tp, List v, int start, int end, boolean deep) {
        int i = v.size() - 1;
        while (i >= 0) {
            Diff diff = (Diff)v.get(i);
            Position p = diff.getPosition(tp);
            if (p != null) {
                int startOffset = p.getOffset();
                int endOffset = startOffset + p.getLength();
                if (start > endOffset) {
                    return diff;
                }
                if (deep && diff.fDiffs != null) {
                    Diff d = null;
                    if (start == startOffset && end == endOffset) {
                        d = TextMergeViewer.findPrev(tp, diff.fDiffs, end, end, deep);
                    } else if (start >= startOffset) {
                        d = TextMergeViewer.findPrev(tp, diff.fDiffs, start, end, deep);
                    }
                    if (d != null) {
                        return d;
                    }
                }
            }
            --i;
        }
        return null;
    }

    private void setCurrentDiff(Diff d, boolean revealAndSelect) {
        Diff d2;
        if (this.fCenterButton != null && !this.fCenterButton.isDisposed()) {
            this.fCenterButton.setVisible(false);
        }
        this.fEndOfDocReached = false;
        Diff oldDiff = this.fCurrentDiff;
        if (d != null && revealAndSelect) {
            if (this.isThreeWay() && !this.fIgnoreAncestor) {
                this.fAncestor.setSelection(d.fAncestorPos);
            }
            this.fLeft.setSelection(d.fLeftPos);
            this.fRight.setSelection(d.fRightPos);
            this.fCurrentDiff = d;
            this.revealDiff(d, d.fIsToken);
        } else {
            this.fCurrentDiff = d;
        }
        Diff d1 = oldDiff != null ? oldDiff.fParent : null;
        Diff diff = d2 = this.fCurrentDiff != null ? this.fCurrentDiff.fParent : null;
        if (d1 != d2) {
            this.updateDiffBackground(d1);
            this.updateDiffBackground(d2);
        }
        this.updateControls();
        this.invalidateLines();
        this.refreshBirdsEyeView();
    }

    private void revealDiff(Diff d, boolean smart) {
        boolean ancestorIsVisible = false;
        boolean leftIsVisible = false;
        boolean rightIsVisible = false;
        if (smart) {
            int as;
            Point region = new Point(0, 0);
            int ls = this.fLeft.getLineRange((Position)d.fLeftPos, (Point)region).x;
            int rs = this.fRight.getLineRange((Position)d.fRightPos, (Point)region).x;
            if (this.isThreeWay() && !this.fIgnoreAncestor && (as = this.fAncestor.getLineRange((Position)d.fAncestorPos, (Point)region).x) >= this.fAncestor.getTopIndex() && as <= this.fAncestor.getBottomIndex()) {
                ancestorIsVisible = true;
            }
            if (ls >= this.fLeft.getTopIndex() && ls <= this.fLeft.getBottomIndex()) {
                leftIsVisible = true;
            }
            if (rs >= this.fRight.getTopIndex() && rs <= this.fRight.getBottomIndex()) {
                rightIsVisible = true;
            }
        }
        if (!leftIsVisible || !rightIsVisible) {
            int avpos = 0;
            int lvpos = 0;
            int rvpos = 0;
            MergeSourceViewer allButThis = null;
            if (leftIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fLeft, this.fLeft.getTopIndex());
                avpos = rvpos;
                allButThis = this.fLeft;
            } else if (rightIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fRight, this.fRight.getTopIndex());
                avpos = rvpos;
                allButThis = this.fRight;
            } else if (ancestorIsVisible) {
                lvpos = rvpos = this.realToVirtualPosition(this.fAncestor, this.fAncestor.getTopIndex());
                avpos = rvpos;
                allButThis = this.fAncestor;
            } else {
                int delta;
                if (this.fAllDiffs != null) {
                    int vpos = 0;
                    Iterator e = this.fAllDiffs.iterator();
                    int i = 0;
                    while (e.hasNext()) {
                        Diff diff = (Diff)e.next();
                        if (diff == d) break;
                        if (this.fSynchronizedScrolling) {
                            vpos += diff.getMaxDiffHeight(this.fShowAncestor);
                        } else {
                            avpos += diff.getAncestorHeight();
                            lvpos += diff.getLeftHeight();
                            rvpos += diff.getRightHeight();
                        }
                        ++i;
                    }
                    if (this.fSynchronizedScrolling) {
                        lvpos = rvpos = vpos;
                        avpos = rvpos;
                    }
                }
                if ((avpos -= (delta = this.fRight.getViewportLines() / 4)) < 0) {
                    avpos = 0;
                }
                if ((lvpos -= delta) < 0) {
                    lvpos = 0;
                }
                if ((rvpos -= delta) < 0) {
                    rvpos = 0;
                }
            }
            this.scrollVertical(avpos, lvpos, rvpos, allButThis);
            if (this.fVScrollBar != null) {
                this.fVScrollBar.setSelection(avpos);
            }
        }
        if (d.fIsToken) {
            TextMergeViewer.reveal(this.fAncestor, d.fAncestorPos);
            TextMergeViewer.reveal(this.fLeft, d.fLeftPos);
            TextMergeViewer.reveal(this.fRight, d.fRightPos);
        } else {
            TextMergeViewer.hscroll(this.fAncestor);
            TextMergeViewer.hscroll(this.fLeft);
            TextMergeViewer.hscroll(this.fRight);
        }
    }

    private static void reveal(MergeSourceViewer v, Position p) {
        Rectangle r;
        StyledText st;
        if (v != null && p != null && (st = v.getTextWidget()) != null && !(r = st.getClientArea()).isEmpty()) {
            v.revealRange(p.offset, p.length);
        }
    }

    private static void hscroll(MergeSourceViewer v) {
        StyledText st;
        if (v != null && (st = v.getTextWidget()) != null) {
            st.setHorizontalIndex(0);
        }
    }

    /*
     * Exception decompiling
     */
    void copyAllUnresolved(boolean leftToRight) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 185->189)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void copy(boolean leftToRight) {
        if (this.showResolveUI()) {
            this.copyAllUnresolved(leftToRight);
            this.invalidateLines();
            return;
        }
        if (leftToRight) {
            if (this.fLeft.getEnabled()) {
                String text = this.fLeft.getTextWidget().getText();
                this.fRight.getTextWidget().setText(text);
                this.fRight.setEnabled(true);
            } else {
                this.fRight.getTextWidget().setText("");
                this.fRight.setEnabled(false);
            }
            this.fRightLineCount = this.fRight.getLineCount();
            this.setRightDirty(true);
        } else {
            if (this.fRight.getEnabled()) {
                String text = this.fRight.getTextWidget().getText();
                this.fLeft.getTextWidget().setText(text);
                this.fLeft.setEnabled(true);
            } else {
                this.fLeft.getTextWidget().setText("");
                this.fLeft.setEnabled(false);
            }
            this.fLeftLineCount = this.fLeft.getLineCount();
            this.setLeftDirty(true);
        }
        this.doDiff();
        this.invalidateLines();
        this.updateVScrollBar();
        this.selectFirstDiff();
        this.refreshBirdsEyeView();
    }

    private void copyDiffLeftToRight() {
        this.copy(this.fCurrentDiff, true, false);
    }

    private void copyDiffRightToLeft() {
        this.copy(this.fCurrentDiff, false, false);
    }

    private void copy(Diff diff, boolean leftToRight, boolean gotoNext) {
        if (this.copy(diff, leftToRight)) {
            if (gotoNext) {
                this.navigate(true, true, true);
            } else {
                this.revealDiff(diff, true);
                this.updateControls();
            }
        }
    }

    private boolean copy(Diff diff, boolean leftToRight) {
        if (diff != null && !diff.isResolved()) {
            Position fromPos = null;
            Position toPos = null;
            IDocument fromDoc = null;
            IDocument toDoc = null;
            if (leftToRight) {
                this.fRight.setEnabled(true);
                fromPos = diff.fLeftPos;
                toPos = diff.fRightPos;
                fromDoc = this.fLeft.getDocument();
                toDoc = this.fRight.getDocument();
            } else {
                this.fLeft.setEnabled(true);
                fromPos = diff.fRightPos;
                toPos = diff.fLeftPos;
                fromDoc = this.fRight.getDocument();
                toDoc = this.fLeft.getDocument();
            }
            if (fromDoc != null) {
                int fromStart = fromPos.getOffset();
                int fromLen = fromPos.getLength();
                int toStart = toPos.getOffset();
                int toLen = toPos.getLength();
                try {
                    String s = null;
                    switch (diff.fDirection) {
                        case 2: 
                        case 3: {
                            s = fromDoc.get(fromStart, fromLen);
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 1: {
                            s = toDoc.get(toStart, toLen);
                            s = String.valueOf(s) + fromDoc.get(fromStart, fromLen);
                        }
                    }
                    if (s != null) {
                        toDoc.replace(toStart, toLen, s);
                        toPos.setOffset(toStart);
                        toPos.setLength(s.length());
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            diff.setResolved(true);
            this.updateResolveStatus();
            return true;
        }
        return false;
    }

    private int getVirtualHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                h += diff.getMaxDiffHeight(this.fShowAncestor);
                ++i;
            }
        }
        return h;
    }

    private int getRightHeight() {
        int h = 1;
        if (this.fAllDiffs != null) {
            Iterator e = this.fAllDiffs.iterator();
            int i = 0;
            while (e.hasNext()) {
                Diff diff = (Diff)e.next();
                h += diff.getRightHeight();
                ++i;
            }
        }
        return h;
    }

    private int getViewportHeight() {
        StyledText te = this.fLeft.getTextWidget();
        int vh = te.getClientArea().height;
        if (vh == 0) {
            Rectangle trim = te.computeTrim(0, 0, 0, 0);
            int scrollbarHeight = trim.height;
            int headerHeight = this.getHeaderHeight();
            Composite composite = (Composite)this.getControl();
            Rectangle r = composite.getClientArea();
            vh = r.height - headerHeight - scrollbarHeight;
        }
        return vh / te.getLineHeight();
    }

    private int realToVirtualPosition(MergeSourceViewer w, int vpos) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return vpos;
        }
        int viewPos = 0;
        int virtualPos = 0;
        Point region = new Point(0, 0);
        Iterator e = this.fAllDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            Position pos = diff.getPosition(w);
            w.getLineRange(pos, region);
            int realHeight = region.y;
            int virtualHeight = diff.getMaxDiffHeight(this.fShowAncestor);
            if (vpos <= viewPos + realHeight) {
                vpos -= viewPos;
                vpos = realHeight <= 0 ? 0 : vpos * virtualHeight / realHeight;
                return virtualPos + vpos;
            }
            viewPos += realHeight;
            virtualPos += virtualHeight;
        }
        return virtualPos;
    }

    private void scrollVertical(int avpos, int lvpos, int rvpos, MergeSourceViewer allBut) {
        Control center;
        int y;
        int s = 0;
        if (this.fSynchronizedScrolling) {
            s = this.getVirtualHeight() - rvpos;
            int height = this.fRight.getViewportLines() / 4;
            if (s < 0) {
                s = 0;
            }
            if (s > height) {
                s = height;
            }
        }
        this.fInScrolling = true;
        if (this.isThreeWay() && allBut != this.fAncestor && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fAncestor, avpos + s) - s;
            this.fAncestor.vscroll(y);
        }
        if (allBut != this.fLeft && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fLeft, lvpos + s) - s;
            this.fLeft.vscroll(y);
        }
        if (allBut != this.fRight && (this.fSynchronizedScrolling || allBut == null)) {
            y = this.virtualToRealPosition(this.fRight, rvpos + s) - s;
            this.fRight.vscroll(y);
        }
        this.fInScrolling = false;
        if (this.isThreeWay() && this.fAncestorCanvas != null) {
            this.fAncestorCanvas.repaint();
        }
        if (this.fLeftCanvas != null) {
            this.fLeftCanvas.repaint();
        }
        if ((center = this.getCenter()) instanceof BufferedCanvas) {
            ((BufferedCanvas)center).repaint();
        }
        if (this.fRightCanvas != null) {
            this.fRightCanvas.repaint();
        }
    }

    private void syncViewport(MergeSourceViewer w) {
        if (this.fInScrolling) {
            return;
        }
        int ix = w.getTopIndex();
        int ix2 = w.getDocumentRegionOffset();
        int viewPosition = this.realToVirtualPosition(w, ix - ix2);
        this.scrollVertical(viewPosition, viewPosition, viewPosition, w);
        if (this.fVScrollBar != null) {
            int value = Math.max(0, Math.min(viewPosition, this.getVirtualHeight() - this.getViewportHeight()));
            this.fVScrollBar.setSelection(value);
        }
    }

    private void updateVScrollBar() {
        if (Utilities.okToUse((Widget)this.fVScrollBar) && this.fSynchronizedScrolling) {
            int virtualHeight = this.getVirtualHeight();
            int viewPortHeight = this.getViewportHeight();
            int pageIncrement = viewPortHeight - 1;
            int thumb = viewPortHeight > virtualHeight ? virtualHeight : viewPortHeight;
            this.fVScrollBar.setPageIncrement(pageIncrement);
            this.fVScrollBar.setMaximum(virtualHeight);
            this.fVScrollBar.setThumb(thumb);
        }
    }

    private int virtualToRealPosition(MergeSourceViewer part, int v) {
        if (!this.fSynchronizedScrolling || this.fAllDiffs == null) {
            return v;
        }
        int virtualPos = 0;
        int viewPos = 0;
        Point region = new Point(0, 0);
        Iterator e = this.fAllDiffs.iterator();
        while (e.hasNext()) {
            Diff diff = (Diff)e.next();
            Position pos = diff.getPosition(part);
            int viewHeight = part.getLineRange((Position)pos, (Point)region).y;
            int virtualHeight = diff.getMaxDiffHeight(this.fShowAncestor);
            if (v < virtualPos + virtualHeight) {
                v -= virtualPos;
                v = viewHeight <= 0 ? 0 : v * viewHeight / virtualHeight;
                return viewPos + v;
            }
            virtualPos += virtualHeight;
            viewPos += viewHeight;
        }
        return viewPos;
    }

    class HeaderPainter
    implements PaintListener {
        private static final int INSET = 2;
        private RGB fIndicatorColor;
        private Color fSeparatorColor;

        public HeaderPainter() {
            this.fSeparatorColor = TextMergeViewer.this.fSummaryHeader.getDisplay().getSystemColor(18);
        }

        public boolean setColor(RGB color) {
            RGB oldColor = this.fIndicatorColor;
            this.fIndicatorColor = color;
            if (color == null) {
                return oldColor != null;
            }
            if (oldColor != null) {
                return !color.equals((Object)oldColor);
            }
            return true;
        }

        private void drawBevelRect(GC gc, int x, int y, int w, int h, Color topLeft, Color bottomRight) {
            gc.setForeground(topLeft);
            gc.drawLine(x, y, x + w - 1, y);
            gc.drawLine(x, y, x, y + h - 1);
            gc.setForeground(bottomRight);
            gc.drawLine(x + w, y, x + w, y + h);
            gc.drawLine(x, y + h, x + w, y + h);
        }

        public void paintControl(PaintEvent e) {
            Point s = TextMergeViewer.this.fSummaryHeader.getSize();
            if (this.fIndicatorColor != null) {
                Display d = TextMergeViewer.this.fSummaryHeader.getDisplay();
                e.gc.setBackground(TextMergeViewer.this.getColor(d, this.fIndicatorColor));
                int min = Math.min(s.x, s.y) - 4;
                Rectangle r = new Rectangle((s.x - min) / 2, (s.y - min) / 2, min, min);
                e.gc.fillRectangle(r);
                if (d != null) {
                    this.drawBevelRect(e.gc, r.x, r.y, r.width - 1, r.height - 1, d.getSystemColor(18), d.getSystemColor(20));
                }
                e.gc.setForeground(this.fSeparatorColor);
                e.gc.setLineWidth(1);
                e.gc.drawLine(1, s.y - 1, s.x - 1 - 1, s.y - 1);
            }
        }
    }

    class ChildPositionUpdater
    extends DefaultPositionUpdater {
        protected ChildPositionUpdater(String category) {
            super(category);
        }

        protected boolean notDeleted() {
            return true;
        }

        protected void adaptToInsert() {
            if (this.fPosition == TextMergeViewer.this.fLeft.getRegion() || this.fPosition == TextMergeViewer.this.fRight.getRegion()) {
                int myStart = this.fPosition.offset;
                int myEnd = this.fPosition.offset + this.fPosition.length;
                myEnd = Math.max(myStart, myEnd);
                int yoursStart = this.fOffset;
                int yoursEnd = this.fOffset + this.fReplaceLength - 1;
                yoursEnd = Math.max(yoursStart, yoursEnd);
                if (myEnd < yoursStart) {
                    return;
                }
                if (myStart <= yoursStart) {
                    this.fPosition.length += this.fReplaceLength;
                } else {
                    this.fPosition.offset += this.fReplaceLength;
                }
            } else {
                super.adaptToInsert();
            }
        }
    }

    class Diff {
        Position fAncestorPos;
        Position fLeftPos;
        Position fRightPos;
        Diff fParent;
        boolean fResolved;
        int fDirection;
        boolean fIsToken = false;
        ArrayList fDiffs;
        boolean fIsWhitespace = false;

        Diff(Diff parent, int dir, IDocument ancestorDoc, Position aRange, int ancestorStart, int ancestorEnd, IDocument leftDoc, Position lRange, int leftStart, int leftEnd, IDocument rightDoc, Position rRange, int rightStart, int rightEnd) {
            this.fParent = parent != null ? parent : this;
            this.fDirection = dir;
            this.fLeftPos = this.createPosition(leftDoc, lRange, leftStart, leftEnd);
            this.fRightPos = this.createPosition(rightDoc, rRange, rightStart, rightEnd);
            if (ancestorDoc != null) {
                this.fAncestorPos = this.createPosition(ancestorDoc, aRange, ancestorStart, ancestorEnd);
            }
        }

        Position getPosition(char type) {
            switch (type) {
                case 'A': {
                    return this.fAncestorPos;
                }
                case 'L': {
                    return this.fLeftPos;
                }
                case 'R': {
                    return this.fRightPos;
                }
            }
            return null;
        }

        boolean isInRange(char type, int pos) {
            Position p = this.getPosition(type);
            return pos >= p.offset && pos < p.offset + p.length;
        }

        String changeType() {
            boolean rightEmpty;
            boolean leftEmpty = this.fLeftPos.length == 0;
            boolean bl = rightEmpty = this.fRightPos.length == 0;
            if (this.fDirection == 3) {
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            } else {
                if (leftEmpty && !rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_addition;
                }
                if (!leftEmpty && rightEmpty) {
                    return CompareMessages.TextMergeViewer_changeType_deletion;
                }
            }
            return CompareMessages.TextMergeViewer_changeType_change;
        }

        Image getImage() {
            int code = 3;
            switch (this.fDirection) {
                case 2: {
                    code += 4;
                    break;
                }
                case 3: {
                    code += 8;
                    break;
                }
                case 1: 
                case 4: {
                    code += 12;
                }
            }
            if (code != 0) {
                return TextMergeViewer.this.getCompareConfiguration().getImage(code);
            }
            return null;
        }

        Position createPosition(IDocument doc, Position range, int start, int end) {
            try {
                int dl;
                int l = end - start;
                if (range != null) {
                    dl = range.length;
                    if (l > dl) {
                        l = dl;
                    }
                } else {
                    dl = doc.getLength();
                    if (start + l > dl) {
                        l = dl - start;
                    }
                }
                Position p = null;
                try {
                    p = new Position(start, l);
                }
                catch (RuntimeException runtimeException) {}
                try {
                    doc.addPosition("DocumentRangeCategory", p);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                return p;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }

        void add(Diff d) {
            if (this.fDiffs == null) {
                this.fDiffs = new ArrayList();
            }
            this.fDiffs.add(d);
        }

        boolean isDeleted() {
            if (this.fAncestorPos != null && this.fAncestorPos.isDeleted()) {
                return true;
            }
            return this.fLeftPos.isDeleted() || this.fRightPos.isDeleted();
        }

        void setResolved(boolean r) {
            this.fResolved = r;
            if (r) {
                this.fDiffs = null;
            }
        }

        boolean isResolved() {
            if (!this.fResolved && this.fDiffs != null) {
                Iterator e = this.fDiffs.iterator();
                while (e.hasNext()) {
                    Diff d = (Diff)e.next();
                    if (d.isResolved()) continue;
                    return false;
                }
                return true;
            }
            return this.fResolved;
        }

        private boolean isIncomingOrConflicting() {
            switch (this.fDirection) {
                case 2: {
                    if (!TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 3: {
                    if (TextMergeViewer.this.fLeftIsLocal) break;
                    return true;
                }
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean isUnresolvedIncomingOrConflicting() {
            if (this.fResolved) {
                return false;
            }
            return this.isIncomingOrConflicting();
        }

        Position getPosition(MergeSourceViewer w) {
            if (w == TextMergeViewer.this.fLeft) {
                return this.fLeftPos;
            }
            if (w == TextMergeViewer.this.fRight) {
                return this.fRightPos;
            }
            if (w == TextMergeViewer.this.fAncestor) {
                return this.fAncestorPos;
            }
            return null;
        }

        boolean overlaps(MergeSourceViewer w, int start, int end) {
            int ds;
            int de;
            Position h = this.getPosition(w);
            return h != null && start < (de = (ds = h.getOffset()) + h.getLength()) && end >= ds;
        }

        int getMaxDiffHeight(boolean withAncestor) {
            Point region = new Point(0, 0);
            int h = ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)region).y;
            if (withAncestor) {
                h = Math.max(h, ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)region).y);
            }
            return Math.max(h, ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)region).y);
        }

        int getAncestorHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fAncestor.getLineRange((Position)this.fAncestorPos, (Point)region).y;
        }

        int getLeftHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fLeft.getLineRange((Position)this.fLeftPos, (Point)region).y;
        }

        int getRightHeight() {
            Point region = new Point(0, 0);
            return ((TextMergeViewer)TextMergeViewer.this).fRight.getLineRange((Position)this.fRightPos, (Point)region).y;
        }
    }

    class HoverResizer
    extends ContentMergeViewer.Resizer {
        Canvas fCanvas;

        public HoverResizer(Canvas c, int dir) {
            super((Control)c, dir);
            this.fCanvas = c;
        }

        public void mouseMove(MouseEvent e) {
            if (!this.fIsDown && TextMergeViewer.this.fUseSingleLine && TextMergeViewer.this.showResolveUI() && TextMergeViewer.this.handleMouseMoveOverCenter(this.fCanvas, e.x, e.y)) {
                return;
            }
            super.mouseMove(e);
        }
    }
}

