/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.views.markers.internal;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.markers.internal.ActionProblemProperties;
import org.eclipse.ui.views.markers.internal.ActionResolveMarker;
import org.eclipse.ui.views.markers.internal.DialogMarkerFilter;
import org.eclipse.ui.views.markers.internal.DialogProblemFilter;
import org.eclipse.ui.views.markers.internal.FieldCreationTime;
import org.eclipse.ui.views.markers.internal.FieldFolder;
import org.eclipse.ui.views.markers.internal.FieldLineNumber;
import org.eclipse.ui.views.markers.internal.FieldMessage;
import org.eclipse.ui.views.markers.internal.FieldResource;
import org.eclipse.ui.views.markers.internal.FieldSeverity;
import org.eclipse.ui.views.markers.internal.IField;
import org.eclipse.ui.views.markers.internal.MarkerFilter;
import org.eclipse.ui.views.markers.internal.MarkerList;
import org.eclipse.ui.views.markers.internal.MarkerView;
import org.eclipse.ui.views.markers.internal.Messages;
import org.eclipse.ui.views.markers.internal.ProblemFilter;
import org.eclipse.ui.views.markers.internal.TableSorter;

public class ProblemView
extends MarkerView {
    private final ColumnPixelData[] DEFAULT_COLUMN_LAYOUTS = new ColumnPixelData[]{new ColumnPixelData(16, false, true), new ColumnPixelData(200), new ColumnPixelData(75), new ColumnPixelData(150), new ColumnPixelData(60)};
    private static final int ASCENDING = 1;
    private static final int DESCENDING = -1;
    private final IField[] VISIBLE_FIELDS = new IField[]{new FieldSeverity(), new FieldMessage(), new FieldResource(), new FieldFolder(), new FieldLineNumber()};
    private final IField[] HIDDEN_FIELDS = new IField[]{new FieldCreationTime()};
    private static final int SEVERITY = 0;
    private static final int DESCRIPTION = 1;
    private static final int RESOURCE = 2;
    private static final int FOLDER = 3;
    private static final int LOCATION = 4;
    private static final int CREATION_TIME = 5;
    private static final int[] DEFAULT_PRIORITIES;
    private static final int[] DEFAULT_DIRECTIONS;
    private static final String[] ROOT_TYPES;
    private static final String TAG_DIALOG_SECTION = "org.eclipse.ui.views.problem";
    private ProblemFilter problemFilter = new ProblemFilter();
    private ActionResolveMarker resolveMarkerAction;
    private TableSorter sorter;

    static {
        int[] nArray = new int[6];
        nArray[1] = 3;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 1;
        nArray[5] = 5;
        DEFAULT_PRIORITIES = nArray;
        DEFAULT_DIRECTIONS = new int[]{-1, 1, 1, 1, 1, 1};
        ROOT_TYPES = new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    public void dispose() {
        if (this.resolveMarkerAction != null) {
            this.resolveMarkerAction.dispose();
        }
        super.dispose();
    }

    public void init(IViewSite viewSite, IMemento memento) throws PartInitException {
        super.init(viewSite, memento);
        this.problemFilter.restoreState(this.getDialogSettings());
    }

    public void saveState(IMemento memento) {
        this.problemFilter.saveState(this.getDialogSettings());
        super.saveState(memento);
    }

    protected ColumnPixelData[] getDefaultColumnLayouts() {
        return this.DEFAULT_COLUMN_LAYOUTS;
    }

    protected IDialogSettings getDialogSettings() {
        AbstractUIPlugin plugin = (AbstractUIPlugin)Platform.getPlugin((String)"org.eclipse.ui");
        IDialogSettings workbenchSettings = plugin.getDialogSettings();
        IDialogSettings settings = workbenchSettings.getSection(TAG_DIALOG_SECTION);
        if (settings == null) {
            settings = workbenchSettings.addNewSection(TAG_DIALOG_SECTION);
        }
        return settings;
    }

    protected void createActions() {
        super.createActions();
        this.propertiesAction = new ActionProblemProperties((IWorkbenchPart)this, this.getSelectionProvider());
        this.resolveMarkerAction = new ActionResolveMarker((IWorkbenchPart)this, this.getSelectionProvider());
    }

    protected void createColumns(Table table) {
        super.createColumns(table);
        TableColumn[] columns = table.getColumns();
        if (columns != null && columns.length >= 1) {
            columns[0].setResizable(false);
        }
    }

    protected void fillContextMenuAdditions(IMenuManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.resolveMarkerAction);
    }

    protected DialogMarkerFilter getFiltersDialog() {
        return new DialogProblemFilter(this.getViewer().getControl().getShell(), this.problemFilter);
    }

    protected IField[] getHiddenFields() {
        return this.HIDDEN_FIELDS;
    }

    protected String[] getRootTypes() {
        return ROOT_TYPES;
    }

    protected TableSorter getSorter() {
        if (this.sorter == null) {
            this.sorter = new TableSorter(this.getFields(), DEFAULT_PRIORITIES, DEFAULT_DIRECTIONS);
        }
        return this.sorter;
    }

    protected Object getViewerInput() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    protected IField[] getVisibleFields() {
        return this.VISIBLE_FIELDS;
    }

    protected void initMenu(IMenuManager menu) {
        super.initMenu(menu);
    }

    void updateTitle() {
        int totalCount;
        MarkerList visibleMarkers = this.getVisibleMarkers();
        String breakdown = this.formatSummaryBreakDown(visibleMarkers);
        int filteredCount = visibleMarkers.getItemCount();
        if (filteredCount != (totalCount = this.getTotalMarkers())) {
            breakdown = Messages.format("problem.filter.matchedMessage", new Object[]{breakdown, new Integer(filteredCount), new Integer(totalCount)});
        }
        this.setContentDescription(breakdown);
    }

    private String formatSummaryBreakDown(MarkerList visibleMarkers) {
        return Messages.format("problem.statusSummaryBreakdown", new Object[]{new Integer(visibleMarkers.getErrors()), new Integer(visibleMarkers.getWarnings()), new Integer(visibleMarkers.getInfos())});
    }

    private String getSummary(MarkerList markers, String messageKey) {
        String message = Messages.format(messageKey, new Object[]{new Integer(markers.getItemCount()), this.formatSummaryBreakDown(markers)});
        return message;
    }

    protected String updateSummarySelected(IStructuredSelection selection) {
        return this.getSummary(new MarkerList(selection.toList()), "problem.statusSummarySelected");
    }

    protected String[] getMarkerTypes() {
        return new String[]{"org.eclipse.core.resources.problemmarker"};
    }

    protected MarkerFilter getFilter() {
        return this.problemFilter;
    }

    public void openFiltersDialog() {
        DialogProblemFilter dialog = new DialogProblemFilter(this.getViewer().getControl().getShell(), this.problemFilter);
        if (dialog.open() == 0) {
            this.problemFilter = (ProblemFilter)dialog.getFilter();
            this.problemFilter.saveState(this.getDialogSettings());
            this.refresh();
        }
    }

    protected void updateFilterSelection(IResource[] resources) {
        this.problemFilter.setFocusResource(resources);
    }

    protected String getStaticContextId() {
        return "org.eclipse.ui.problem_view_context";
    }
}

